---
generated_at: 2026-01-30 18:30:00
metrics:
  claims_total: 152
  claims_with_evidence: 148
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：src-core 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：148 / 152、根拠なし：4
- 優先レビュー（高）
  1. **C-131 ArrayBufferAllocator::Create**：内部実装の詳細が確認できない
  2. **C-133 MultiIsolatePlatform::Create**：プラットフォーム初期化の詳細が確認できない
  3. **C-141 node::Start**：メインエントリポイントの完全な動作フロー
  4. **C-142 node::Stop**：停止処理の完全なフロー

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/node_buffer.cc` - Buffer関連の実装
- E-02: `src/node_buffer.h` - Buffer関連のヘッダー
- E-03: `src/string_bytes.cc` - 文字列バイト変換実装
- E-04: `src/string_bytes.h` - 文字列バイト変換ヘッダー
- E-05: `src/async_wrap.cc` - AsyncWrap実装
- E-06: `src/async_wrap.h` - AsyncWrapヘッダー
- E-07: `src/node_url.cc` - URL処理実装
- E-08: `src/node_url.h` - URL処理ヘッダー
- E-09: `src/util.cc` - ユーティリティ実装
- E-10: `src/util.h` - ユーティリティヘッダー
- E-11: `src/node.cc` - Node.jsコア実装
- E-12: `src/node.h` - Node.jsコアヘッダー
- E-13: `src/env.h` - Environment定義
- E-14: `src/env-inl.h` - Environment インライン実装
- E-15: `src/base_object.h` - BaseObject定義
- E-16: `src/base_object.cc` - BaseObject実装
- E-17: `src/stream_base.cc` - StreamBase実装
- E-18: `src/stream_base.h` - StreamBaseヘッダー
- E-19: `src/node_errors.cc` - エラー処理実装
- E-20: `src/node_errors.h` - エラー処理ヘッダー
- E-21: `src/node_file.cc` - ファイル操作実装
- E-22: `src/node_file.h` - ファイル操作ヘッダー

## 3) Claims と根拠の対応（レビューの主戦場）

### Buffer関連 (C-01 〜 C-15)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Buffer::HasInstance(Local<Value>)がArrayBufferViewを判定する | E-01 (L240-242) | ○ |
| C-02 | 非ArrayBufferViewでfalseが返される | E-01 (L240-242) | ○ |
| C-03 | Buffer::DataがArrayBufferViewのデータポインタを返す | E-01 (L250-254) | ○ |
| C-04 | 非ArrayBufferViewでCHECKが発生する | E-01 (L251) | ○ |
| C-05 | Buffer::LengthがByteLength()を返す | E-01 (L262-266) | ○ |
| C-06 | 空のArrayBufferViewで0が返される | E-01 (L265) | ○ |
| C-07 | Buffer::NewがUint8Arrayを作成する | E-01 (L276-287) | ○ |
| C-08 | buffer_prototype_objectが空でエラー | E-01 (L280) | ○ |
| C-09 | CallbackInfo::CreateTrackedArrayBufferが追跡付きバッファを作成 | E-01 (L117-145) | ○ |
| C-10 | data=nullptrの場合の処理 | E-01 (L133-137) | ○ |
| C-11 | OnBackingStoreFree時のコールバック実行 | E-01 (L191-206) | ○ |
| C-12 | Clean時のDetach処理 | E-01 (L160-173) | ○ |
| C-13 | ParseArrayIndexの正常系 | E-01 (L211-234) | ○ |
| C-14 | 負のインデックスでfalse | E-01 (L224-225) | ○ |
| C-15 | undefinedでデフォルト値使用 | E-01 (L215-218) | ○ |

### StringBytes関連 (C-16 〜 C-26)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | ASCII文字列の書き込み | E-03 (L250-265) | ○ |
| C-17 | UTF8文字列の書き込み | E-03 (L267-271) | ○ |
| C-18 | LATIN1文字列の書き込み | E-03 (L250-265) | ○ |
| C-19 | UCS2文字列の書き込み | E-03 (L273-282) | ○ |
| C-20 | BASE64URLデコード | E-03 (L285-300) | ○ |
| C-21 | WriteUCS2のアラインメント処理 | E-03 (L206-236) | ○ |
| C-22 | buflen=0の場合 | E-03 (L245) | ○ |
| C-23 | 短い文字列のコピー作成 | E-03 (L76-85) | ○ |
| C-24 | 長い文字列のExternalString作成 | E-03 (L97-122) | ○ |
| C-25 | 空文字列でString::Empty返却 | E-03 (L79-81, L101-102) | ○ |
| C-26 | メモリ割り当て失敗時の例外 | E-03 (L87-90) | ○ |

### AsyncWrap関連 (C-27 〜 C-38)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | DestroyAsyncIdsCallbackの動作 | E-05 (L68-90) | ○ |
| C-28 | can_call_into_js=falseで早期リターン | E-05 (L77) | ○ |
| C-29 | EmitPromiseResolveの動作 | E-05 (L107-110) | ○ |
| C-30 | EmitBeforeの動作 | E-05 (L141-144) | ○ |
| C-31 | EmitAfterの動作 | E-05 (L163-168) | ○ |
| C-32 | GetAsyncIdの正常系 | E-05 (L269-274) | ○ |
| C-33 | GetAsyncIdの異常系 | E-05 (L271) | ○ |
| C-34 | PushAsyncContextの動作 | E-05 (L277-284) | ○ |
| C-35 | PopAsyncContextの正常系 | E-05 (L287-291) | ○ |
| C-36 | PopAsyncContextの異常系 | E-05 (L290) | ○ |
| C-37 | WeakCallbackの動作 | E-05 (L229-249) | ○ |
| C-38 | RegisterDestroyHookの動作 | E-05 (L252-267) | ○ |

### URL関連 (C-39 〜 C-53)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | PathToFileURLのPOSIXパス変換 | E-07 (L147-182) | ○ |
| C-40 | PathToFileURLのWindowsパス変換 | E-07 (L147-182) | ○ |
| C-41 | PathToFileURLの無効パスエラー | E-07 (L164-166) | ○ |
| C-42 | DomainToASCIIの動作 | E-07 (L184-209) | ○ |
| C-43 | DomainToASCIIの空文字列処理 | E-07 (L190-192) | ○ |
| C-44 | DomainToASCIIの無効ドメイン | E-07 (L199-201) | ○ |
| C-45 | DomainToUnicodeの動作 | E-07 (L211-236) | ○ |
| C-46 | GetOriginの動作 | E-07 (L238-261) | ○ |
| C-47 | GetOriginの無効URL | E-07 (L249-252) | ○ |
| C-48 | CanParseの有効URL | E-07 (L263-284) | ○ |
| C-49 | CanParseのベースURL解決 | E-07 (L275-279) | ○ |
| C-50 | CanParseの無効URL | E-07 (L280-281) | ○ |
| C-51 | FastCanParseの動作 | E-07 (L286-300) | ○ |
| C-52 | EncodePathCharsの特殊文字エンコード | E-07 (L126-145) | ○ |
| C-53 | EncodePathCharsのWindowsバックスラッシュ変換 | E-07 (L135-140) | ○ |

### Utility関連 (C-54 〜 C-76)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | Utf8Value::constructorの動作 | E-09 (L133-138) | ○ |
| C-55 | Utf8Value空Local処理 | E-09 (L134-135) | ○ |
| C-56 | Utf8Valueマルチバイト処理 | E-09 (L100-131) | ○ |
| C-57 | TwoByteValue::constructorの動作 | E-09 (L141-154) | ○ |
| C-58 | BufferValueのString処理 | E-09 (L166-167) | ○ |
| C-59 | BufferValueのArrayBufferView処理 | E-09 (L168-173) | ○ |
| C-60 | BufferValueの無効型処理 | E-09 (L174-176) | ○ |
| C-61 | LowMemoryNotificationの動作 | E-09 (L179-186) | ○ |
| C-62 | LowMemoryNotificationの未初期化時 | E-09 (L180) | ○ |
| C-63 | GetProcessTitleの動作 | E-09 (L188-211) | ○ |
| C-64 | GetProcessTitleのエラー時 | E-09 (L200-201) | ○ |
| C-65 | GetHumanReadableProcessNameの動作 | E-09 (L213-215) | ○ |
| C-66 | ThrowErrStringTooLongの動作 | E-09 (L217-219) | ○ |
| C-67 | GetCurrentTimeInMicrosecondsの動作 | E-09 (L221-226) | ○ |
| C-68 | WriteFileSyncの正常系 | E-09 (L228-254) | ○ |
| C-69 | WriteFileSyncのエラー処理 | E-09 (L241-243, L247-249) | ○ |
| C-70 | ReadFileSyncの正常系 | E-09 (L264-301) | ○ |
| C-71 | ReadFileSyncのエラー処理 | E-09 (L271-273, L290-292) | ○ |
| C-72 | DiagnosticFilename::MakeFilenameの動作 | E-09 (L329-371) | ○ |
| C-73 | DiagnosticFilename::LocalTimeの動作 | E-09 (L318-326) | ○ |
| C-74 | NewFunctionTemplateの動作 | E-09 (L373-388) | ○ |
| C-75 | SetMethodの動作 | E-09 (L390-410) | ○ |
| C-76 | SetFastMethodの動作 | E-09 (L430-448) | ○ |

### StreamBase関連 (C-77 〜 C-85)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | StreamBase::Shutdownの正常系 | E-17 (L44-81) | ○ |
| C-78 | StreamBase::Shutdownのエラー処理 | E-17 (L64-67) | ○ |
| C-79 | StreamBase::Writeの正常系 | E-17 (L83-139) | ○ |
| C-80 | StreamBase::WriteのTryWrite | E-17 (L95-100) | ○ |
| C-81 | StreamBase::Writeのエラー文字列設定 | E-17 (L125-135) | ○ |
| C-82 | ReadStartJSの動作 | E-17 (L151-153) | ○ |
| C-83 | ReadStopJSの動作 | E-17 (L156-158) | ○ |
| C-84 | UseUserBufferの動作 | E-17 (L160-166) | ○ |
| C-85 | Writevの動作 | E-17 (L180-200) | ○ |

### BaseObject関連 (C-86 〜 C-93)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | BaseObject::constructorの動作 | E-15 (L46-57) | ○ |
| C-87 | FromJSObjectの正常系 | E-15 (L86-88) | ○ |
| C-88 | FromJSObjectの未初期化 | E-15 (L73-76) | ○ |
| C-89 | MakeWeakの動作 | E-15 (L98) | ○ |
| C-90 | ClearWeakの動作 | E-15 (L102) | ○ |
| C-91 | IsWeakOrDetachedの動作 | E-15 (L107) | ○ |
| C-92 | Detachの動作 | E-15 (L130) | ○ |
| C-93 | GetTransferModeのデフォルト | E-15 (L171) | ○ |

### エラー処理関連 (C-94 〜 C-99)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | IsExceptionDecoratedの装飾済み | E-19 (L40-49) | ○ |
| C-95 | IsExceptionDecoratedの未装飾 | E-19 (L40-49) | ○ |
| C-96 | GetErrorSourceの動作 | E-19 (L89-194) | ○ |
| C-97 | GetErrorSourceのソースマップ対応 | E-19 (L105-114) | ○ |
| C-98 | GetCurrentStackTraceの動作 | E-19 (L198-200) | ○ |
| C-99 | GetCurrentStackTraceのnull安全 | E-19 (L199-200) | ○ |

### IsolateData/AsyncHooks関連 (C-100 〜 C-113)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | IsolateData::CreateIsolateDataの動作 | E-13 (L137-144) | ○ |
| C-101 | is_building_snapshotの動作 | E-13 (L152) | ○ |
| C-102 | Serializeの動作 | E-13 (L150) | ○ |
| C-103 | AsyncHooks::push_async_contextの動作 | E-13 (L327-331) | ○ |
| C-104 | AsyncHooks::pop_async_contextの正常系 | E-13 (L332) | ○ |
| C-105 | AsyncHooks::pop_async_contextの異常系 | E-13 (L379) | ○ |
| C-106 | clear_async_id_stackの動作 | E-13 (L333) | ○ |
| C-107 | InstallPromiseHooksの動作 | E-13 (L311) | ○ |
| C-108 | ResetPromiseHooksの動作 | E-13 (L312-315) | ○ |
| C-109 | ImmediateInfo::countの動作 | E-13 (L411) | ○ |
| C-110 | ImmediateInfo::ref_count_incの動作 | E-13 (L414) | ○ |
| C-111 | ImmediateInfo::ref_count_decの動作 | E-13 (L415) | ○ |
| C-112 | TickInfo::has_tick_scheduledの動作 | E-13 (L446) | ○ |
| C-113 | TickInfo::has_rejection_to_warnの動作 | E-13 (L447) | ○ |

### Node.jsコア関連 (C-114 〜 C-152)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 | StartExecutionの動作 | E-11 (L249-255) | ○ |
| C-115 | StartExecutionコールバック付き | E-11 (L288-324) | ○ |
| C-116 | StartExecutionワーカースレッド | E-11 (L358-359) | ○ |
| C-117 | CallbackInfoFromArrayの動作 | E-11 (L260-286) | ○ |
| C-118 | CallbackInfoFromArrayのエラー | E-11 (L266-270) | ○ |
| C-119 | RegisterSignalHandlerの動作 | E-11 (L452-481) | ○ |
| C-120 | RegisterSignalHandlerのWASM対応 | E-11 (L456-464) | ○ |
| C-121 | ResetSignalHandlersの動作 | E-11 (L493-500) | ○ |
| C-122 | TrapWebAssemblyOrContinueの動作 | E-11 (L426-447) | ○ |
| C-123 | Environment::InitializeInspectorの動作 | E-11 (L191-220) | ○ |
| C-124 | Environment::InitializeDiagnosticsの動作 | E-11 (L235-246) | ○ |
| C-125 | trace_uncaught有効時の動作 | E-11 (L241-242) | ○ |
| C-126 | InitializeOncePerProcessの動作 | E-12 (L308-312) | ○ |
| C-127 | InitializeOncePerProcessのフラグ | E-12 (L309-311) | ○ |
| C-128 | TearDownOncePerProcessの動作 | E-12 (L314) | ○ |
| C-129 | ProcessGlobalArgsの動作 | E-12 (L342-345) | ○ |
| C-130 | ProcessGlobalArgsのエラー | E-12 (L344) | ○ |
| C-131 | ArrayBufferAllocator::Createの動作 | E-12 (L361-362) | △ |
| C-132 | ArrayBufferAllocator::Createデバッグモード | E-12 (L361) | ○ |
| C-133 | MultiIsolatePlatform::Createの動作 | E-12 (L418-421) | △ |
| C-134 | FlushForegroundTasksの動作 | E-12 (L386) | ○ |
| C-135 | DrainTasksの動作 | E-12 (L387) | ○ |
| C-136 | RegisterIsolateの動作 | E-12 (L394-401) | ○ |
| C-137 | UnregisterIsolateの動作 | E-12 (L406) | ○ |
| C-138 | InitializationResult::exit_codeの動作 | E-12 (L270) | ○ |
| C-139 | InitializationResult::early_returnの動作 | E-12 (L273) | ○ |
| C-140 | InitializationResult::argsの動作 | E-12 (L276) | ○ |
| C-141 | node::Startの動作 | E-12 (L296) | △ |
| C-142 | node::Stopの動作 | E-12 (L300-301) | △ |
| C-143 | node::Stopのフラグ | E-12 (L301) | ○ |
| C-144 | fs::GetOffsetの動作 | E-21 (L100-102) | ○ |
| C-145 | fs::GetOffsetの境界値 | E-21 (L101) | ○ |
| C-146 | get_fs_func_name_by_typeの動作 | E-21 (L104-146) | ○ |
| C-147 | get_fs_func_name_by_typeの不明タイプ | E-21 (L143-144) | ○ |
| C-148 | keep_buflen_in_rangeのオーバーフロー | E-03 (L199-204) | ○ |
| C-149 | keep_buflen_in_rangeの正常パス | E-03 (L199-204) | ○ |
| C-150 | ErrnoExceptionの動作 | E-12 (L141-145) | ○ |
| C-151 | UVExceptionの動作 | E-12 (L146-151) | ○ |
| C-152 | UVExceptionのパス情報 | E-12 (L150-151) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-131 ArrayBufferAllocator::Create**: ヘッダーには宣言があるが、実装の詳細（always_debugフラグの処理）が確認できない。実装ファイルが別モジュール（src-api）にある可能性
  - 候補：`src/api/environment.cc` / `src/node_internals.cc`
- **C-133 MultiIsolatePlatform::Create**: プラットフォーム初期化の完全なフローが確認できない。実装が`src/node_platform.cc`にある
  - 候補：`src/node_platform.cc`
- **C-141 node::Start**: メインエントリポイントは宣言のみ確認。完全な実装フローの確認が必要
  - 候補：`src/node_main.cc` / `src/node.cc`
- **C-142 node::Stop**: 停止処理の完全なフローが確認できない
  - 候補：`src/node.cc` / `src/api/embed_helpers.cc`

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: Buffer関連、StringBytes関連 - 実装が明確で十分なテストカバレッジが期待できる
- **0 (低リスク)**: AsyncWrap関連 - コールバック処理は複雑だが実装が明確
- **0 (低リスク)**: URL関連 - adaライブラリを使用しており動作が明確
- **1 (中リスク)**: IsolateData/AsyncHooks関連 - スレッドセーフティの考慮が必要
- **1 (中リスク)**: StreamBase関連 - 非同期処理のテストが複雑になる可能性
- **2 (高リスク)**: Node.jsプロセス初期化/停止 - 完全なフローの確認が必要、実際の動作テストが重要

## 6) レビュアーチェックリスト（最小）
- [ ] Buffer操作のメモリ安全性（C-01〜C-15）が適切にテストされているか
- [ ] StringBytesのエンコーディング処理（C-16〜C-26）が全エンコーディングタイプをカバーしているか
- [ ] AsyncWrapのライフサイクル管理（C-27〜C-38）が正しくテストされているか
- [ ] URL処理（C-39〜C-53）がRFC準拠であることを確認するテストがあるか
- [ ] エラー処理（C-94〜C-99）が例外安全であることを確認するテストがあるか
- [ ] プロセス初期化/停止（C-126〜C-143）の統合テストが必要か検討
- [ ] C++のメモリ管理（RAII、スマートポインタ）が適切に考慮されているか
- [ ] マルチスレッド環境でのテスト（IsolateData、AsyncHooks）が必要か検討
