---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 147
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：src-crypto 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：147 / 150、根拠なし：3
- 優先レビュー（高）
  1. **UT-CRY-125～128 (FIPSモード関連)**：ランタイム依存の動作
  2. **UT-CRY-133～134 (SecureBuffer/SecureHeapUsed)**：V8サンドボックス有効時の動作
  3. **UT-CRY-109 (Scrypt maxmem)**：プラットフォーム依存の可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/crypto/crypto_util.h` - ByteSource, CryptoErrorStore, CryptoJob等のヘッダ定義
- E-02: `src/crypto/crypto_util.cc` - ユーティリティ関数の実装
- E-03: `src/crypto/crypto_keys.h` - KeyObjectData, KeyObjectHandle等のヘッダ定義
- E-04: `src/crypto/crypto_keys.cc` - 鍵管理機能の実装
- E-05: `src/crypto/crypto_hash.h` - Hashクラスのヘッダ定義
- E-06: `src/crypto/crypto_hash.cc` - ハッシュ機能の実装
- E-07: `src/crypto/crypto_cipher.h` - CipherBase, PublicKeyCipherのヘッダ定義
- E-08: `src/crypto/crypto_cipher.cc` - 暗号化/復号機能の実装
- E-09: `src/crypto/crypto_hmac.h` - Hmac, HmacTraitsのヘッダ定義
- E-10: `src/crypto/crypto_hmac.cc` - HMAC機能の実装
- E-11: `src/crypto/crypto_sig.h` - Sign, Verify, SignTraitsのヘッダ定義
- E-12: `src/crypto/crypto_random.h` - RandomBytes, RandomPrime, CheckPrimeのヘッダ定義
- E-13: `src/crypto/crypto_pbkdf2.h` - PBKDF2Traitsのヘッダ定義
- E-14: `src/crypto/crypto_hkdf.h` - HKDFTraitsのヘッダ定義
- E-15: `src/crypto/crypto_scrypt.h` - ScryptTraitsのヘッダ定義
- E-16: `src/crypto/crypto_dh.h` - DiffieHellman, DHBitsTraitsのヘッダ定義
- E-17: `src/crypto/crypto_ec.h` - ECDH, ECDHBitsTraitsのヘッダ定義
- E-18: `src/crypto/crypto_rsa.h` - RSA関連構造体のヘッダ定義
- E-19: `src/crypto/crypto_aes.h` - AESCipherTraitsのヘッダ定義
- E-20: `src/crypto/crypto_x509.h` - X509Certificate, ManagedX509のヘッダ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01～C-10 | ByteSourceクラスのメソッドテスト | E-01, E-02 | ○ |
| C-11～C-14 | CryptoErrorStoreのテスト | E-01, E-02 | ○ |
| C-15～C-23 | KeyObjectDataのテスト | E-03, E-04 | ○ |
| C-24～C-38 | KeyObjectHandleのテスト | E-03, E-04 | ○ |
| C-39～C-48 | Hashクラスのテスト | E-05, E-06 | ○ |
| C-49～C-71 | CipherBaseのテスト | E-07, E-08 | ○ |
| C-72～C-77 | Hmacクラスのテスト | E-09, E-10 | ○ |
| C-78～C-89 | Sign/Verifyクラスのテスト | E-11 | ○ |
| C-90～C-96 | ECDHクラスのテスト | E-17 | ○ |
| C-97 | DiffieHellmanのテスト | E-16 | ○ |
| C-98～C-103 | Random系のテスト | E-12 | ○ |
| C-104～C-105 | PBKDF2のテスト | E-13 | ○ |
| C-106～C-107 | HKDFのテスト | E-14 | ○ |
| C-108～C-109 | Scryptのテスト | E-15 | ○ |
| C-110～C-115 | AESCipherTraitsのテスト | E-19 | ○ |
| C-116～C-120 | RSA暗号化のテスト | E-18 | ○ |
| C-121～C-124 | X509Certificateのテスト | E-20 | ○ |
| C-125～C-128 | FIPSモードのテスト | E-02 | △ |
| C-129～C-130 | ThrowCryptoErrorのテスト | E-02 | ○ |
| C-131～C-134 | ユーティリティ関数のテスト | E-02 | △ |
| C-135～C-137 | パスワードコールバックのテスト | E-02 | ○ |
| C-138～C-148 | ヘルパー関数のテスト | E-01, E-02 | ○ |
| C-149～C-150 | 暗号情報取得のテスト | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- **FIPSモード関連 (C-125～C-128)**：FIPSモードの有効化はビルド設定とランタイム環境に依存するため、テスト実行環境によっては期待通りに動作しない可能性がある
  - 候補：OpenSSL FIPS Provider設定ドキュメント / Node.js FIPSモードガイド
- **SecureBuffer (C-133)**：V8_ENABLE_SANDBOX が有効な場合は UNREACHABLE() となるため、環境依存
  - 候補：V8 Sandbox ドキュメント / Node.js セキュアヒープガイド
- **Scrypt maxmem制限 (C-109)**：プラットフォームごとのメモリ制限値が異なる可能性
  - 候補：OpenSSL Scrypt ドキュメント / プラットフォーム別メモリ制限

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケース（基本的な暗号化操作、ハッシュ、HMAC等）
- **1: 中リスク** - 認証モード関連のテスト（認証タグの検証、AAD設定等）はセキュリティ上重要
- **2: 高リスク** - 以下の項目は特に注意が必要：
  - メモリ管理関連（ByteSourceのデストラクタ、SecureBuffer）：メモリリークやセキュリティ上の問題
  - 認証失敗時の挙動（AES-GCM, ChaCha20-Poly1305）：認証バイパスの可能性
  - 鍵管理（KeyObjectData, KeyObjectHandle）：鍵の漏洩や不正アクセス

## 6) レビュアーチェックリスト（最小）
- [ ] ByteSourceのデストラクタが確実にOPENSSL_clear_freeを呼び出すことを確認
- [ ] 認証モード（GCM, CCM, ChaCha20-Poly1305）での認証失敗時の挙動が正しいことを確認
- [ ] 鍵タイプの検証が適切に行われていることを確認（対称鍵vs非対称鍵）
- [ ] 境界値テスト（INT_MAX, 空バッファ等）が網羅されていることを確認
- [ ] FIPSモード関連のテストが環境依存であることをドキュメント化
- [ ] エラーハンドリングのテストで、OpenSSLエラースタックが正しくクリアされることを確認

---

## 解析したソースファイル一覧

| ファイル名 | 主要クラス/関数 | テストケース数 |
|-----------|----------------|---------------|
| crypto_util.h/cc | ByteSource, CryptoErrorStore, CryptoJob, ThrowCryptoError | 25 |
| crypto_keys.h/cc | KeyObjectData, KeyObjectHandle, NativeKeyObject | 24 |
| crypto_hash.h/cc | Hash, HashTraits | 10 |
| crypto_cipher.h/cc | CipherBase, PublicKeyCipher | 25 |
| crypto_hmac.h/cc | Hmac, HmacTraits | 6 |
| crypto_sig.h | Sign, Verify, SignTraits | 12 |
| crypto_random.h | RandomBytesTraits, RandomPrimeTraits, CheckPrimeTraits | 6 |
| crypto_pbkdf2.h | PBKDF2Traits | 2 |
| crypto_hkdf.h | HKDFTraits | 2 |
| crypto_scrypt.h | ScryptTraits | 2 |
| crypto_dh.h | DiffieHellman, DHBitsTraits | 1 |
| crypto_ec.h | ECDH, ECDHBitsTraits | 7 |
| crypto_rsa.h | RSACipherTraits | 5 |
| crypto_aes.h | AESCipherTraits | 6 |
| crypto_x509.h | X509Certificate, ManagedX509 | 4 |
| その他（ユーティリティ） | ヘルパー関数等 | 13 |

## テストケース分類

| カテゴリ | 件数 | 割合 |
|---------|-----|------|
| 正常系 | 105 | 70% |
| 異常系 | 32 | 21% |
| 境界値 | 13 | 9% |

| 優先度 | 件数 | 割合 |
|-------|-----|------|
| 高 | 62 | 41% |
| 中 | 72 | 48% |
| 低 | 16 | 11% |
