---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 90
  claims_with_evidence: 88
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：src-dataqueue 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：88 / 90、根拠なし：2
- 優先レビュー（高）
  1. **UT-DQ-079**：ファイル読み取りの非同期動作の詳細確認が必要
  2. **UT-DQ-090**：Vec構造体の使用パターンの網羅性要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/dataqueue/queue.h` - DataQueueクラス定義、インターフェース宣言
- E-02: `src/dataqueue/queue.cc` - DataQueueImpl、各種Entry実装
- E-03: `src/dataqueue/queue.h:127-302` - DataQueueクラスのpublic API
- E-04: `src/dataqueue/queue.cc:39-202` - DataQueueImpl実装
- E-05: `src/dataqueue/queue.cc:204-354` - IdempotentDataQueueReader実装
- E-06: `src/dataqueue/queue.cc:356-522` - NonIdempotentDataQueueReader実装
- E-07: `src/dataqueue/queue.cc:538-594` - EmptyEntry実装
- E-08: `src/dataqueue/queue.cc:600-716` - InMemoryEntry実装
- E-09: `src/dataqueue/queue.cc:722-799` - DataQueueEntry実装
- E-10: `src/dataqueue/queue.cc:811-1063` - FdEntry実装
- E-11: `src/dataqueue/queue.cc:1069-1098` - CreateIdempotent実装
- E-12: `src/dataqueue/queue.cc:1100-1102` - Create実装
- E-13: `src/dataqueue/queue.cc:1104-1119` - CreateInMemoryEntryFromView実装
- E-14: `src/dataqueue/queue.cc:1121-1129` - CreateInMemoryEntryFromBackingStore実装
- E-15: `src/dataqueue/queue.cc:1131-1134` - CreateDataQueueEntry実装
- E-16: `src/dataqueue/queue.cc:1136-1139` - CreateFdEntry実装
- E-17: `src/dataqueue/queue.h:129-132` - Vec構造体定義
- E-18: `src/dataqueue/queue.h:138-142` - Reader抽象クラス定義
- E-19: `src/dataqueue/queue.h:147-150` - BackpressureListener定義
- E-20: `src/dataqueue/queue.h:155-189` - Entry抽象クラス定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateIdempotent正常系 - 冪等なDataQueueが生成される | E-11 (1069-1098行) | ○ |
| C-02 | CreateIdempotent異常系 - 非冪等Entry含有でnullptr | E-11 (1075-1077行: is_idempotentチェック) | ○ |
| C-03 | CreateIdempotent異常系 - nullptr Entry含有でnullptr | E-11 (1075行: nullチェック) | ○ |
| C-04 | CreateIdempotent異常系 - サイズ不明Entry含有でnullptr | E-11 (1084-1088行: sizeチェック) | ○ |
| C-05 | CreateIdempotent境界値 - 空リスト | E-11 (1097行: 空リストでも生成) | ○ |
| C-06 | Create正常系 - 非冪等DataQueue生成 | E-12 (1100-1102行) | ○ |
| C-07 | Create正常系 - キャップ付きDataQueue生成 | E-04 (54-55行: コンストラクタでcap受取) | ○ |
| C-08 | CreateInMemoryEntryFromView正常系 | E-13 (1104-1119行) | ○ |
| C-09 | CreateInMemoryEntryFromView異常系 - デタッチ不可 | E-13 (1111-1113行: IsDetachableチェック) | ○ |
| C-10 | CreateInMemoryEntryFromBackingStore正常系 | E-14 (1121-1129行) | ○ |
| C-11 | CreateInMemoryEntryFromBackingStore異常系 - 範囲超過 | E-14 (1125-1127行: 範囲チェック) | ○ |
| C-12 | CreateDataQueueEntry正常系 | E-15 (1131-1134行) | ○ |
| C-13 | CreateFdEntry正常系 | E-16 (1136-1139行), E-10 (822-832行) | ○ |
| C-14 | CreateFdEntry異常系 - ファイル不存在 | E-10 (828行: stat失敗でnullptr) | ○ |
| C-15 | slice正常系 - 冪等DataQueue | E-04 (63-104行) | ○ |
| C-16 | slice正常系 - end省略 | E-04 (75行: maybeEnd.value_or(size)) | ○ |
| C-17 | slice異常系 - 非冪等でnullptr | E-04 (68行: idempotent_チェック) | ○ |
| C-18 | slice異常系 - サイズ不明でnullptr | E-04 (68行: size_チェック) | ○ |
| C-19 | slice境界値 - start超過 | E-04 (73行: start = min(start, size)) | ○ |
| C-20 | size正常系 - 冪等DataQueue | E-04 (106行) | ○ |
| C-21 | size正常系 - 非冪等DataQueue | E-04 (106行, 127行で累積) | ○ |
| C-22 | size異常系 - サイズ不明Entry追加後 | E-04 (131行: size_ = nullopt) | ○ |
| C-23 | is_idempotent - 冪等判定 | E-04 (108行) | ○ |
| C-24 | is_idempotent - 非冪等判定 | E-04 (108行, 45行でidempotent_設定) | ○ |
| C-25 | append正常系 | E-04 (112-136行) | ○ |
| C-26 | append異常系 - 冪等への追加 | E-04 (113行: if idempotent return nullopt) | ○ |
| C-27 | append異常系 - nullptr追加 | E-04 (114行: if !entry return false) | ○ |
| C-28 | append異常系 - キャップ超過 | E-04 (123-126行: キャップチェック) | ○ |
| C-29 | cap正常系 | E-04 (138-149行) | ○ |
| C-30 | cap再キャップ | E-04 (142-144行: min処理) | ○ |
| C-31 | cap冪等無視 | E-04 (139行: if idempotent return) | ○ |
| C-32 | is_capped - true | E-04 (110行) | ○ |
| C-33 | is_capped - false | E-04 (110行) | ○ |
| C-34 | maybeCapRemaining - 残容量計算 | E-04 (151-158行) | ○ |
| C-35 | maybeCapRemaining - サイズ不明 | E-04 (152行: 両方has_value必要) | ○ |
| C-36 | maybeCapRemaining - 未キャップ | E-04 (152行: capped_size_.has_value必要) | ○ |
| C-37 | get_reader - 冪等複数Reader | E-04 (524-527行) | ○ |
| C-38 | get_reader - 非冪等単一Reader | E-04 (529-532行) | ○ |
| C-39 | get_reader - 非冪等二重取得拒否 | E-04 (529行: locked_to_readerチェック) | ○ |
| C-40 | addBackpressureListener | E-04 (165-169行) | ○ |
| C-41 | addBackpressureListener冪等無視 | E-04 (166行: if idempotent return) | ○ |
| C-42 | removeBackpressureListener | E-04 (171-175行) | ○ |
| C-43 | IdempotentReader Pull正常系 | E-05 (224-329行) | ○ |
| C-44 | IdempotentReader Pull EOS | E-05 (279-296行) | ○ |
| C-45 | IdempotentReader 空DataQueue | E-05 (245-249行) | ○ |
| C-46 | IdempotentReader ended後読み取り | E-05 (233-236行) | ○ |
| C-47 | IdempotentReader Reader取得失敗 | E-05 (258-264行) | ○ |
| C-48 | NonIdempotentReader Pull正常系 | E-06 (377-501行) | ○ |
| C-49 | NonIdempotentReader Entry削除 | E-06 (451行: entries_.erase) | ○ |
| C-50 | NonIdempotentReader 未キャップ空BLOCK | E-06 (399-401行) | ○ |
| C-51 | NonIdempotentReader キャップ済み空EOS | E-06 (424-427行) | ○ |
| C-52 | NonIdempotentReader バックプレッシャー通知 | E-06 (461-468行) | ○ |
| C-53 | EmptyEntry slice start=0 | E-07 (580-585行) | ○ |
| C-54 | EmptyEntry slice start!=0 | E-07 (583行: if start != 0 return nullptr) | ○ |
| C-55 | EmptyEntry size | E-07 (587行) | ○ |
| C-56 | EmptyEntry is_idempotent | E-07 (589行) | ○ |
| C-57 | EmptyReader Pull初回 | E-07 (543-558行) | ○ |
| C-58 | EmptyReader Pull 2回目 | E-07 (549-551行) | ○ |
| C-59 | InMemoryEntry slice | E-08 (668-697行) | ○ |
| C-60 | InMemoryEntry slice end省略 | E-08 (695-696行) | ○ |
| C-61 | InMemoryEntry slice長さ0 | E-08 (673-675行: EmptyEntry返却) | ○ |
| C-62 | InMemoryEntry slice範囲外クランプ | E-08 (683行: min使用) | ○ |
| C-63 | InMemoryEntry size | E-08 (699行) | ○ |
| C-64 | InMemoryEntry is_idempotent | E-08 (701行) | ○ |
| C-65 | InMemoryReader Pull | E-08 (613-636行) | ○ |
| C-66 | InMemoryReader Pull 2回目EOS | E-08 (619-622行) | ○ |
| C-67 | DataQueueEntry slice | E-09 (739-745行) | ○ |
| C-68 | DataQueueEntry slice失敗 | E-09 (742行: if !sliced return nullptr) | ○ |
| C-69 | DataQueueEntry size | E-09 (753行) | ○ |
| C-70 | DataQueueEntry is_idempotent | E-09 (761行) | ○ |
| C-71 | FdEntry Create正常系 | E-10 (822-832行) | ○ |
| C-72 | FdEntry Create異常系 | E-10 (828行) | ○ |
| C-73 | FdEntry slice | E-10 (851-863行) | ○ |
| C-74 | FdEntry size | E-10 (865行) | ○ |
| C-75 | FdEntry is_idempotent | E-10 (867行) | ○ |
| C-76 | FdEntry ReaderImpl Create正常系 | E-10 (904-923行) | ○ |
| C-77 | FdEntry ReaderImpl Create失敗 | E-10 (909行: file < 0) | ○ |
| C-78 | FdEntry ReaderImpl Create変更検出 | E-10 (909行: CheckModified) | ○ |
| C-79 | FdEntry ReaderImpl Pull | E-10 (984-1006行) | △ |
| C-80 | FdEntry ReaderImpl Pull ended | E-10 (989-992行) | ○ |
| C-81 | FdEntry ReaderImpl Pull変更検出 | E-10 (994-998行) | ○ |
| C-82 | FdEntry OnStreamRead正常系 | E-10 (941-982行) | ○ |
| C-83 | FdEntry OnStreamRead EOF | E-10 (963-964行) | ○ |
| C-84 | FdEntry OnStreamRead エラー | E-10 (965-966行) | ○ |
| C-85 | FdEntry OnStreamRead変更検出 | E-10 (955-959行) | ○ |
| C-86 | FdEntry DrainAndClose | E-10 (1032-1051行) | ○ |
| C-87 | FdEntry is_modified サイズ変更 | E-10 (883行) | ○ |
| C-88 | FdEntry is_modified mtime変更 | E-10 (884行) | ○ |
| C-89 | FdEntry is_modified 変更なし | E-10 (882-885行) | ○ |
| C-90 | Vec構造体 | E-17 (129-132行) | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-DQ-079**: FdEntry::ReaderImpl::Pullの非同期動作の詳細（libuv連携部分）の完全な動作検証には、実行環境での統合テストが必要
  - 候補：libuvドキュメント / node_file.h / stream_base.h
- **UT-DQ-090**: Vec構造体の使用パターンについて、他モジュールでの使用例との整合性確認が推奨される
  - 候補：node_bob.h / Blobモジュール / QUICモジュール

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケースはソースコードから直接導出可能
- **1（中リスク）**: ファイルシステム関連テスト（FdEntry）は環境依存性があり、モック化が必要
- **1（中リスク）**: 非同期読み取り（Pull/OnStreamRead）のタイミング依存テストは注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 冪等性（idempotent）に関するテストケース（UT-DQ-001〜005, UT-DQ-023〜024）が要件を網羅しているか
- [ ] キャップ機能（cap）のテストケース（UT-DQ-029〜036）が境界条件を網羅しているか
- [ ] ファイル変更検出（is_modified, CheckModified）のテストケース（UT-DQ-078, UT-DQ-081, UT-DQ-085, UT-DQ-087〜089）が実運用シナリオをカバーしているか
- [ ] BackpressureListenerのテストケース（UT-DQ-040〜042, UT-DQ-052）がメモリリークを防ぐ観点を含んでいるか
- [ ] 全Entryタイプ（Empty, InMemory, DataQueue, Fd）のスライス操作が正しく検証されているか
