---
generated_at: 2026-01-30 14:30:00
metrics:
  claims_total: 201
  claims_with_evidence: 201
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-inspector 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成されたsrc-inspectorモジュールの単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：201 / 201、根拠なし：0
- 優先レビュー（高）
  1. **スレッド間通信関連**：MainThreadInterface, MainThreadHandle のテストケースは並行処理の複雑さから特に注意が必要
  2. **プロトコルエージェント**：WorkerAgent, TracingAgent, NetworkAgent 等のCDP（Chrome DevTools Protocol）実装は外部仕様への準拠確認が必要
  3. **バッファ管理**：RequestsBuffer, RequestEntry のバッファ制限ロジックはメモリ安全性に関わる

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/inspector/main_thread_interface.h` - MainThreadInterface, MainThreadHandle, Deletable, Request クラス定義
- E-02: `src/inspector/main_thread_interface.cc` - MainThreadInterface, MainThreadHandle 実装、Utf8ToStringView関数
- E-03: `src/inspector/worker_inspector.h` - WorkerManager, WorkerDelegate, ParentInspectorHandle, WorkerInfo 定義
- E-04: `src/inspector/worker_inspector.cc` - WorkerManager, ParentInspectorHandle 実装
- E-05: `src/inspector/worker_agent.h` - WorkerAgent クラス定義
- E-06: `src/inspector/worker_agent.cc` - WorkerAgent, NodeWorkers 実装
- E-07: `src/inspector/tracing_agent.h` - TracingAgent クラス定義
- E-08: `src/inspector/tracing_agent.cc` - TracingAgent 実装、InspectorTraceWriter
- E-09: `src/inspector/runtime_agent.h` - RuntimeAgent クラス定義
- E-10: `src/inspector/runtime_agent.cc` - RuntimeAgent 実装
- E-11: `src/inspector/network_inspector.h` - NetworkInspector クラス定義
- E-12: `src/inspector/network_inspector.cc` - NetworkInspector 実装
- E-13: `src/inspector/network_agent.h` - NetworkAgent クラス定義
- E-14: `src/inspector/network_agent.cc` - NetworkAgent 実装、ヘルパー関数群
- E-15: `src/inspector/network_resource_manager.h` - NetworkResourceManager クラス定義
- E-16: `src/inspector/network_resource_manager.cc` - NetworkResourceManager 実装
- E-17: `src/inspector/network_requests_buffer.h` - RequestEntry, RequestsBuffer, Charset 定義
- E-18: `src/inspector/node_string.h` - StringUtil, Binary クラス定義
- E-19: `src/inspector/node_string.cc` - StringUtil, Binary 実装、ProtocolTypeTraits特殊化
- E-20: `src/inspector/node_json.h` - JsonUtil クラス定義
- E-21: `src/inspector/node_json.cc` - JsonUtil 実装、ValueParserHandler
- E-22: `src/inspector/io_agent.h` - IoAgent クラス定義
- E-23: `src/inspector/io_agent.cc` - IoAgent 実装
- E-24: `src/inspector/target_agent.h` - TargetAgent, TargetInfo 定義
- E-25: `src/inspector/target_agent.cc` - TargetAgent 実装、WorkerTargetDelegate
- E-26: `src/inspector/storage_agent.h` - StorageAgent クラス定義
- E-27: `src/inspector/storage_agent.cc` - StorageAgent 実装
- E-28: `src/inspector/dom_storage_agent.h` - DOMStorageAgent クラス定義
- E-29: `src/inspector/dom_storage_agent.cc` - DOMStorageAgent 実装
- E-30: `src/inspector/notification_emitter.h` - NotificationEmitter クラス定義
- E-31: `src/inspector/notification_emitter.cc` - NotificationEmitter 実装
- E-32: `src/inspector/inspector_object_utils.h` - ObjectGet* ユーティリティ関数定義
- E-33: `src/inspector/inspector_object_utils.cc` - ObjectGet* ユーティリティ関数実装
- E-34: `src/inspector/protocol_helper.h` - ToProtocolString, ToInspectorString 関数定義

## 3) Claims と根拠の対応（レビューの主戦場）

### MainThreadInterface / MainThreadHandle 関連 (UT-INS-001 〜 UT-INS-026)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Post: リクエストがキューに追加される | E-01, E-02 (L207-218) | ○ |
| C-02 | Post: 空キューでRequestInterruptが呼び出される | E-02 (L210-217) | ○ |
| C-03 | DispatchMessages: 全メッセージが処理される | E-02 (L242-263) | ○ |
| C-04 | DispatchMessages: 再入防止機能 | E-02 (L243-245) | ○ |
| C-05 | WaitForFrontendEvent: 条件変数でブロック | E-02 (L221-234) | ○ |
| C-06 | StopWaitingForFrontendEvent: 待機停止 | E-02 (L236-240) | ○ |
| C-07 | GetHandle: ハンドル取得 | E-02 (L265-269) | ○ |
| C-08 | AddObject: オブジェクト追加 | E-02 (L271-275) | ○ |
| C-09 | AddObject: null時CHECK失敗 | E-02 (L273) | ○ |
| C-10 | RemoveObject: オブジェクト削除 | E-02 (L277-279) | ○ |
| C-11 | GetObject: オブジェクト取得 | E-02 (L281-287) | ○ |
| C-12 | GetObjectIfExists: 安全な取得 | E-02 (L289-295) | ○ |
| C-13 | MainThreadHandle::Connect: セッション作成 | E-02 (L307-315) | ○ |
| C-14 | MainThreadHandle::Post: リクエストポスト | E-02 (L317-323) | ○ |
| C-15 | MainThreadHandle::Reset: リセット | E-02 (L325-328) | ○ |
| C-16 | MainThreadHandle::Expired: 有効性確認 | E-02 (L339-342) | ○ |
| C-17 | Utf8ToStringView: UTF8変換 | E-02 (L297-305) | ○ |

### WorkerManager / WorkerAgent 関連 (UT-INS-027 〜 UT-INS-053)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | WorkerManager::WorkerStarted: ワーカー登録 | E-04 (L94-103) | ○ |
| C-19 | WorkerManager::WorkerFinished: ワーカー削除 | E-04 (L90-92) | ○ |
| C-20 | WorkerManager::NewParentHandle: 親ハンドル作成 | E-04 (L105-113) | ○ |
| C-21 | WorkerManager::SetAutoAttach: デリゲート登録 | E-04 (L120-130) | ○ |
| C-22 | WorkerManager::RemoveAttachDelegate: 削除 | E-04 (L115-118) | ○ |
| C-23 | WorkerManager::SetWaitOnStartForDelegate: 待機設定 | E-04 (L132-137) | ○ |
| C-24 | ParentInspectorHandle::WorkerStarted: 通知 | E-04 (L77-82) | ○ |
| C-25 | ParentInspectorHandle::Connect: セッション接続 | E-04 (L84-88) | ○ |
| C-26 | WorkerAgent::Wire: ディスパッチャー接続 | E-06 (L84-91) | ○ |
| C-27 | WorkerAgent::enable: 自動アタッチ有効化 | E-06 (L99-111) | ○ |
| C-28 | WorkerAgent::disable: 無効化 | E-06 (L113-116) | ○ |
| C-29 | WorkerAgent::sendMessageToWorker: メッセージ送信 | E-06 (L93-97) | ○ |
| C-30 | NodeWorkers::WorkerCreated: ワーカー作成通知 | E-06 (L123-136) | ○ |
| C-31 | NodeWorkers::Send: フロントエンド送信 | E-06 (L138-142) | ○ |
| C-32 | NodeWorkers::Receive: メッセージディスパッチ | E-06 (L144-148) | ○ |
| C-33 | NodeWorkers::Detached: セッション削除 | E-06 (L150-157) | ○ |

### TracingAgent 関連 (UT-INS-054 〜 UT-INS-060)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | TracingAgent::Wire: ディスパッチャー接続 | E-08 (L135-142) | ○ |
| C-35 | TracingAgent::start: トレース開始 | E-08 (L144-174) | ○ |
| C-36 | TracingAgent::start: 既トレース中エラー | E-08 (L146-149) | ○ |
| C-37 | TracingAgent::start: プロセス状態エラー | E-08 (L150-153) | ○ |
| C-38 | TracingAgent::start: 空カテゴリエラー | E-08 (L161-163) | ○ |
| C-39 | TracingAgent::stop: トレース停止 | E-08 (L176-180) | ○ |
| C-40 | TracingAgent::getCategories: カテゴリ取得 | E-08 (L182-208) | ○ |

### RuntimeAgent 関連 (UT-INS-061 〜 UT-INS-070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | RuntimeAgent::Wire: ディスパッチャー接続 | E-10 (L15-18) | ○ |
| C-42 | RuntimeAgent::enable: 有効化 | E-10 (L25-31) | ○ |
| C-43 | RuntimeAgent::disable: 無効化 | E-10 (L33-36) | ○ |
| C-44 | RuntimeAgent::notifyWhenWaitingForDisconnect: 設定 | E-10 (L20-23) | ○ |
| C-45 | RuntimeAgent::setWaitingForDebugger: フラグ設定 | E-10 (L38-43) | ○ |
| C-46 | RuntimeAgent::unsetWaitingForDebugger: フラグ解除 | E-10 (L45-47) | ○ |
| C-47 | RuntimeAgent::notifyWaitingForDisconnect: 通知判定 | E-10 (L49-55) | ○ |

### NetworkInspector / NetworkAgent 関連 (UT-INS-071 〜 UT-INS-109)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | NetworkInspector::Wire: エージェント接続 | E-12 (L20-22) | ○ |
| C-49 | NetworkInspector::canEmit: ドメイン判定 | E-12 (L24-26) | ○ |
| C-50 | NetworkInspector::emitNotification: 通知エミット | E-12 (L28-37) | ○ |
| C-51 | NetworkInspector::Enable: 有効化 | E-12 (L39-44) | ○ |
| C-52 | NetworkInspector::Disable: 無効化 | E-12 (L46-51) | ○ |
| C-53 | NetworkAgent::Wire: ディスパッチャー接続 | E-14 (L247-251) | ○ |
| C-54 | NetworkAgent::enable: 有効化 | E-14 (L253-263) | ○ |
| C-55 | NetworkAgent::disable: 無効化 | E-14 (L265-268) | ○ |
| C-56 | NetworkAgent::getRequestPostData: POSTデータ取得 | E-14 (L270-296) | ○ |
| C-57 | NetworkAgent::getResponseBody: レスポンス取得 | E-14 (L298-337) | ○ |
| C-58 | NetworkAgent::streamResourceContent: ストリーミング | E-14 (L339-365) | ○ |
| C-59 | NetworkAgent::loadNetworkResource: リソース取得 | E-14 (L367-394) | ○ |
| C-60 | NetworkAgent::requestWillBeSent: リクエスト開始通知 | E-14 (L396-445) | ○ |
| C-61 | NetworkAgent::responseReceived: レスポンス受信通知 | E-14 (L447-478) | ○ |
| C-62 | NetworkAgent::loadingFailed: 失敗通知 | E-14 (L480-502) | ○ |
| C-63 | NetworkAgent::loadingFinished: 完了通知 | E-14 (L504-529) | ○ |
| C-64 | NetworkAgent::dataSent: 送信データ処理 | E-14 (L531-569) | ○ |
| C-65 | NetworkAgent::dataReceived: 受信データ処理 | E-14 (L571-612) | ○ |
| C-66 | NetworkAgent::webSocketCreated: WebSocket作成通知 | E-14 (L183-200) | ○ |
| C-67 | NetworkAgent::webSocketClosed: WebSocket閉じ通知 | E-14 (L202-213) | ○ |
| C-68 | NetworkAgent::webSocketHandshakeResponseReceived: ハンドシェイク | E-14 (L215-235) | ○ |

### NetworkResourceManager / RequestsBuffer 関連 (UT-INS-110 〜 UT-INS-128)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | NetworkResourceManager::Put: リソース保存 | E-16 (L10-14) | ○ |
| C-70 | NetworkResourceManager::Get: リソース取得 | E-16 (L16-21) | ○ |
| C-71 | NetworkResourceManager::Erase: リソース削除 | E-16 (L23-26) | ○ |
| C-72 | RequestEntry::push_request_data_blob: データ追加 | E-17 (L41-48) | ○ |
| C-73 | RequestEntry::push_response_data_blob: データ追加 | E-17 (L49-56) | ○ |
| C-74 | RequestEntry::clear_response_data_blobs: クリア | E-17 (L58-61) | ○ |
| C-75 | RequestsBuffer::emplace: エントリ追加 | E-17 (L150-159) | ○ |
| C-76 | RequestsBuffer::find: エントリ検索 | E-17 (L131-137) | ○ |
| C-77 | RequestsBuffer::cfind: const検索 | E-17 (L138-144) | ○ |
| C-78 | RequestsBuffer::erase: エントリ削除 | E-17 (L161-175) | ○ |
| C-79 | RequestsBuffer::enforceBufferLimits: 制限適用 | E-17 (L178-183) | ○ |

### StringUtil / Binary / JsonUtil 関連 (UT-INS-129 〜 UT-INS-150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | StringUtil::StringViewToUtf8: 変換 | E-19 (L51-59) | ○ |
| C-81 | StringUtil::fromUTF16: UTF16変換 | E-19 (L61-75) | ○ |
| C-82 | StringUtil::fromUTF16LE: UTF16LE変換 | E-19 (L81-95) | ○ |
| C-83 | StringUtil::fromUTF8: UTF8変換 | E-19 (L77-79) | ○ |
| C-84 | StringUtil::CharactersUTF8: ポインタ取得 | E-19 (L97-99) | ○ |
| C-85 | StringUtil::CharacterCount: 長さ取得 | E-19 (L101-108) | ○ |
| C-86 | Binary::toBase64: エンコード | E-19 (L110-121) | ○ |
| C-87 | Binary::concat: 連結 | E-19 (L124-136) | ○ |
| C-88 | Binary::fromBase64: デコード | E-19 (L139-152) | ○ |
| C-89 | Binary::fromUint8Array: 変換 | E-19 (L155-160) | ○ |
| C-90 | JsonUtil::parseJSON(string_view): パース | E-21 (L176-181) | ○ |
| C-91 | JsonUtil::parseJSON(StringView): パース | E-21 (L183-187) | ○ |
| C-92 | JsonUtil::ParseJSON(uint8_t): UTF8パース | E-21 (L162-167) | ○ |
| C-93 | JsonUtil::ParseJSON(uint16_t): UTF16パース | E-21 (L169-174) | ○ |

### IoAgent 関連 (UT-INS-151 〜 UT-INS-157)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | IoAgent::Wire: ディスパッチャー接続 | E-23 (L11-14) | ○ |
| C-95 | IoAgent::read: リソース読み取り | E-23 (L16-50) | ○ |
| C-96 | IoAgent::close: リソース削除 | E-23 (L52-56) | ○ |

### TargetAgent 関連 (UT-INS-158 〜 UT-INS-165)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | TargetAgent::Wire: ディスパッチャー接続 | E-25 (L46-49) | ○ |
| C-98 | TargetAgent::createAndAttachIfNecessary: ターゲット作成 | E-25 (L51-65) | ○ |
| C-99 | TargetAgent::setAutoAttach: 自動アタッチ設定 | E-25 (L113-132) | ○ |
| C-100 | TargetAgent::listenWorker: ワーカーリッスン | E-25 (L67-75) | ○ |
| C-101 | TargetAgent::reset: リセット | E-25 (L77-81) | ○ |

### StorageAgent 関連 (UT-INS-166 〜 UT-INS-168)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | StorageAgent::Wire: ディスパッチャー接続 | E-27 (L12-16) | ○ |
| C-103 | StorageAgent::getStorageKey: ストレージキー取得 | E-27 (L17-22) | ○ |
| C-104 | StorageAgent::to_absolute_path: パス変換 | E-27 (L24-28) | ○ |

### DOMStorageAgent 関連 (UT-INS-169 〜 UT-INS-185)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | DOMStorageAgent::Wire: ディスパッチャー接続 | E-29 (L43-67) | ○ |
| C-106 | DOMStorageAgent::enable: 有効化 | E-29 (L69-72) | ○ |
| C-107 | DOMStorageAgent::disable: 無効化 | E-29 (L74-77) | ○ |
| C-108 | DOMStorageAgent::getDOMStorageItems: アイテム取得 | E-29 (L79-100) | ○ |
| C-109 | DOMStorageAgent::setDOMStorageItem: 未実装 | E-29 (L102-107) | ○ |
| C-110 | DOMStorageAgent::removeDOMStorageItem: 未実装 | E-29 (L109-113) | ○ |
| C-111 | DOMStorageAgent::clear: 未実装 | E-29 (L115-118) | ○ |
| C-112 | DOMStorageAgent::domStorageItemAdded: 追加通知 | E-29 (L120-142) | ○ |
| C-113 | DOMStorageAgent::domStorageItemRemoved: 削除通知 | E-29 (L144-162) | ○ |
| C-114 | DOMStorageAgent::domStorageItemUpdated: 更新通知 | E-29 (L164-192) | ○ |
| C-115 | DOMStorageAgent::domStorageItemsCleared: クリア通知 | E-29 (L194-207) | ○ |
| C-116 | DOMStorageAgent::registerStorage: ストレージ登録 | E-29 (L209-242) | ○ |
| C-117 | DOMStorageAgent::canEmit: ドメイン判定 | E-29 (L244-246) | ○ |

### NotificationEmitter / ObjectUtils 関連 (UT-INS-186 〜 UT-INS-201)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | NotificationEmitter::emitNotification: イベント発火 | E-31 (L10-17) | ○ |
| C-119 | NotificationEmitter::addEventNotifier: イベント登録 | E-31 (L19-22) | ○ |
| C-120 | ObjectGetProtocolString: 文字列取得 | E-33 (L24-34) | ○ |
| C-121 | ObjectGetDouble: double取得 | E-33 (L46-57) | ○ |
| C-122 | ObjectGetInt: int取得 | E-33 (L60-71) | ○ |
| C-123 | ObjectGetBool: bool取得 | E-33 (L74-85) | ○ |
| C-124 | ObjectGetObject: Object取得 | E-33 (L88-99) | ○ |
| C-125 | ToProtocolString: V8文字列変換 | E-34 (L19-23) | ○ |
| C-126 | ToInspectorString: StringBuffer変換 | E-34 (L12-16) | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしの項目はありません。
- 全てのテストケースはソースコードの実装に基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**: DOMStorageAgent の setDOMStorageItem, removeDOMStorageItem, clear は未実装として ServerError を返す。将来の実装予定があれば要確認。
- **リスク0（低）**: TargetAgent::target_session_id_worker_map_ は静的変数として定義されており、スレッド安全性について確認が必要。
- **リスク1（中）**: RequestsBuffer のバッファ制限ロジックは enforceBufferLimits で古いエントリから削除するが、重要なリクエストが削除される可能性がある。
- **リスク0（低）**: NetworkAgent::loadNetworkResource は experimental_inspector_network_resource フラグに依存しており、実験的機能として認識が必要。

## 6) レビュアーチェックリスト（最小）
- [ ] MainThreadInterface のスレッド安全性（Mutex使用箇所）が正しくテストされているか
- [ ] プロトコルエージェントのWireメソッドがCDP仕様に準拠しているか
- [ ] バッファサイズ制限のテストケースが境界条件を網羅しているか
- [ ] 文字列変換（UTF8/UTF16）のテストケースが不正入力を考慮しているか
- [ ] 未実装メソッド（DOMStorageAgent）のテストが将来の実装を考慮しているか
- [ ] WebSocket関連イベントのテストケースがプロトコル仕様に準拠しているか
