---
generated_at: 2026-01-30 18:30:00
metrics:
  claims_total: 63
  claims_with_evidence: 63
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-large_pages.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：63 / 63、根拠なし：0
- 優先レビュー（高）
  1. **UT-LPG-001〜005**：メインAPI（MapStaticCodeToLargePages）のテストケース - プラットフォーム依存コードのため実環境テスト推奨
  2. **UT-LPG-044〜051**：MoveTextRegionToLargePages関数 - システムコール依存のため実環境テスト推奨
  3. **UT-LPG-018〜022**：FindNodeTextRegion関数 - ELF/Mach-O解析のプラットフォーム依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/large_pages/node_large_page.cc` - メイン実装ファイル（465行）
- E-02: `src/large_pages/node_large_page.h` - ヘッダーファイル（35行）
- E-03: `src/large_pages/node_text_start.S` - アセンブリシンボル定義（30行）

## 3) Claims と根拠の対応（レビューの主戦場）

### 公開API（MapStaticCodeToLargePages / LargePagesError）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MapStaticCodeToLargePagesが成功時0を返す | E-01 L417-439 | ○ |
| C-02 | NODE_ENABLE_LARGE_CODE_PAGES未定義時ENOTSUPを返す | E-01 L437 | ○ |
| C-03 | THP無効時EACCESを返す | E-01 L428-429 | ○ |
| C-04 | リージョン未検出時ENOENTを返す | E-01 L432-433 | ○ |
| C-05 | マッピング失敗時-1を返す | E-01 L435 | ○ |
| C-06 | LargePagesError(ENOTSUP)のメッセージ | E-01 L443-444 | ○ |
| C-07 | LargePagesError(EACCES)のメッセージ | E-01 L446-447 | ○ |
| C-08 | LargePagesError(ENOENT)のメッセージ | E-01 L449-450 | ○ |
| C-09 | LargePagesError(-1)のメッセージ | E-01 L452-454 | ○ |
| C-10 | LargePagesError(0)のメッセージ | E-01 L456-457 | ○ |
| C-11 | LargePagesError(未知)のメッセージ | E-01 L459-460 | ○ |

### アライメント関数（hugepage_align_up / hugepage_align_down）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | hugepage_align_upのアライメント計算式 | E-01 L137-139 | ○ |
| C-13 | hugepage_align_upの境界値（既に境界上） | E-01 L137-139 | ○ |
| C-14 | hugepage_align_upのゼロ境界 | E-01 L137-139 | ○ |
| C-15 | hugepage_align_downのアライメント計算式 | E-01 L141-143 | ○ |
| C-16 | hugepage_align_downの境界値（既に境界上） | E-01 L141-143 | ○ |
| C-17 | hugepage_align_downの2MB未満境界 | E-01 L141-143 | ○ |

### FindNodeTextRegion関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | Linux/FreeBSDでのリージョン検出 | E-01 L181-226 | ○ |
| C-19 | macOSでのリージョン検出 | E-01 L227-258 | ○ |
| C-20 | リージョン未検出時found_text_region=false | E-01 L182, L261 | ○ |
| C-21 | 2MB未満時found_text_region=false | E-01 L217-223 | ○ |
| C-22 | lpstubトリミング | E-01 L207-211 | ○ |

### THP/SuperPages確認関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | IsTransparentHugePagesEnabled [always]判定 | E-01 L265-277 | ○ |
| C-24 | IsTransparentHugePagesEnabled [madvise]判定 | E-01 L278-279 | ○ |
| C-25 | IsTransparentHugePagesEnabled [never]判定 | E-01 L280 | ○ |
| C-26 | IsTransparentHugePagesEnabled ファイルオープン失敗 | E-01 L269-273 | ○ |
| C-27 | IsSuperPagesEnabled pg_ps_enabled>=1判定 | E-01 L283-293 | ○ |
| C-28 | IsSuperPagesEnabled pg_ps_enabled=0判定 | E-01 L292 | ○ |
| C-29 | IsSuperPagesEnabled sysctlbyname失敗 | E-01 L287-291 | ○ |

### MemoryMapPointerクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | デフォルトコンストラクタ初期化 | E-01 L300, L343-344 | ○ |
| C-31 | operator==（nullptr比較） | E-01 L301 | ○ |
| C-32 | operator==（異なるポインタ比較） | E-01 L301 | ○ |
| C-33 | mem()ゲッター | E-01 L302 | ○ |
| C-34 | Reset(引数あり)成功時 | E-01 L307-315 | ○ |
| C-35 | Reset(引数あり)失敗時 | E-01 L307-315 | ○ |
| C-36 | Reset(引数なし) | E-01 L316-319 | ○ |
| C-37 | SetName Linux成功時 | E-01 L320-334 | ○ |
| C-38 | SetName MAP_FAILEDガード | E-01 L326 | ○ |
| C-39 | SetName nullptrガード | E-01 L326 | ○ |
| C-40 | デストラクタ正常解放 | E-01 L335-340 | ○ |
| C-41 | デストラクタnullptrガード | E-01 L336 | ○ |
| C-42 | デストラクタMAP_FAILEDガード | E-01 L337 | ○ |
| C-43 | デストラクタmunmap失敗時エラー出力 | E-01 L338-339 | ○ |

### MoveTextRegionToLargePages関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | Linux実装（madvise MADV_HUGEPAGE） | E-01 L369-379 | ○ |
| C-45 | FreeBSD実装（MAP_ALIGNED_SUPER） | E-01 L380-386 | ○ |
| C-46 | macOS実装（VM_FLAGS_SUPERPAGE_SIZE_2MB） | E-01 L387-402 | ○ |
| C-47 | 一時領域mmap失敗 | E-01 L364-366 | ○ |
| C-48 | 固定アドレスmmap失敗 | E-01 L374-377, L381-385, L393-397 | ○ |
| C-49 | madvise失敗 | E-01 L378 | ○ |
| C-50 | macOS mprotect失敗 | E-01 L399-400 | ○ |
| C-51 | 最終mprotect失敗 | E-01 L404 | ○ |
| C-52 | SetName呼び出し | E-01 L405 | ○ |

### FindMapping関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | 実行可能セグメント検出成功 | E-01 L159-178 | ○ |
| C-54 | exename不一致時0返却 | E-01 L161 | ○ |
| C-55 | 参照シンボル範囲外時0返却 | E-01 L168-169 | ○ |
| C-56 | PT_LOAD以外時0返却 | E-01 L164 | ○ |
| C-57 | PF_Xなし時0返却 | E-01 L164 | ○ |

### ヘルパー関数・構造体
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | Debug関数出力フォーマット | E-01 L121-127 | ○ |
| C-59 | PrintWarning出力フォーマット | E-01 L129-131 | ○ |
| C-60 | PrintSystemError出力 | E-01 L133-135 | ○ |
| C-61 | text_region構造体初期化 | E-01 L113-117 | ○ |
| C-62 | dl_iterate_params構造体初期化 | E-01 L152-157 | ○ |
| C-63 | hps定数値（2MB） | E-01 L119 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードに基づいて作成されています

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - プラットフォーム依存コード
  - Linux/FreeBSD/macOSで異なる実装パスがあり、各プラットフォームでのテスト実行が推奨されます
  - 特にシステムコール（mmap, madvise, mprotect, prctl, sysctlbyname）の挙動はOS・カーネルバージョンに依存
- **1: 中リスク** - 権限・設定依存
  - THP（Transparent Huge Pages）やSuperPagesの設定はシステム管理者の設定に依存
  - テスト環境のセットアップが必要
- **0: 低リスク** - コンパイル時フラグ依存
  - NODE_ENABLE_LARGE_CODE_PAGES フラグによってコード全体が有効/無効になる
  - 両方の条件でビルド・テストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] MapStaticCodeToLargePagesの戻り値（0, ENOTSUP, EACCES, ENOENT, -1）が仕様通りか確認
- [ ] LargePagesErrorの各エラーメッセージが適切か確認
- [ ] 各プラットフォーム固有のコードパス（Linux/FreeBSD/macOS）がカバーされているか確認
- [ ] MemoryMapPointerのRAIIパターンが正しく動作するか確認（リソースリーク防止）
- [ ] アライメント計算（hugepage_align_up/down）の境界値テストが十分か確認
- [ ] システムコール失敗時のエラーハンドリングが適切か確認
- [ ] __node_text_start シンボルの参照が正しいか確認（E-03: node_text_start.S）
