---
generated_at: 2026-01-30 18:35:00
metrics:
  claims_total: 106
  claims_with_evidence: 106
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-permission.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：106 / 106、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/permission/permission.h` - Permissionクラス定義、マクロ定義
- E-02: `src/permission/permission.cc` - Permissionクラス実装、Has関数、エラー生成
- E-03: `src/permission/permission_base.h` - PermissionBase抽象クラス、PermissionScope enum定義
- E-04: `src/permission/fs_permission.h` - FSPermissionクラス定義、RadixTree構造体定義
- E-05: `src/permission/fs_permission.cc` - FSPermission実装、RadixTree実装
- E-06: `src/permission/child_process_permission.h` - ChildProcessPermissionクラス定義
- E-07: `src/permission/child_process_permission.cc` - ChildProcessPermission実装
- E-08: `src/permission/worker_permission.h` - WorkerPermissionクラス定義
- E-09: `src/permission/worker_permission.cc` - WorkerPermission実装
- E-10: `src/permission/inspector_permission.h` - InspectorPermissionクラス定義
- E-11: `src/permission/inspector_permission.cc` - InspectorPermission実装
- E-12: `src/permission/wasi_permission.h` - WASIPermissionクラス定義
- E-13: `src/permission/wasi_permission.cc` - WASIPermission実装
- E-14: `src/permission/net_permission.h` - NetPermissionクラス定義
- E-15: `src/permission/net_permission.cc` - NetPermission実装
- E-16: `src/permission/addon_permission.h` - AddonPermissionクラス定義
- E-17: `src/permission/addon_permission.cc` - AddonPermission実装

## 3) Claims と根拠の対応（レビューの主戦場）

### Permissionクラス（コア）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタでpermissionノードが正しく初期化される | E-02 (73-112行) | ○ |
| C-02 | enabled()がfalseで初期化される | E-01 (101行) | ○ |
| C-03 | EnablePermissions()でenabled_がtrueになる | E-02 (172-176行) | ○ |
| C-04 | 重複EnablePermissions呼び出しが安全 | E-02 (172-176行) | ○ |
| C-05 | is_granted()がenabled_=falseで常にtrue | E-01 (92-99行) | ○ |
| C-06 | is_granted()が権限ありでtrue | E-01 (92-99行) | ○ |
| C-07 | is_granted()が権限なしでfalse | E-01 (92-99行) | ○ |
| C-08 | is_scope_granted()が登録済みスコープをチェック | E-01 (120-128行) | ○ |
| C-09 | is_scope_granted()が未登録スコープでfalse | E-01 (120-128行) | ○ |
| C-10 | Apply()が対応するPermissionBaseを呼び出す | E-02 (178-185行) | ○ |
| C-11 | Apply()が空リストで正常動作 | E-02 (178-185行) | ○ |
| C-12-21 | StringToPermission()の各スコープ変換 | E-02 (65-71行), E-03 (17-45行) | ○ |
| C-22-24 | PermissionToString()の各スコープ変換 | E-02 (57-63行) | ○ |
| C-25 | ThrowAccessDenied()が例外をスロー | E-02 (149-158行) | ○ |
| C-26 | AsyncThrowAccessDenied()がReject | E-02 (160-170行) | ○ |
| C-27 | CreateAccessDeniedError()がエラーオブジェクト生成 | E-02 (126-147行) | ○ |
| C-28-32 | Has()の各種シナリオ | E-02 (32-53行) | ○ |

### FSPermissionクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | Apply()で読み取り権限適用 | E-05 (141-157行) | ○ |
| C-34 | Apply()で書き込み権限適用 | E-05 (141-157行) | ○ |
| C-35 | Apply()でワイルドカード全権限付与 | E-05 (145-154行) | ○ |
| C-36 | Apply()で複数パス許可 | E-05 (141-157行) | ○ |
| C-37 | Apply()空リストで変更なし | E-05 (141-157行) | ○ |
| C-38 | GrantAccess()で読み取りパス登録 | E-05 (159-170行) | ○ |
| C-39 | GrantAccess()で書き込みパス登録 | E-05 (159-170行) | ○ |
| C-40 | GrantAccess()でディレクトリにワイルドカード追加 | E-05 (19-34行, 159-170行) | ○ |
| C-41 | GrantAccess()でファイルはワイルドカードなし | E-05 (19-34行) | ○ |
| C-42 | GrantAccess()で重複登録防止 | E-05 (161-163行) | ○ |
| C-43 | is_granted()でkFileSystemスコープ確認 | E-05 (176-177行) | ○ |
| C-44-50 | is_granted()の各種シナリオ | E-05 (172-193行) | ○ |

### RadixTree
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | コンストラクタで空のルートノード作成 | E-05 (195行) | ○ |
| C-52 | デストラクタでメモリ解放 | E-05 (197-199行) | ○ |
| C-53-56 | Insert()の各種シナリオ | E-05 (230-256行) | ○ |
| C-57-61 | Lookup()の各種シナリオ | E-05 (201-228行) | ○ |
| C-62-64 | Node::CreateChild()の各種シナリオ | E-04 (37-70行) | ○ |
| C-65-66 | Node::CreateWildcardChild()の各種シナリオ | E-04 (72-78行) | ○ |
| C-67-70 | Node::NextNode()の各種シナリオ | E-04 (80-118行) | ○ |
| C-71-73 | Node::IsEndNode()の各種シナリオ | E-04 (131-136行) | ○ |

### 単純なPermissionクラス群
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74-76 | ChildProcessPermissionのApply/is_granted | E-07 (12-22行) | ○ |
| C-77-79 | WorkerPermissionのApply/is_granted | E-09 (12-22行) | ○ |
| C-80-82 | InspectorPermissionのApply/is_granted | E-11 (11-21行) | ○ |
| C-83-85 | WASIPermissionのApply/is_granted | E-13 (12-22行) | ○ |
| C-86-88 | NetPermissionのApply/is_granted | E-15 (10-20行) | ○ |
| C-89-91 | AddonPermissionのApply/is_granted | E-17 (11-21行) | ○ |

### ヘルパー関数・マクロ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92-94 | is_tree_granted()の各種シナリオ | E-05 (52-80行) | ○ |
| C-95-98 | WildcardIfDir()の各種シナリオ | E-05 (19-34行) | ○ |
| C-99-100 | GetErrorFlagSuggestion()の各種シナリオ | E-02 (114-124行) | ○ |
| C-101-104 | マクロの各種シナリオ | E-01 (31-56行) | ○ |
| C-105-106 | PermissionScope enumの定義 | E-03 (47-52行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全てのテストケースはソースコードの直接参照に基づいている。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコード行番号を明記した根拠を持つ
- 注意点：
  - FSPermissionのRadixTree実装は複雑なため、境界値テストの追加検討を推奨
  - Windows固有のUNCパス処理（is_tree_granted内）は環境依存のためクロスプラットフォームテストが必要
  - ChildProcess/Worker/Inspector/WASI/Addonのdeny_all_メンバは初期化されていない可能性があり、実際の動作確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Permissionクラスのコンストラクタで全7種のPermissionBase派生クラスが正しく登録されることを確認
- [ ] FSPermission::RadixTreeの分割ロジック（CreateChild内のprefix分割）が正しく動作することを確認
- [ ] ワイルドカードマッチングのエッジケース（パス末尾のスラッシュ有無）を確認
- [ ] 各Permission派生クラスのdeny_all_/allow_net_メンバの初期値を確認（未初期化の可能性）
- [ ] マクロ（THROW_IF_INSUFFICIENT_PERMISSIONS等）の展開結果が期待通りか確認
- [ ] StringToPermission/PermissionToStringの双方向変換が整合していることを確認
