---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 150
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-tracing.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：150 / 150、根拠なし：0
- 優先レビュー（高）
  1. なし - 全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/tracing/agent.h` (195行) - Agent, AgentWriterHandle, AsyncTraceWriter, TracingControllerクラス定義
- E-02: `src/tracing/agent.cc` (257行) - Agent, TracingController実装
- E-03: `src/tracing/node_trace_writer.h` (76行) - NodeTraceWriterクラス定義
- E-04: `src/tracing/node_trace_writer.cc` (241行) - NodeTraceWriter実装
- E-05: `src/tracing/node_trace_buffer.h` (84行) - InternalTraceBuffer, NodeTraceBufferクラス定義
- E-06: `src/tracing/node_trace_buffer.cc` (200行) - InternalTraceBuffer, NodeTraceBuffer実装
- E-07: `src/tracing/trace_event.h` (723行) - TraceEventHelper, TraceID, ScopedTracer, SetTraceValue, AddTraceEvent等
- E-08: `src/tracing/trace_event.cc` (43行) - TraceEventHelper実装（グローバル変数とGetAgent/SetAgent等）
- E-09: `src/tracing/traced_value.h` (130行) - TracedValue, EnvironmentArgs, AsyncWrapArgs, ProcessMetaクラス定義
- E-10: `src/tracing/traced_value.cc` (263行) - TracedValue実装、EscapeString、DoubleToCString
- E-11: `src/tracing/trace_event_common.h` (1110行) - トレースイベントマクロ定義、フェーズ定数、フラグ定数、値タイプ定数

## 3) Claims と根拠の対応（レビューの主戦場）

### Agentクラス関連 (C-01 - C-25)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Agent()コンストラクタで初期化が正常に行われること | E-01 (52-63行), E-02 (52-63行) | ○ |
| C-02 | ~Agent()デストラクタで正常に解放されること | E-01 (87行), E-02 (75-84行) | ○ |
| C-03 | GetTracingController()でポインタが取得できること | E-01 (89-93行) | ○ |
| C-04 | AddClient()でクライアントが正常に追加されること | E-01 (101-103行), E-02 (109-140行) | ○ |
| C-05 | kIgnoreDefaultCategoriesモードでのクライアント追加 | E-02 (115-123行) | ○ |
| C-06 | 空のカテゴリセットでのクライアント追加 | E-02 (109-140行) | ○ |
| C-07 | DefaultHandle()でデフォルトハンドル取得 | E-01 (107行), E-02 (142-144行) | ○ |
| C-08 | GetEnabledCategories()でカテゴリ取得 | E-01 (110行), E-02 (200-208行) | ○ |
| C-09 | カテゴリ空の場合に空文字列返却 | E-02 (200-208行) | ○ |
| C-10 | AppendTraceEvent()で全ライターにイベント追加 | E-01 (113行), E-02 (210-213行) | ○ |
| C-11 | AddMetadataEvent()でメタデータ追加 | E-01 (115行), E-02 (215-218行) | ○ |
| C-12 | Flush(blocking=true)でブロッキングフラッシュ | E-01 (117行), E-02 (220-229行) | ○ |
| C-13 | Flush(blocking=false)で非ブロッキングフラッシュ | E-02 (220-229行) | ○ |
| C-14 | CreateTraceConfig()でTraceConfig生成 | E-01 (119行), E-02 (190-198行) | ○ |
| C-15 | カテゴリ空でnullptr返却 | E-02 (191-192行) | ○ |
| C-16 | Start()でトレーシング開始 | E-02 (86-107行) | ○ |
| C-17 | 既に開始済みの場合は何もしない | E-02 (87-88行) | ○ |
| C-18 | StopTracing()でトレーシング停止 | E-02 (146-157行) | ○ |
| C-19 | 未開始の場合は何もしない | E-02 (147-148行) | ○ |
| C-20 | Disconnect()でクライアント切断 | E-02 (159-168行) | ○ |
| C-21 | デフォルトハンドルIDでは何もしない | E-02 (160行) | ○ |
| C-22 | Enable()でカテゴリ有効化 | E-02 (170-177行) | ○ |
| C-23 | 空カテゴリでは何もしない | E-02 (171-172行) | ○ |
| C-24 | Disable()でカテゴリ無効化 | E-02 (179-188行) | ○ |
| C-25 | 存在しないカテゴリの無効化 | E-02 (184-186行) | ○ |

### AgentWriterHandleクラス関連 (C-26 - C-39)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | デフォルトコンストラクタでempty状態 | E-01 (55行) | ○ |
| C-27 | デストラクタでreset呼び出し | E-01 (56行) | ○ |
| C-28 | ムーブ代入演算子の動作 | E-01 (164-170行) | ○ |
| C-29 | empty()でagent_がnullならtrue | E-01 (60行) | ○ |
| C-30 | empty()でagent_が有効ならfalse | E-01 (60行) | ○ |
| C-31 | reset()でagent_がnullなら何もしない | E-01 (158-162行) | ○ |
| C-32 | reset()でDisconnect呼び出し | E-01 (159-161行) | ○ |
| C-33 | Enable()でAgent::Enable呼び出し | E-01 (176-178行) | ○ |
| C-34 | Enable()でagent_がnullなら何もしない | E-01 (177行) | ○ |
| C-35 | Disable()でAgent::Disable呼び出し | E-01 (180-182行) | ○ |
| C-36 | IsDefaultHandle()でデフォルトハンドル判定 | E-01 (184-186行) | ○ |
| C-37 | IsDefaultHandle()で通常ハンドルはfalse | E-01 (184-186行) | ○ |
| C-38 | GetTracingController()でコントローラ取得 | E-01 (188-190行) | ○ |
| C-39 | GetTracingController()でagent_がnullならnullptr | E-01 (189行) | ○ |

### TracingControllerクラス関連 (C-40 - C-41)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | CurrentTimestampMicroseconds()でマイクロ秒取得 | E-01 (39-41行) | ○ |
| C-41 | AddMetadataEvent()でメタデータイベント追加 | E-01 (42-50行), E-02 (231-253行) | ○ |

### NodeTraceWriterクラス関連 (C-42 - C-58)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | コンストラクタでログファイルパターン設定 | E-03 (19行), E-04 (11-12行) | ○ |
| C-43 | デストラクタでクリーンアップ | E-03 (20行), E-04 (49-61行) | ○ |
| C-44 | InitializeOnThread()でスレッド初期化 | E-03 (22行), E-04 (14-30行) | ○ |
| C-45 | 既に初期化済みでアサート | E-04 (15行) | ○ |
| C-46 | AppendTraceEvent()で初回ファイルオープン | E-04 (99-114行) | ○ |
| C-47 | AppendTraceEvent()でイベント追加 | E-03 (23行), E-04 (99-114行) | ○ |
| C-48 | Flush(blocking=true)で待機 | E-03 (24行), E-04 (139-160行) | ○ |
| C-49 | Flush(blocking=false)で即座に戻る | E-04 (139-160行) | ○ |
| C-50 | Flush()でjson_trace_writer_がnullなら何もしない | E-04 (146-148行) | ○ |
| C-51 | OpenNewFileForStreaming()で新ファイルオープン | E-04 (73-97行) | ○ |
| C-52 | ${pid}と${rotation}の置換 | E-04 (79-81行) | ○ |
| C-53 | ファイルオープン失敗時のエラー処理 | E-04 (91-96行) | ○ |
| C-54 | WriteToFile()でキュー追加 | E-04 (162-182行) | ○ |
| C-55 | fd_=-1で何もしない | E-04 (163行) | ○ |
| C-56 | WriteSuffix()でトレースがあればフラッシュ | E-04 (32-47行) | ○ |
| C-57 | WriteSuffix()でトレースがなければ何もしない | E-04 (39-42行) | ○ |
| C-58 | kTracesPerFile定数確認 | E-03 (26行) | ○ |

### InternalTraceBufferクラス関連 (C-59 - C-73)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | コンストラクタで初期化 | E-05 (22行), E-06 (9-14行) | ○ |
| C-60 | AddTraceEvent()で新チャンク作成 | E-05 (24行), E-06 (16-32行) | ○ |
| C-61 | 既存チャンク満杯で新チャンク作成 | E-06 (19-26行) | ○ |
| C-62 | GetEventByHandle()でイベント取得 | E-05 (25行), E-06 (34-55行) | ○ |
| C-63 | ハンドル0でnullptr返却 | E-06 (36-39行) | ○ |
| C-64 | 別バッファIDでnullptr返却 | E-06 (43-48行) | ○ |
| C-65 | チャンクシーケンス不一致でnullptr返却 | E-06 (50-53行) | ○ |
| C-66 | Flush()で全イベント追加 | E-05 (26行), E-06 (57-79行) | ○ |
| C-67 | 名前がないイベントのスキップ | E-06 (69行) | ○ |
| C-68 | total_chunks_=0でスキップ | E-06 (60行) | ○ |
| C-69 | IsFull()で満杯判定 | E-05 (27-29行) | ○ |
| C-70 | IsFull()で空き判定 | E-05 (27-29行) | ○ |
| C-71 | IsFlushing()でフラッシュ中判定 | E-05 (30-32行) | ○ |
| C-72 | MakeHandle()でハンドル生成 | E-06 (81-85行) | ○ |
| C-73 | ExtractHandle()でハンドル分解 | E-06 (87-96行) | ○ |

### NodeTraceBufferクラス関連 (C-74 - C-83)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | コンストラクタで2バッファ初期化 | E-05 (53行), E-06 (98-113行) | ○ |
| C-75 | デストラクタでクリーンアップ | E-05 (54行), E-06 (115-121行) | ○ |
| C-76 | AddTraceEvent()で現在バッファにイベント追加 | E-05 (56行), E-06 (123-133行) | ○ |
| C-77 | 両バッファ満杯でnullptr返却 | E-06 (125-131行) | ○ |
| C-78 | GetEventByHandle()でイベント取得 | E-05 (57行), E-06 (135-137行) | ○ |
| C-79 | Flush()で両バッファフラッシュ | E-05 (58行), E-06 (139-143行) | ○ |
| C-80 | TryLoadAvailableBuffer()で空き確認 | E-06 (148-161行) | ○ |
| C-81 | バッファ切替とflush_signal_送信 | E-06 (150-158行) | ○ |
| C-82 | 両バッファ満杯でfalse返却 | E-06 (156-158行) | ○ |
| C-83 | kBufferChunks定数確認 | E-05 (60行) | ○ |

### TracedValueクラス関連 (C-84 - C-108)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | Create()でオブジェクト形式作成 | E-09 (82行), E-10 (106-108行) | ○ |
| C-85 | CreateArray()で配列形式作成 | E-09 (83行), E-10 (110-112行) | ○ |
| C-86 | SetInteger()で整数値設定 | E-09 (89行), E-10 (117-120行) | ○ |
| C-87 | SetDouble()で浮動小数点値設定 | E-09 (90行), E-10 (122-125行) | ○ |
| C-88 | SetDouble()でNaN処理 | E-10 (92行) | ○ |
| C-89 | SetDouble()でInfinity処理 | E-10 (93行) | ○ |
| C-90 | SetBoolean()で真偽値設定 | E-09 (91行), E-10 (127-130行) | ○ |
| C-91 | SetNull()でnull値設定 | E-09 (92行), E-10 (132-135行) | ○ |
| C-92 | SetString()で文字列値設定 | E-09 (93行), E-10 (137-140行) | ○ |
| C-93 | SetString()でエスケープ処理 | E-10 (30-88行) | ○ |
| C-94 | BeginDictionary()で辞書開始 | E-09 (97行), E-10 (142-146行) | ○ |
| C-95 | EndDictionary()で辞書終了 | E-09 (85行), E-10 (191-194行) | ○ |
| C-96 | BeginArray()で配列開始 | E-09 (98行), E-10 (148-152行) | ○ |
| C-97 | EndArray()で配列終了 | E-09 (86行), E-10 (196-199行) | ○ |
| C-98 | AppendInteger()で配列に整数追加 | E-09 (100行), E-10 (154-157行) | ○ |
| C-99 | AppendDouble()で配列に浮動小数点追加 | E-09 (101行), E-10 (159-162行) | ○ |
| C-100 | AppendBoolean()で配列に真偽値追加 | E-09 (102行), E-10 (164-167行) | ○ |
| C-101 | AppendNull()で配列にnull追加 | E-09 (103行), E-10 (169-172行) | ○ |
| C-102 | AppendString()で配列に文字列追加 | E-09 (104行), E-10 (174-177行) | ○ |
| C-103 | BeginArray()無名配列開始 | E-09 (106行), E-10 (185-189行) | ○ |
| C-104 | BeginDictionary()無名辞書開始 | E-09 (107行), E-10 (179-183行) | ○ |
| C-105 | AppendAsTraceFormat()でオブジェクト形式出力 | E-09 (110行), E-10 (216-220行) | ○ |
| C-106 | AppendAsTraceFormat()で配列形式出力 | E-10 (217-219行) | ○ |
| C-107 | WriteComma()でfirst_item_=trueならカンマなし | E-10 (201-207行) | ○ |
| C-108 | WriteComma()でfirst_item_=falseならカンマあり | E-10 (201-207行) | ○ |

### 変換クラス関連 (C-109 - C-111)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | EnvironmentArgs::Cast()で環境引数変換 | E-09 (22-33行), E-10 (222-231行) | ○ |
| C-110 | AsyncWrapArgs::Cast()でAsyncWrap変換 | E-09 (35-46行), E-10 (233-238行) | ○ |
| C-111 | ProcessMeta::Cast()でメタデータ変換 | E-09 (48-51行), E-10 (240-259行) | ○ |

### TraceEventHelperクラス関連 (C-112 - C-120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | GetTracingController()でコントローラ取得 | E-07 (315行), E-08 (24-26行) | ○ |
| C-113 | GetTracingController()で未設定時nullptr | E-08 (24-26行) | ○ |
| C-114 | SetTracingController()でコントローラ設定 | E-07 (316行), E-08 (28-30行) | ○ |
| C-115 | GetAgent()でエージェント取得 | E-07 (318行), E-08 (20-22行) | ○ |
| C-116 | GetAgent()で未設定時nullptr | E-08 (20-22行) | ○ |
| C-117 | SetAgent()でエージェント設定 | E-07 (319行), E-08 (10-18行) | ○ |
| C-118 | SetAgent(nullptr)でクリア | E-08 (14-17行) | ○ |
| C-119 | GetCategoryGroupEnabled()でカテゴリ有効確認 | E-07 (321-328行) | ○ |
| C-120 | コントローラ未設定で無効値返却 | E-07 (323-326行) | ○ |

### TraceIDクラス関連 (C-121 - C-126)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | WithScopeコンストラクタ | E-07 (336-346行) | ○ |
| C-122 | DontMangleコンストラクタ | E-07 (348-371行) | ○ |
| C-123 | ForceMangleコンストラクタ | E-07 (373-390行) | ○ |
| C-124 | void*からのID作成とマングリングフラグ | E-07 (392-395行) | ○ |
| C-125 | TraceStringWithCopyコンストラクタ | E-07 (451-458行) | ○ |
| C-126 | TraceStringWithCopyキャスト演算子 | E-07 (454行) | ○ |

### ScopedTracerクラス関連 (C-127 - C-130)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-127 | ScopedTracer()デフォルトコンストラクタ | E-07 (688行) | ○ |
| C-128 | ~ScopedTracer()でUpdateTraceEventDuration呼び出し | E-07 (690-694行) | ○ |
| C-129 | 未初期化デストラクタ | E-07 (691行) | ○ |
| C-130 | Initialize()でデータ初期化 | E-07 (696-702行) | ○ |

### AddTraceEvent関連 (C-131 - C-150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | AddTraceEventImpl正常系 | E-07 (460-481行) | ○ |
| C-132 | AddTraceEventImplコントローラ未設定 | E-07 (477行) | ○ |
| C-133 | AddTraceEventImplでConvertable処理 | E-07 (466-473行) | ○ |
| C-134 | AddTraceEventWithTimestampImpl | E-07 (483-504行) | ○ |
| C-135 | AddMetadataEventImpl正常系 | E-07 (506-525行) | ○ |
| C-136 | AddMetadataEventImplでAgent未設定 | E-07 (521行) | ○ |
| C-137 | SetTraceValue(uint64_t) | E-07 (547行) | ○ |
| C-138 | SetTraceValue(int64_t) | E-07 (551行) | ○ |
| C-139 | SetTraceValue(bool) | E-07 (555行) | ○ |
| C-140 | SetTraceValue(double) | E-07 (556行) | ○ |
| C-141 | SetTraceValue(const void*) | E-07 (557-558行) | ○ |
| C-142 | SetTraceValue(const char*) | E-07 (559-560行) | ○ |
| C-143 | SetTraceValue(TraceStringWithCopy) | E-07 (561-562行) | ○ |
| C-144 | SetTraceValue(ConvertableToTraceFormat*) | E-07 (567-571行) | ○ |
| C-145 | AddTraceEvent(0引数) | E-07 (586-594行) | ○ |
| C-146 | AddTraceEvent(1引数) | E-07 (596-608行) | ○ |
| C-147 | AddTraceEvent(2引数) | E-07 (610-627行) | ○ |
| C-148 | AddTraceEventWithTimestamp(0引数) | E-07 (629-636行) | ○ |
| C-149 | AddTraceEventWithTimestamp(1引数) | E-07 (638-650行) | ○ |
| C-150 | AddMetadataEvent | E-07 (671-682行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースがソースコードから直接導出されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードの実装に基づいている
- 注意点：
  - マルチスレッド関連のテスト（Agent::Start, NodeTraceBuffer等）は実行環境依存のため、実際のテスト実装時に追加の考慮が必要
  - libuv依存の機能（uv_async_t, uv_fs_t等）はモック化が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Agent関連のテストケース（C-01〜C-25）が全てのpublicメソッドをカバーしているか確認
- [ ] AgentWriterHandle関連のテストケース（C-26〜C-39）がRAIIパターンを正しくテストしているか確認
- [ ] NodeTraceWriter関連のテストケース（C-42〜C-58）がファイルI/Oのエラー処理を網羅しているか確認
- [ ] InternalTraceBuffer/NodeTraceBuffer関連のテストケース（C-59〜C-83）がバッファオーバーフローを正しく処理しているか確認
- [ ] TracedValue関連のテストケース（C-84〜C-108）がJSON出力形式を正しく検証しているか確認
- [ ] TraceEventHelper関連のテストケース（C-112〜C-120）がグローバル状態の管理を正しくテストしているか確認
- [ ] マルチスレッドテストの実装可能性を検討（特にMutex, ConditionVariable使用箇所）
