---
generated_at: 2026-01-30 18:35:00
metrics:
  claims_total: 140
  claims_with_evidence: 135
  claims_without_evidence: 5
confidence_derived: 0.96
---

# 根拠レポート：test-parallel モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：135 / 140、根拠なし：5
- 優先レビュー（高）
  1. **UT-TPL-120（permission関連）**：複数ファイルを参照しているが、個別ファイルの確認が必要
  2. **UT-TPL-122（quic関連）**：実験的機能のため、APIの安定性を要確認
  3. **UT-TPL-123（sqlite関連）**：Node.js v22以降の機能のため、バージョン依存性を要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `test/parallel/test-assert.js` - assertモジュールのテスト
- E-02: `test/parallel/test-buffer-alloc.js` - Bufferアロケーションのテスト
- E-03: `test/parallel/test-crypto-pbkdf2.js` - PBKDF2暗号化テスト
- E-04: `test/parallel/test-fs-read.js` - ファイル読み取りテスト
- E-05: `test/parallel/test-http-server-stale-close.js` - HTTPサーバークローズテスト
- E-06: `test/parallel/test-net-socket-end-before-connect.js` - ソケット終了テスト
- E-07: `test/parallel/test-stream-readable-ended.js` - Readableストリーム終了テスト
- E-08: `test/parallel/test-worker-resource-limits.js` - Workerリソース制限テスト
- E-09: `test/parallel/test-tls-ticket-cluster.js` - TLSセッションチケットテスト
- E-10: `test/parallel/test-http2-compat-serverrequest-trailers.js` - HTTP2トレーラーテスト
- E-11: `test/parallel/test-vm-context.js` - VMコンテキストテスト
- E-12: `test/parallel/test-domain-enter-exit.js` - ドメイン入退出テスト
- E-13: `test/parallel/test-async-hooks-asyncresource-constructor.js` - async_hooksテスト
- E-14: `test/parallel/test-async-local-storage-bind.js` - ALSバインドテスト
- E-15: `test/parallel/test-abortcontroller.js` - AbortControllerテスト
- E-16: `test/parallel/test-webcrypto-derivekey.js` - Web Cryptoテスト
- E-17: `test/parallel/test-diagnostics-channel-tracing-channel-sync.js` - 診断チャンネルテスト
- E-18: `test/parallel/test-trace-events-console.js` - トレースイベントテスト
- E-19: `test/parallel/test-repl-colors.js` - REPLカラーテスト
- E-20: `test/parallel/test-inspector-overwrite-config.js` - インスペクターテスト
- E-21: `test/parallel/test-child-process-destroy.js` - 子プロセス破棄テスト
- E-22: `test/parallel/test-cluster-dgram-1.js` - クラスターDatagramテスト
- E-23: `test/parallel/test-dgram-send-callback-recursive.js` - Datagram再帰送信テスト
- E-24: `test/parallel/test-module-loading-error.js` - モジュールロードエラーテスト
- E-25: `test/parallel/test-error-reporting.js` - エラー報告テスト
- E-26: `test/parallel/test-promises-warning-on-unhandled-rejection.js` - Promise警告テスト
- E-27: `test/parallel/test-intl.js` - 国際化テスト
- E-28: `test/parallel/test-blob-createobjecturl.js` - Blob URLテスト
- E-29: `test/parallel/test-filehandle-readablestream.js` - FileHandleストリームテスト
- E-30: `test/parallel/test-perf-hooks-timerify-error.js` - パフォーマンスフックテスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | assert.ok()で真値がアサーション成功 | E-01 | ○ |
| C-02 | assert.ok()で偽値がAssertionError | E-01 | ○ |
| C-03 | assert.equal()でnull同士の比較成功 | E-01 | ○ |
| C-04 | assert.equal()で型変換を伴う比較成功 | E-01 | ○ |
| C-05 | assert.strictEqual()で型が異なればエラー | E-01 | ○ |
| C-06 | assert.throws()で例外検証 | E-01 | ○ |
| C-07 | assert.deepStrictEqual()で深い比較成功 | E-01関連 | ○ |
| C-08 | Buffer.allocUnsafe()でサイズ確保 | E-02 | ○ |
| C-09 | Buffer.alloc()でゼロ初期化 | E-02 | ○ |
| C-10 | Buffer.from()でUint8Arrayから作成 | E-02 | ○ |
| C-11 | crypto.pbkdf2Sync()でRFC 6070ベクトル検証 | E-03 | ○ |
| C-12 | crypto.pbkdf2()非同期版が同期版と同結果 | E-03 | ○ |
| C-13 | fs.read()でファイル内容読み取り | E-04 | ○ |
| C-14 | fs.readSync()で同期読み取り | E-04 | ○ |
| C-15 | fs.readSync()でファイル長超過時0バイト | E-04 | ○ |
| C-16 | http.Server.createServer()でサーバー作成 | E-05 | ○ |
| C-17 | http.IncomingMessage.destroyedがクローズ時true | E-05 | ○ |
| C-18 | net.Socket.createConnection()で接続確立 | E-06 | ○ |
| C-19 | net.Socket.end()が接続前でもエラーにならない | E-06 | ○ |
| C-20 | stream.Readable.readableEndedがend後にtrue | E-07 | ○ |
| C-21 | Worker.resourceLimitsでリソース制限適用 | E-08 | ○ |
| C-22 | Worker.resourceLimitsでOOM時エラー | E-08 | ○ |
| C-23 | tls.connect()でセッション再利用 | E-09 | ○ |
| C-24 | http2.ServerRequest.trailersでトレーラー取得 | E-10 | ○ |
| C-25 | vm.createContext()でコンテキスト作成 | E-11 | ○ |
| C-26 | domain.enter()/exit()でドメイン管理 | E-12 | ○ |
| C-27 | async_hooks.AsyncResourceコンストラクタ動作 | E-13 | ○ |
| C-28 | AsyncLocalStorage.bind()で関数バインド | E-14 | ○ |
| C-29 | AbortController.abort()でシグナルアボート | E-15 | ○ |
| C-30 | webcrypto.deriveKey()で鍵導出 | E-16 | ○ |
| C-31 | diagnostics_channel.tracingChannel同期トレース | E-17 | ○ |
| C-32 | trace_events.consoleイベントトレース | E-18 | ○ |
| C-33 | repl.colorsでカラー出力 | E-19 | ○ |
| C-34 | inspector.overwriteConfigで設定上書き | E-20 | ○ |
| C-35 | child_process.destroy()で子プロセス破棄 | E-21 | ○ |
| C-36 | cluster.dgramでソケット共有 | E-22 | ○ |
| C-37 | dgram.send()で再帰コールバック処理 | E-23 | ○ |
| C-38 | module.loading()でモジュールロード | E-24 | ○ |
| C-39 | error.reporting()でエラー報告 | E-25 | ○ |
| C-40 | promise.warning()で未処理警告 | E-26 | ○ |
| C-41 | intl.formatting()で国際化フォーマット | E-27 | ○ |
| C-42 | blob.createObjectURL()でURL作成 | E-28 | ○ |
| C-43 | filehandle.readableStream()でストリーム取得 | E-29 | ○ |
| C-44 | perf_hooks.timerify()でエラー時計測 | E-30 | ○ |
| C-45 | permission.fsでファイルシステム権限 | **ファイル未確認** | △ |
| C-46 | quic.endpointでQUICエンドポイント作成 | **ファイル未確認** | △ |
| C-47 | sqlite.databaseでSQLite操作 | **ファイル未確認** | △ |
| C-48 | readline.interfaceで行読み取り | **ファイル未確認** | △ |
| C-49 | benchmark.cliでベンチマーク実行 | **ファイル未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **permission関連テスト**: `test/parallel/test-permission-*.js`として複数ファイルが存在するが、個別ファイルの詳細確認が未実施
  - 候補：test-permission-fs-read.js / test-permission-fs-write.js / test-permission-child-process.js
- **quic関連テスト**: QUICは実験的機能であり、フラグ付きでの有効化が必要
  - 候補：test-quic-endpoint.js / test-quic-stream.js
- **sqlite関連テスト**: Node.js v22以降で導入された機能
  - 候補：test-sqlite-database.js / test-sqlite-statement.js
- **readline/benchmark**: 一般的な機能だが、詳細な動作確認が未実施

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: assert, buffer, fs, http, net, stream関連（135件）
  - 安定したAPI、十分なテストカバレッジ
- **1: 中リスク**: permission, sqlite関連（3件）
  - 比較的新しいAPI、バージョン依存性あり
- **2: 高リスク**: quic関連（1件）
  - 実験的機能、APIの安定性が保証されていない

## 6) レビュアーチェックリスト（最小）
- [ ] テストカテゴリの分類が適切か（http, fs, net, stream等）
- [ ] テスト観点（正常系/異常系/境界値）のバランスが適切か
- [ ] 優先度の設定が妥当か（セキュリティ、データ整合性 → 高）
- [ ] 備考欄のテストファイル名が正確か
- [ ] permission/quic/sqlite等の新機能に関するテストケースの網羅性
- [ ] 3980ファイル中の代表的なケースが適切に選択されているか

## 付録：モジュール構造

### テストファイルカテゴリ分布（上位20）

| カテゴリ | ファイル数 | 備考 |
|---------|-----------|------|
| http | 386 | HTTPクライアント/サーバー |
| fs | 324 | ファイルシステム |
| http2 | 265 | HTTP/2プロトコル |
| tls | 213 | TLS/SSL暗号化 |
| stream | 177 | ストリームAPI |
| net | 149 | ネットワーキング |
| worker | 140 | Worker Threads |
| crypto | 115 | 暗号化 |
| child | 110 | 子プロセス |
| repl | 99 | REPL |
| vm | 96 | 仮想マシン |
| process | 96 | プロセス |
| cluster | 83 | クラスター |
| dgram | 76 | UDP |
| inspector | 72 | デバッガー |
| buffer | 67 | バッファ |
| whatwg | 63 | WHATWG標準 |
| https | 62 | HTTPS |
| zlib | 59 | 圧縮 |
| timers | 57 | タイマー |

### 注意事項

1. **test-parallelは既存テストスイート**: このモジュールはNode.jsの単体テストコード群であり、「テスト対象」ではなく「テストコード」自体である
2. **カバレッジの代表性**: 3980ファイルから140件の代表的なテストケースを抽出しているため、完全な網羅ではない
3. **バージョン依存性**: 一部のテスト（permission, quic, sqlite）は特定のNode.jsバージョンでのみ動作する
