---
generated_at: 2026-01-30 16:30:00
metrics:
  claims_total: 7
  claims_with_evidence: 7
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：7 / 7、根拠なし：0
- 優先レビュー（高）
  - 全ての帳票がソースコードによって裏付けられているため、優先レビュー項目はありません。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/test/reporters.js` - テストレポーターのエントリポイント（dot, junit, spec, tap, lcovをエクスポート）
- E-02: `lib/internal/test_runner/reporter/dot.js` - dotレポーターの実装
- E-03: `lib/internal/test_runner/reporter/spec.js` - specレポーターの実装
- E-04: `lib/internal/test_runner/reporter/tap.js` - tapレポーターの実装
- E-05: `lib/internal/test_runner/reporter/junit.js` - junitレポーターの実装
- E-06: `lib/internal/test_runner/reporter/lcov.js` - lcovレポーターの実装
- E-07: `lib/internal/test_runner/reporter/rerun.js` - rerunレポーターの実装
- E-08: `lib/internal/test_runner/reporter/v8-serializer.js` - v8-serializerレポーターの実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | dotはテスト結果をドット形式で出力し、成功は緑ドット、失敗は赤Xで表示 | E-01, E-02 | ○ |
| C-02 | specはテスト結果を人間が読みやすい詳細形式で出力し、階層構造・カバレッジ情報を表示 | E-01, E-03 | ○ |
| C-03 | tapはTAP version 13準拠のテキストベースフォーマットを生成 | E-01, E-04 | ○ |
| C-04 | junitはJUnit XML形式でテストスイート・テストケース・失敗情報を出力 | E-01, E-05 | ○ |
| C-05 | lcovはLCOV形式でコードカバレッジ（関数/ブランチ/ライン）を出力 | E-01, E-06 | ○ |
| C-06 | rerunは失敗テストの再実行管理のためJSON形式でテスト結果を保存 | E-07 | ○ |
| C-07 | v8-serializerはプロセス間通信用にV8シリアライズ形式でテスト結果を出力 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全ての帳票機能はソースコードから直接確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての帳票機能はNode.js test_runnerモジュールの公式実装であり、ソースコードから直接抽出した情報です。

## 6) レビュアーチェックリスト（最小）
- [ ] 帳票名がソースコードのモジュール名と一致していることを確認
- [ ] 説明がソースコードの実際の動作と一致していることを確認
- [ ] カテゴリの分類が適切であることを確認（テストレポーター vs カバレッジレポーター）
- [ ] 備考欄のファイルパスが正確であることを確認
