# 帳票設計書 1-dot

## 概要

本ドキュメントは、Node.jsテストランナーの「dotレポーター」の設計仕様を記載したものである。テスト結果を簡潔なドット形式で出力するレポーター機能の実装詳細、出力形式、処理フローについて説明する。

### 本帳票の処理概要

dotレポーターは、Node.jsテストランナーが実行したテスト結果を、視覚的に分かりやすいドット形式で標準出力に表示する帳票である。各テストの成否を1文字で表現することで、大量のテスト結果を一目で把握できるようにする。

**業務上の目的・背景**：開発者がテスト実行時に、テストスイート全体の進行状況と結果を瞬時に把握する必要がある。特にCI/CD環境や大規模なテストスイートにおいて、詳細な出力を抑制しつつ、成功/失敗の概要を視覚的に確認できることが求められる。dotレポーターは、この要件に対応するためのミニマルなレポート形式を提供する。

**帳票の利用シーン**：
- CI/CDパイプラインでの自動テスト実行時
- ローカル開発環境でのテスト実行時（簡潔な出力が好まれる場合）
- 大量のテストを含むテストスイートの実行監視
- ターミナル幅に応じた視覚的なテスト進行状況の確認

**主要な出力内容**：
1. 成功テストを示す緑色のドット(.)
2. 失敗テストを示す赤色のX(X)
3. ターミナル幅に応じた自動改行
4. テスト完了後の失敗テスト詳細一覧

**帳票の出力タイミング**：
- テストランナーがテストファイルを実行中、各テストの完了時にリアルタイムで出力
- 全テスト完了後に失敗テストの詳細を出力

**帳票の利用者**：
- ソフトウェア開発者
- QAエンジニア
- DevOpsエンジニア
- CI/CDシステム

## 帳票種別

テストレポート / コンソール出力形式

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIターミナル | `node --test --test-reporter=dot` | テスト実行コマンド |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（コンソール出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力へ直接出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

### コンソール出力固有設定

| 項目 | 内容 |
|-----|------|
| ANSIカラー対応 | 有（緑/赤/白） |
| ターミナル幅対応 | 有（動的取得） |
| 最小カラム数 | 20 |

## 帳票レイアウト

### レイアウト概要

ドットレポーターは、テスト結果を1行に複数のドット/Xを表示し、ターミナル幅に達すると自動改行する。全テスト完了後、失敗テストがある場合は詳細情報を出力する。

```
┌─────────────────────────────────────┐
│          ドット出力部               │
│  ....X..........X...............   │
│  ................................   │
├─────────────────────────────────────┤
│          失敗詳細部                 │
│  Failed tests:                      │
│    [テスト名] - [エラー詳細]        │
└─────────────────────────────────────┘
```

### ドット出力部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 成功ドット | テスト成功を示す | test:pass イベント | 緑色 `.` |
| 2 | 失敗X | テスト失敗を示す | test:fail イベント | 赤色 `X` |
| 3 | 改行 | ターミナル幅到達時 | process.stdout.columns | `\n` |

### 失敗詳細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 失敗ヘッダー | 失敗テスト一覧のヘッダー | 固定文字列 | 赤色 `Failed tests:` |
| 2 | テスト詳細 | 各失敗テストの詳細 | formatTestReport関数 | テキスト |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| テスト結果イベント | `test:pass` または `test:fail` イベントが発生 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | イベント発生順 | 昇順（時系列） |

### 改ページ条件

ターミナル幅（最小20カラム）に達した場合に改行を挿入する。

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを参照しない。テストランナーからのイベントストリームを入力として使用する。

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | - | - |

### イベントデータ構造

#### test:pass イベント

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| type | イベント種別判定 | `type === 'test:pass'` | 成功ドット出力トリガー |
| data | テストデータ | - | 失敗時のみ使用 |

#### test:fail イベント

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| type | イベント種別判定 | `type === 'test:fail'` | 失敗X出力トリガー |
| data | 失敗テスト詳細 | - | failedTests配列に格納 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 行内カウント | count++ | N/A | カラム数到達で0にリセット |
| カラム数 | MathMax(process.stdout.columns ?? 20, 20) | N/A | 最小20カラム保証 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[テストランナーからイベント受信] --> B{イベントタイプ判定}
    B -->|test:pass| C[緑色ドット出力]
    B -->|test:fail| D[赤色X出力]
    D --> E[失敗テストを配列に追加]
    C --> F{カラム数到達?}
    E --> F
    F -->|Yes| G[改行出力・カウントリセット]
    F -->|No| H[カウントインクリメント]
    G --> I{次のイベントあり?}
    H --> I
    I -->|Yes| A
    I -->|No| J[最終改行出力]
    J --> K{失敗テストあり?}
    K -->|Yes| L[失敗テスト詳細出力]
    K -->|No| M[終了]
    L --> M
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 出力エラー | 標準出力への書き込み失敗 | - | ジェネレータが例外をスロー |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 無制限（ストリーム処理） |
| 目標出力時間 | イベント受信後即時出力 |
| 同時出力数上限 | 1（シングルストリーム） |

## セキュリティ考慮事項

- テスト名やエラーメッセージに含まれる機密情報がそのまま出力される可能性がある
- ターミナルへの出力のため、出力内容は実行環境のコンソールログに残る

## 備考

- ANSIエスケープシーケンスを使用して色付け出力を行う
- ターミナルリサイズに対応し、動的にカラム数を再取得する
- 非同期ジェネレータ関数として実装されている

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テストイベントの構造とレポーターに渡されるデータ形式を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | test.js | `lib/internal/test_runner/test.js` | テストイベントの生成元、kSubtestsFailed定数の定義 |
| 1-2 | utils.js | `lib/internal/test_runner/reporter/utils.js` | formatTestReport関数、色定義、シンボル定義 |

**読解のコツ**: primordials はNode.js内部で使用される組み込みメソッドの安全なラッパーである。

#### Step 2: エントリーポイントを理解する

dotレポーターのメインロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | dot.js | `lib/internal/test_runner/reporter/dot.js` | メインのジェネレータ関数 |

**主要処理フロー**:
1. **9行目**: `module.exports = async function* dot(source)` - 非同期ジェネレータ関数としてエクスポート
2. **10-12行目**: 初期化処理（カウント、カラム数、失敗テスト配列）
3. **13-28行目**: イベントループ - test:pass/test:fail の処理
4. **14-16行目**: test:pass時に緑色ドットをyield
5. **17-20行目**: test:fail時に赤色Xをyieldし、失敗テストを配列に追加
6. **21-27行目**: カラム数到達時の改行処理
7. **30-35行目**: 失敗テストの詳細出力

#### Step 3: ユーティリティ関数を理解する

レポーターで使用されるユーティリティ関数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | utils.js | `lib/internal/test_runner/reporter/utils.js` | formatTestReport関数の実装 |
| 3-2 | colors.js | `lib/internal/util/colors.js` | ANSIカラーコードの定義 |

**主要処理フロー**:
- **70-92行目**: formatTestReport関数 - テスト結果の整形出力

#### Step 4: テストランナーとの連携を理解する

レポーターがテストランナーからどのように呼び出されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | utils.js | `lib/internal/test_runner/utils.js` | kBuiltinReportersマップ、getReportersMap関数 |
| 4-2 | runner.js | `lib/internal/test_runner/runner.js` | レポーターの初期化と接続 |

**主要処理フロー**:
- **125-131行目**: kBuiltinReportersマップでdotレポーターを登録
- **168-203行目**: getReportersMap関数でレポーターをロード

### プログラム呼び出し階層図

```
node --test --test-reporter=dot
    │
    ├─ lib/internal/test_runner/runner.js
    │      └─ parseCommandLine() → getReportersMap()
    │              └─ require('internal/test_runner/reporter/dot')
    │
    └─ lib/internal/test_runner/reporter/dot.js
           ├─ colors.green / colors.red / colors.reset
           │      └─ lib/internal/util/colors.js
           │
           └─ formatTestReport()
                  └─ lib/internal/test_runner/reporter/utils.js
```

### データフロー図

```
[入力]                    [処理]                         [出力]

テストイベント ───▶ dot.js ジェネレータ ───▶ 標準出力(stdout)
  ストリーム              │
                         ├─ test:pass → 緑ドット
                         ├─ test:fail → 赤X + 配列格納
                         └─ 終了時 → 失敗詳細出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| dot.js | `lib/internal/test_runner/reporter/dot.js` | ソース | dotレポーターのメイン実装 |
| utils.js | `lib/internal/test_runner/reporter/utils.js` | ソース | レポーター共通ユーティリティ |
| colors.js | `lib/internal/util/colors.js` | ソース | ANSIカラーコード定義 |
| utils.js | `lib/internal/test_runner/utils.js` | ソース | テストランナーユーティリティ |
| runner.js | `lib/internal/test_runner/runner.js` | ソース | テストランナーのメイン処理 |
| test.js | `lib/internal/test_runner/test.js` | ソース | テスト定義とイベント生成 |
