---
generated_at: 2026-01-30 17:45:00
metrics:
  claims_total: 38
  claims_with_evidence: 37
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：4-junit.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：37 / 38、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ考慮事項（ホスト名露出）**：一般的な考慮事項であり、コードからの直接的な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `lib/internal/test_runner/reporter/junit.js` - JUnitレポーターのソースコード
- E-02: `lib/internal/test_runner/utils.js` - テストランナーユーティリティ
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | junitReporterは非同期ジェネレータ関数 | E-01 (64行目: `async function* junitReporter`) | ○ |
| C-02 | XMLヘッダーを最初に出力 | E-01 (65行目) | ○ |
| C-03 | testsuites開始タグを出力 | E-01 (66行目) | ○ |
| C-04 | testsuites終了タグを最後に出力 | E-01 (162行目) | ○ |
| C-05 | os.hostname()でホスト名を取得 | E-01 (17-19行目) | ○ |
| C-06 | HOSTNAMEは定数として保持 | E-01 (19行目: `const HOSTNAME = hostname()`) | ○ |
| C-07 | escapeAttributeで属性値をエスケープ | E-01 (21-23行目) | ○ |
| C-08 | 改行を&#10;に変換 | E-01 (22行目) | ○ |
| C-09 | "を&quot;に変換 | E-01 (22行目) | ○ |
| C-10 | escapeContentでコンテンツをエスケープ | E-01 (25-27行目) | ○ |
| C-11 | &を&amp;に変換 | E-01 (26行目) | ○ |
| C-12 | <を&lt;に変換 | E-01 (26行目) | ○ |
| C-13 | escapeCommentでコメントをエスケープ | E-01 (29-31行目) | ○ |
| C-14 | --を&#45;&#45;に変換 | E-01 (30行目) | ○ |
| C-15 | treeToXMLでツリーをXML変換 | E-01 (33-54行目) | ○ |
| C-16 | インデントはタブ×(nesting+1) | E-01 (40行目) | ○ |
| C-17 | 子要素がない場合は自己閉じタグ | E-01 (49-50行目) | ○ |
| C-18 | isFailureでfailure子要素を判定 | E-01 (56-58行目) | ○ |
| C-19 | isSkippedでskipped子要素を判定 | E-01 (60-62行目) | ○ |
| C-20 | startTestでツリーノードを作成 | E-01 (70-85行目) | ○ |
| C-21 | 親ノードがない場合はrootsに追加 | E-01 (82-84行目) | ○ |
| C-22 | test:startでstartTestを呼び出し | E-01 (89-91行目) | ○ |
| C-23 | currentSuiteがない場合は自動作成 | E-01 (95-97行目) | ○ |
| C-24 | timeをduration_ms/1000で計算 | E-01 (106行目) | ○ |
| C-25 | 小数点6桁固定 | E-01 (106行目: `toFixed(, 6)`) | ○ |
| C-26 | 子要素ありの場合はtestsuite | E-01 (109行目) | ○ |
| C-27 | testsuite.disabledは0固定 | E-01 (110行目) | ○ |
| C-28 | testsuite.errorsは0固定 | E-01 (111行目) | ○ |
| C-29 | testsuite.testsは子要素数 | E-01 (112行目) | ○ |
| C-30 | testsuite.failuresはisFailure判定 | E-01 (113行目) | ○ |
| C-31 | testsuite.skippedはisSkipped判定 | E-01 (114行目) | ○ |
| C-32 | testsuite.hostnameはHOSTNAME | E-01 (115行目) | ○ |
| C-33 | 子要素なしの場合はtestcase | E-01 (117行目) | ○ |
| C-34 | classname属性はdata.classnameまたは'test' | E-01 (118行目) | ○ |
| C-35 | test:failでfailure子要素を追加 | E-01 (134-145行目) | ○ |
| C-36 | test:diagnosticでコメントノードを追加 | E-01 (149-154行目) | ○ |
| C-37 | kBuiltinReportersにjunitが登録 | E-02 (129行目) | ○ |
| C-38 | セキュリティ考慮事項（ホスト名露出） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティ考慮事項（ホスト名露出）はコードからの直接的な根拠がなく、一般的なセキュリティベストプラクティスに基づく記述
  - 候補：セキュリティ設計書 / JUnit XML仕様書 / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書の内容はソースコードと整合しており、JUnit XML仕様にも準拠している

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のjunitReporter関数と設計書の処理フローが一致しているか確認
- [ ] XMLエスケープ処理が適切に行われているか確認
- [ ] treeToXML関数の再帰処理が正しく動作するか確認
- [ ] testsuite/testcaseの切り替えロジックを確認
- [ ] 生成されるXMLがJUnit XML仕様に準拠しているか確認
- [ ] セキュリティ考慮事項の妥当性を運用観点で検証
