---
generated_at: 2026-01-30 17:55:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：6-rerun.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ考慮事項**：一般的な考慮事項であり、コードからの直接的な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `lib/internal/test_runner/reporter/rerun.js` - Rerunレポーターのソースコード
- E-02: `lib/internal/test_runner/utils.js` - テストランナーユーティリティ（parsePreviousRuns）
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | reportReruns関数はクロージャを返す | E-01 (11-12行目) | ○ |
| C-02 | previousRunsとglobalOptionsを受け取る | E-01 (11行目) | ○ |
| C-03 | getTestIdで相対パス:行:列形式のIDを生成 | E-01 (18-20行目) | ○ |
| C-04 | relative(globalOptions.cwd, data.file)を使用 | E-01 (19行目) | ○ |
| C-05 | startTestでツリーノードを作成 | E-01 (22-31行目) | ○ |
| C-06 | 親スイートがない場合はrootsに追加 | E-01 (28-29行目) | ○ |
| C-07 | test:startでstartTestを呼び出し | E-01 (35-36行目) | ○ |
| C-08 | test:pass/failでツリーを更新 | E-01 (37-47行目) | ○ |
| C-09 | test:passのみ結果オブジェクトに追加 | E-01 (51行目: `if (type === 'test:pass')`) | ○ |
| C-10 | disambiguatorで重複IDを管理 | E-01 (14, 52-58行目) | ○ |
| C-11 | 重複時は連番を付与 | E-01 (53-55行目) | ○ |
| C-12 | passed_on_attemptを記録 | E-01 (64行目) | ○ |
| C-13 | passed_on_attempt ?? attemptでフォールバック | E-01 (64行目) | ○ |
| C-14 | childrenをArrayPrototypeMapで取得 | E-01 (59行目) | ○ |
| C-15 | previousRunsにobjを追加 | E-01 (69行目) | ○ |
| C-16 | writeFileSyncでJSON保存 | E-01 (70行目) | ○ |
| C-17 | JSONStringifyの第3引数でインデント2 | E-01 (70行目) | ○ |
| C-18 | globalOptions.rerunFailuresFilePathに保存 | E-01 (70行目) | ○ |
| C-19 | parsePreviousRunsで既存ファイル読み込み | E-02 (154-166行目) | ○ |
| C-20 | ENOENTエラーは空配列として扱う | E-02 (159-160行目) | ○ |
| C-21 | __proto__: nullでオブジェクト初期化 | E-01 (13-14, 60-61行目) | ○ |
| C-22 | obj[identifier]にテスト情報を格納 | E-01 (60-65行目) | ○ |
| C-23 | nameプロパティにdata.nameを格納 | E-01 (62行目) | ○ |
| C-24 | currentSuiteで現在のスイートを追跡 | E-01 (15, 44-46行目) | ○ |
| C-25 | 帳票名は「rerun」 | E-03 (7行目) | ○ |
| C-26 | カテゴリは「テストレポーター」 | E-03 (7行目) | ○ |
| C-27 | module.exportsでreportReruns関数をエクスポート | E-01 (74-77行目) | ○ |
| C-28 | セキュリティ考慮事項（パス露出） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティ考慮事項（パス露出）はコードからの直接的な根拠がなく、一般的なセキュリティベストプラクティスに基づく記述
  - 候補：セキュリティ設計書 / 運用マニュアル / アクセス制御設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書の内容はソースコードと整合している

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のreportReruns関数と設計書の処理フローが一致しているか確認
- [ ] クロージャの動作（previousRuns, globalOptionsの保持）を確認
- [ ] 重複テストIDの処理が正しく動作するか確認
- [ ] writeFileSyncの同期書き込みが適切か確認
- [ ] セキュリティ考慮事項の妥当性を運用観点で検証
