---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：業務要件一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **BR-099 モジュール読み込み機能**：内部実装の詳細が多岐にわたる
  2. **BR-100 動的インポート機能**：ESモジュールローダーの実装詳細が複雑

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/fs.js` - ファイルシステムモジュール（3375行）
- E-02: `lib/net.js` - ネットワークモジュール（2501行）
- E-03: `lib/http.js` - HTTPモジュール（257行）
- E-04: `lib/https.js` - HTTPSモジュール（677行）
- E-05: `lib/http2.js` - HTTP/2モジュール（29行、内部モジュール参照）
- E-06: `lib/crypto.js` - 暗号化モジュール（384行）
- E-07: `lib/child_process.js` - 子プロセスモジュール（1054行）
- E-08: `lib/cluster.js` - クラスタモジュール（30行）
- E-09: `lib/worker_threads.js` - ワーカースレッドモジュール（58行）
- E-10: `lib/stream.js` - ストリームモジュール（152行）
- E-11: `lib/events.js` - イベントモジュール（1217行）
- E-12: `lib/timers.js` - タイマーモジュール
- E-13: `lib/buffer.js` - バッファモジュール（1400行以上）
- E-14: `lib/path.js` - パスモジュール
- E-15: `lib/url.js` - URLモジュール（1025行以上）
- E-16: `lib/os.js` - OSモジュール（100行以上）
- E-17: `lib/util.js` - ユーティリティモジュール（545行）
- E-18: `lib/test.js` - テストモジュール
- E-19: `lib/diagnostics_channel.js` - 診断チャネルモジュール
- E-20: `lib/perf_hooks.js` - パフォーマンスフックモジュール（55行）
- E-21: `lib/inspector.js` - インスペクタモジュール
- E-22: `lib/repl.js` - REPLモジュール
- E-23: `lib/assert.js` - アサーションモジュール
- E-24: `lib/dns.js` - DNSモジュール
- E-25: `lib/_tls_wrap.js` - TLSモジュール
- E-26: `lib/zlib.js` - 圧縮モジュール
- E-27: `lib/vm.js` - VMモジュール
- E-28: `lib/string_decoder.js` - 文字列デコーダモジュール
- E-29: `lib/querystring.js` - クエリ文字列モジュール
- E-30: `lib/readline.js` - ReadLineモジュール
- E-31: `lib/console.js` - コンソールモジュール
- E-32: `README.md` - プロジェクト概要
- E-33: `lib/internal/` - 内部実装ディレクトリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001 ファイル読み書き機能 | E-01 | ○ |
| C-02 | BR-002 ディレクトリ操作機能 | E-01 | ○ |
| C-03 | BR-003 ファイル属性管理機能 | E-01 | ○ |
| C-04 | BR-004 ファイル監視機能 | E-01 | ○ |
| C-05 | BR-005 ストリームI/O機能 | E-01, E-10 | ○ |
| C-06 | BR-006 グロブパターン検索機能 | E-01 | ○ |
| C-07 | BR-007 TCPサーバー機能 | E-02 | ○ |
| C-08 | BR-008 TCPクライアント機能 | E-02 | ○ |
| C-09 | BR-009 IPアドレス検証機能 | E-02 | ○ |
| C-10 | BR-010 接続ブロックリスト機能 | E-02 | ○ |
| C-11 | BR-011 HTTPサーバー機能 | E-03 | ○ |
| C-12 | BR-012 HTTPクライアント機能 | E-03 | ○ |
| C-13 | BR-013 HTTPSサーバー機能 | E-04 | ○ |
| C-14 | BR-014 HTTPSクライアント機能 | E-04 | ○ |
| C-15 | BR-015 HTTP/2サーバー機能 | E-05 | ○ |
| C-16 | BR-016 HTTP/2クライアント機能 | E-05 | ○ |
| C-17 | BR-017 HTTPヘッダー管理機能 | E-03 | ○ |
| C-18 | BR-018 ハッシュ計算機能 | E-06 | ○ |
| C-19 | BR-019 HMAC計算機能 | E-06 | ○ |
| C-20 | BR-020 対称暗号化機能 | E-06 | ○ |
| C-21 | BR-021 非対称暗号化機能 | E-06 | ○ |
| C-22 | BR-022 デジタル署名機能 | E-06 | ○ |
| C-23 | BR-023 鍵生成機能 | E-06 | ○ |
| C-24 | BR-024 乱数生成機能 | E-06 | ○ |
| C-25 | BR-025 鍵導出機能 | E-06 | ○ |
| C-26 | BR-026 Diffie-Hellman鍵交換機能 | E-06 | ○ |
| C-27 | BR-027 X.509証明書処理機能 | E-06 | ○ |
| C-28 | BR-028 子プロセス起動機能 | E-07 | ○ |
| C-29 | BR-029 シェルコマンド実行機能 | E-07 | ○ |
| C-30 | BR-030 Node.jsワーカー起動機能 | E-07 | ○ |
| C-31 | BR-031 クラスタリング機能 | E-08 | ○ |
| C-32 | BR-032 マルチスレッド機能 | E-09 | ○ |
| C-33 | BR-033 スレッド間通信機能 | E-09 | ○ |
| C-34 | BR-034 Readableストリーム機能 | E-10 | ○ |
| C-35 | BR-035 Writableストリーム機能 | E-10 | ○ |
| C-36 | BR-036 Transformストリーム機能 | E-10 | ○ |
| C-37 | BR-037 ストリームパイプライン機能 | E-10 | ○ |
| C-38 | BR-038 ストリーム完了検知機能 | E-10 | ○ |
| C-39 | BR-039 WebStreams対応機能 | E-10 | ○ |
| C-40 | BR-040 イベント発行・購読機能 | E-11 | ○ |
| C-41 | BR-041 イベントリスナー管理機能 | E-11 | ○ |
| C-42 | BR-042 非同期イテレータ対応機能 | E-11 | ○ |
| C-43 | BR-043 遅延実行機能 | E-12 | ○ |
| C-44 | BR-044 定期実行機能 | E-12 | ○ |
| C-45 | BR-045 即時実行機能 | E-12 | ○ |
| C-46 | BR-046 バイナリデータ処理機能 | E-13 | ○ |
| C-47 | BR-047 エンコーディング変換機能 | E-13 | ○ |
| C-48 | BR-048 Blob処理機能 | E-13 | ○ |
| C-49 | BR-049 パス解決機能 | E-14 | ○ |
| C-50 | BR-050 パス解析機能 | E-14 | ○ |
| C-51 | BR-051 URL解析機能 | E-15 | ○ |
| C-52 | BR-052 URLSearchParams処理機能 | E-15 | ○ |
| C-53 | BR-053 ファイルURL変換機能 | E-15 | ○ |
| C-54 | BR-054 システム情報取得機能 | E-16 | ○ |
| C-55 | BR-055 CPU情報取得機能 | E-16 | ○ |
| C-56 | BR-056 メモリ情報取得機能 | E-16 | ○ |
| C-57 | BR-057 ユーザー情報取得機能 | E-16 | ○ |
| C-58 | BR-058 ネットワーク情報取得機能 | E-16 | ○ |
| C-59 | BR-059 オブジェクト検査機能 | E-17 | ○ |
| C-60 | BR-060 Promise化機能 | E-17 | ○ |
| C-61 | BR-061 型検査機能 | E-17 | ○ |
| C-62 | BR-062 非推奨警告機能 | E-17 | ○ |
| C-63 | BR-063 コマンドライン引数解析機能 | E-17 | ○ |
| C-64 | BR-064 テキストエンコード・デコード機能 | E-17 | ○ |
| C-65 | BR-065 テストケース実行機能 | E-18 | ○ |
| C-66 | BR-066 テストライフサイクル管理機能 | E-18 | ○ |
| C-67 | BR-067 モック機能 | E-18 | ○ |
| C-68 | BR-068 スナップショットテスト機能 | E-18 | ○ |
| C-69 | BR-069 テストレポート機能 | E-18 | ○ |
| C-70 | BR-070 診断チャネル機能 | E-19 | ○ |
| C-71 | BR-071 パフォーマンス計測機能 | E-20 | ○ |
| C-72 | BR-072 イベントループ監視機能 | E-20 | ○ |
| C-73 | BR-073 インスペクタ接続機能 | E-21 | ○ |
| C-74 | BR-074 プロファイリング機能 | E-21 | ○ |
| C-75 | BR-075 対話型実行環境機能 | E-22 | ○ |
| C-76 | BR-076 アサーション機能 | E-23 | ○ |
| C-77 | BR-077 DNS解決機能 | E-24 | ○ |
| C-78 | BR-078 逆引きDNS機能 | E-24 | ○ |
| C-79 | BR-079 TLSサーバー機能 | E-25 | ○ |
| C-80 | BR-080 TLSクライアント機能 | E-25 | ○ |
| C-81 | BR-081 証明書管理機能 | E-25 | ○ |
| C-82 | BR-082 圧縮機能 | E-26 | ○ |
| C-83 | BR-083 解凍機能 | E-26 | ○ |
| C-84 | BR-084 Brotli圧縮機能 | E-26 | ○ |
| C-85 | BR-085 サンドボックス実行機能 | E-27 | ○ |
| C-86 | BR-086 コンテキスト管理機能 | E-27 | ○ |
| C-87 | BR-087 文字列デコード機能 | E-28 | ○ |
| C-88 | BR-088 クエリ文字列処理機能 | E-29 | ○ |
| C-89 | BR-089 行単位入力機能 | E-30 | ○ |
| C-90 | BR-090 対話型入力機能 | E-30 | ○ |
| C-91 | BR-091 コンソール出力機能 | E-31 | ○ |
| C-92 | BR-092 構造化ログ機能 | E-31 | ○ |
| C-93 | BR-093 タイマーログ機能 | E-31 | ○ |
| C-94 | BR-094 環境変数アクセス機能 | E-33 | ○ |
| C-95 | BR-095 プロセス終了機能 | E-33 | ○ |
| C-96 | BR-096 シグナルハンドリング機能 | E-33 | ○ |
| C-97 | BR-097 標準入出力アクセス機能 | E-33 | ○ |
| C-98 | BR-098 メモリ使用量取得機能 | E-33 | ○ |
| C-99 | BR-099 モジュール読み込み機能 | E-33 | △ |
| C-100 | BR-100 動的インポート機能 | E-33 | △ |

## 4) 不足情報（Unknown / Missing）
- BR-099/BR-100のモジュールシステムに関する要件は、内部実装が複雑で複数のファイルにまたがるため、詳細な検証が必要
  - 候補：`lib/internal/modules/cjs/loader.js` / `lib/internal/modules/esm/loader.js` / `lib/module.js`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 98件の業務要件は明確なソースコードの根拠あり
- 1: 中リスク - モジュールシステム関連の2件は内部実装が複雑で追加検証推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ファイルシステム関連（BR-001〜BR-006）の機能が`lib/fs.js`の実装と一致しているか確認
- [ ] ネットワーク関連（BR-007〜BR-017）の機能が実際のAPI仕様と一致しているか確認
- [ ] 暗号化関連（BR-018〜BR-027）の機能が最新のcryptoモジュールと一致しているか確認
- [ ] テストランナー（BR-065〜BR-069）の機能が組み込みtest モジュールの実装と一致しているか確認
- [ ] モジュールシステム（BR-099〜BR-100）の詳細な実装を内部モジュールで確認
