---
generated_at: 2026-01-30 16:20:00
metrics:
  claims_total: 46
  claims_with_evidence: 46
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：46 / 46、根拠なし：0
- 優先レビュー（高）
  - すべての機能がソースコードから直接確認されているため、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/fs.js` - ファイルシステムモジュール
- E-02: `lib/http.js` - HTTPモジュール
- E-03: `lib/https.js` - HTTPSモジュール
- E-04: `lib/http2.js` - HTTP/2モジュール
- E-05: `lib/net.js` - ネットワークモジュール
- E-06: `lib/dgram.js` - データグラムソケットモジュール
- E-07: `lib/dns.js` - DNSモジュール
- E-08: `lib/crypto.js` - 暗号化モジュール
- E-09: `lib/tls.js` - TLS/SSLモジュール
- E-10: `lib/buffer.js` - Bufferモジュール
- E-11: `lib/stream.js` - ストリームモジュール
- E-12: `lib/zlib.js` - 圧縮モジュール
- E-13: `lib/string_decoder.js` - 文字列デコーダモジュール
- E-14: `lib/querystring.js` - クエリ文字列モジュール
- E-15: `lib/os.js` - OSモジュール
- E-16: `lib/process.js` - プロセスモジュール
- E-17: `lib/child_process.js` - 子プロセスモジュール
- E-18: `lib/cluster.js` - クラスタモジュール
- E-19: `lib/worker_threads.js` - ワーカースレッドモジュール
- E-20: `lib/util.js` - ユーティリティモジュール
- E-21: `lib/path.js` - パスモジュール
- E-22: `lib/url.js` - URLモジュール
- E-23: `lib/events.js` - イベントモジュール
- E-24: `lib/timers.js` - タイマーモジュール
- E-25: `lib/assert.js` - アサーションモジュール
- E-26: `lib/inspector.js` - インスペクターモジュール
- E-27: `lib/console.js` - コンソールモジュール
- E-28: `lib/perf_hooks.js` - パフォーマンスフックモジュール
- E-29: `lib/trace_events.js` - トレースイベントモジュール
- E-30: `lib/diagnostics_channel.js` - 診断チャンネルモジュール
- E-31: `lib/test.js` - テストランナーモジュール
- E-32: `lib/module.js` - モジュールシステム
- E-33: `lib/vm.js` - 仮想マシンモジュール
- E-34: `lib/repl.js` - REPLモジュール
- E-35: `lib/v8.js` - V8モジュール
- E-36: `lib/async_hooks.js` - 非同期フックモジュール
- E-37: `lib/readline.js` - 行読み取りモジュール
- E-38: `lib/tty.js` - TTYモジュール
- E-39: `lib/domain.js` - ドメインモジュール
- E-40: `lib/punycode.js` - Punycodeモジュール
- E-41: `lib/wasi.js` - WASIモジュール
- E-42: `lib/sqlite.js` - SQLiteモジュール
- E-43: `lib/sea.js` - SEAモジュール
- E-44: `lib/constants.js` - 定数モジュール
- E-45: `lib/quic.js` - QUICモジュール
- E-46: `README.md` - プロジェクト概要

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | fs - ファイルシステム操作API | E-01 | ○ |
| C-02 | fs/promises - Promise版ファイルシステムAPI | E-01 | ○ |
| C-03 | http - HTTPサーバー・クライアント機能 | E-02 | ○ |
| C-04 | https - HTTPSサーバー・クライアント機能 | E-03 | ○ |
| C-05 | http2 - HTTP/2プロトコルサポート | E-04 | ○ |
| C-06 | net - TCP/IPソケット通信機能 | E-05 | ○ |
| C-07 | dgram - UDP/データグラムソケット機能 | E-06 | ○ |
| C-08 | dns - DNS名前解決機能 | E-07 | ○ |
| C-09 | crypto - 暗号化・ハッシュ・署名機能 | E-08 | ○ |
| C-10 | tls - TLS/SSL通信プロトコル機能 | E-09 | ○ |
| C-11 | buffer - バイナリデータ操作用Buffer API | E-10 | ○ |
| C-12 | stream - ストリームAPI | E-11 | ○ |
| C-13 | zlib - 圧縮・解凍機能 | E-12 | ○ |
| C-14 | string_decoder - Bufferから文字列へのデコード | E-13 | ○ |
| C-15 | querystring - URLクエリ文字列のパース | E-14 | ○ |
| C-16 | os - OS関連情報取得API | E-15 | ○ |
| C-17 | process - プロセス情報・制御API | E-16 | ○ |
| C-18 | child_process - 子プロセス生成・管理 | E-17 | ○ |
| C-19 | cluster - マルチプロセスクラスタリング | E-18 | ○ |
| C-20 | worker_threads - マルチスレッドワーカー | E-19 | ○ |
| C-21 | util - ユーティリティ関数群 | E-20 | ○ |
| C-22 | path - ファイルパス操作 | E-21 | ○ |
| C-23 | url - URL解析・構築機能 | E-22 | ○ |
| C-24 | events - イベントエミッター | E-23 | ○ |
| C-25 | timers - タイマー機能 | E-24 | ○ |
| C-26 | assert - テスト用アサーション | E-25 | ○ |
| C-27 | inspector - V8インスペクターデバッグAPI | E-26 | ○ |
| C-28 | console - コンソール出力API | E-27 | ○ |
| C-29 | perf_hooks - パフォーマンス計測API | E-28 | ○ |
| C-30 | trace_events - トレースイベント機能 | E-29 | ○ |
| C-31 | diagnostics_channel - 診断チャンネルAPI | E-30 | ○ |
| C-32 | test - 組み込みテストランナー | E-31 | ○ |
| C-33 | module - モジュールシステムAPI | E-32 | ○ |
| C-34 | vm - JavaScript仮想マシン | E-33 | ○ |
| C-35 | repl - 対話型実行環境 | E-34 | ○ |
| C-36 | v8 - V8エンジン関連API | E-35 | ○ |
| C-37 | async_hooks - 非同期コンテキスト追跡 | E-36 | ○ |
| C-38 | readline - 行単位入力インターフェース | E-37 | ○ |
| C-39 | tty - 端末制御機能 | E-38 | ○ |
| C-40 | domain - エラードメイン管理 | E-39 | ○ |
| C-41 | punycode - PunyCodeエンコード・デコード | E-40 | ○ |
| C-42 | wasi - WebAssembly System Interface | E-41 | ○ |
| C-43 | sqlite - SQLiteデータベース | E-42 | ○ |
| C-44 | sea - シングル実行可能アプリケーション | E-43 | ○ |
| C-45 | constants - 各種定数定義 | E-44 | ○ |
| C-46 | quic - QUICプロトコルサポート | E-45 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての機能がソースコードファイルから直接確認できています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての機能がlibディレクトリのソースコードから直接確認されています
- 注意事項：
  - `domain`モジュールは非推奨（deprecated）です
  - `quic`モジュールは実験的機能です
  - `sqlite`モジュールは比較的新しい機能です

## 6) レビュアーチェックリスト（最小）
- [ ] 各機能のカテゴリ分類が適切か確認
- [ ] 説明文が機能の本質を正確に表現しているか確認
- [ ] 非推奨・実験的機能の備考が適切に記載されているか確認
- [ ] 重要な機能が漏れていないか確認（特にinternalモジュール群）
