---
generated_at: 2026-01-30 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-tls.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/tls.js` - メインtlsモジュール
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tlsモジュールはTLS/SSL通信を提供 | E-01, E-02 | ○ |
| C-02 | CLIENT_RENEG_LIMIT = 3 | E-01 (85行目) | ○ |
| C-03 | CLIENT_RENEG_WINDOW = 600 | E-01 (86行目) | ○ |
| C-04 | DEFAULT_CIPHERS設定 | E-01 (88行目) | ○ |
| C-05 | DEFAULT_ECDH_CURVE = 'auto' | E-01 (90行目) | ○ |
| C-06 | DEFAULT_MIN_VERSION設定（TLSv1.2デフォルト） | E-01 (92-101行目) | ○ |
| C-07 | DEFAULT_MAX_VERSION設定（TLSv1.3デフォルト） | E-01 (103-108行目) | ○ |
| C-08 | getCiphers()関数 | E-01 (111-113行目) | ○ |
| C-09 | rootCertificatesプロパティ | E-01 (122-127行目) | ○ |
| C-10 | cacheBundledRootCertificates()関数 | E-01 (116-120行目) | ○ |
| C-11 | cacheExtraCACertificates()関数 | E-01 (129-134行目) | ○ |
| C-12 | cacheSystemCACertificates()関数 | E-01 (136-141行目) | ○ |
| C-13 | cacheDefaultCACertificates()関数 | E-01 (146-181行目) | ○ |
| C-14 | getCACertificates()関数 | E-01 (184-200行目) | ○ |
| C-15 | setDefaultCACertificates()関数 | E-01 (202-220行目) | ○ |
| C-16 | convertProtocols()関数 | E-01 (246-266行目) | ○ |
| C-17 | convertALPNProtocols()関数 | E-01 (268-281行目) | ○ |
| C-18 | check()関数（ワイルドカードマッチング） | E-01 (297-359行目) | ○ |
| C-19 | splitEscapedAltNames()関数 | E-01 (368-397行目) | ○ |
| C-20 | checkServerIdentity()関数 | E-01 (399-457行目) | ○ |
| C-21 | 内部モジュールエクスポート | E-01 (459-465行目) | ○ |
| C-22 | startLoadingCertificatesOffThread()呼び出し | E-01 (56行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（ソースコードから全主張を確認可能）
- internal/tls/common.js, internal/tls/wrap.jsの詳細は別途確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 公開API定義、TLSバージョン設定
- 0: 低リスク - CA証明書管理（行番号確認済み）
- 0: 低リスク - コードリーディングガイド（行番号確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] コードリーディングガイドの行番号が最新ソースと一致するか確認
- [ ] TLSバージョン設定がセキュリティ要件を満たすか確認
- [ ] checkServerIdentity()の証明書検証ロジックが正確か確認
- [ ] CA証明書の取得優先順位が期待通りか確認
