---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-process.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `lib/internal/process/per_thread.js` 107-117行目 - wrapProcessMethods関数
- E-02: `lib/internal/process/per_thread.js` 127-161行目 - cpuUsage()
- E-03: `lib/internal/process/per_thread.js` 167-205行目 - threadCpuUsage()
- E-04: `lib/internal/process/per_thread.js` 216-225行目 - memoryUsage()
- E-05: `lib/internal/process/per_thread.js` 229-252行目 - exit()
- E-06: `lib/internal/process/per_thread.js` 254-280行目 - kill()
- E-07: `lib/internal/process/per_thread.js` 282-327行目 - execve()
- E-08: `lib/internal/process/per_thread.js` 329-350行目 - resourceUsage()
- E-09: `lib/internal/process/per_thread.js` 356-364行目 - loadEnvFile()
- E-10: `lib/internal/process/per_thread.js` 78-97行目 - hrtime()
- E-11: `lib/internal/process/per_thread.js` 99-102行目 - hrtimeBigInt()
- E-12: `lib/internal/process/per_thread.js` 385-511行目 - buildAllowedFlags()
- E-13: `lib/internal/process/per_thread.js` 68行目 - bindingインポート
- E-14: `lib/internal/process/per_thread.js` 36-46行目 - エラーコードインポート
- E-15: `lib/internal/process/per_thread.js` 60行目 - constants定義
- E-16: `lib/internal/process/per_thread.js` 73-76行目 - hrValuesバッファ
- E-17: `lib/internal/process/per_thread.js` 542-553行目 - module.exports
- E-18: `lib/internal/process/per_thread.js` 526-532行目 - arch/platform/version
- E-19: `lib/internal/process/per_thread.js` 529-540行目 - ref/unref
- E-20: `lib/internal/process/per_thread.js` 517-524行目 - toggleTraceCategoryState
- E-21: `lib/internal/process/per_thread.js` 57-58行目 - diagnostics_channel
- E-22: `lib/internal/process/per_thread.js` 287-291行目 - execveのワーカー制限
- E-23: `lib/internal/process/per_thread.js` 269-273行目 - シグナル定数参照
- E-24: `機能一覧.csv` - 機能No.17 process定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | wrapProcessMethodsでメソッド定義 | E-01 | ○ |
| C-02 | cpuUsage()でCPU使用時間取得 | E-02 | ○ |
| C-03 | threadCpuUsage()でスレッドCPU使用時間取得 | E-03 | ○ |
| C-04 | memoryUsage()でメモリ使用状況取得 | E-04 | ○ |
| C-05 | exit()でプロセス終了 | E-05 | ○ |
| C-06 | kill()でシグナル送信 | E-06 | ○ |
| C-07 | execve()で実行ファイル置換（実験的） | E-07 | ○ |
| C-08 | resourceUsage()でリソース使用状況取得 | E-08 | ○ |
| C-09 | loadEnvFile()で.envファイル読み込み | E-09 | ○ |
| C-10 | hrtime()で高精度時間取得 | E-10 | ○ |
| C-11 | hrtime.bigint()でBigInt版時間取得 | E-11 | ○ |
| C-12 | buildAllowedFlags()で許可フラグセット構築 | E-12 | ○ |
| C-13 | bindingでネイティブ関数取得 | E-13 | ○ |
| C-14 | ERR_INVALID_ARG_TYPE等のエラー対応 | E-14 | ○ |
| C-15 | constants.osからシグナル定数取得 | E-15 | ○ |
| C-16 | hrValuesでバッファ共有 | E-16 | ○ |
| C-17 | 各関数をexport | E-17 | ○ |
| C-18 | arch/platform/versionを提供 | E-18 | ○ |
| C-19 | ref/unref関数を提供 | E-19 | ○ |
| C-20 | トレースカテゴリ切り替え機能 | E-20 | ○ |
| C-21 | diagnostics_channelでexecveイベント発行 | E-21 | ○ |
| C-22 | execveはメインスレッド限定 | E-22 | ○ |
| C-23 | シグナル名からコード変換 | E-23 | ○ |
| C-24 | 機能一覧でNo.17がprocessとして定義 | E-24 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全体として十分な根拠がある
- execveは実験的機能であることに注意

## 6) レビュアーチェックリスト（最小）

- [ ] 主要メソッド（exit/kill/cpuUsage等）の説明が正確か確認
- [ ] hrtime()の差分計算説明が正確か確認
- [ ] イベント一覧が網羅されているか確認
- [ ] エラーケースが網羅されているか確認
