---
generated_at: 2026-01-30 17:40:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-cluster.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `lib/cluster.js` 28-29行目 - NODE_UNIQUE_IDによる振り分け
- E-02: `lib/internal/cluster/primary.js` 32行目 - module.exports = cluster
- E-03: `lib/internal/cluster/primary.js` 35-42行目 - isWorker/isPrimary/workers/settings定義
- E-04: `lib/internal/cluster/primary.js` 29-30行目 - SCHED_NONE/SCHED_RR定数
- E-05: `lib/internal/cluster/primary.js` 48-60行目 - schedulingPolicy決定ロジック
- E-06: `lib/internal/cluster/primary.js` 62-109行目 - setupPrimary()関数
- E-07: `lib/internal/cluster/primary.js` 112行目 - setupMasterエイリアス
- E-08: `lib/internal/cluster/primary.js` 118-140行目 - createWorkerProcess()
- E-09: `lib/internal/cluster/primary.js` 161-217行目 - cluster.fork()
- E-10: `lib/internal/cluster/primary.js` 223-238行目 - cluster.disconnect()
- E-11: `lib/internal/cluster/primary.js` 268-330行目 - queryServer()
- E-12: `lib/internal/cluster/primary.js` 360-366行目 - Worker.prototype.disconnect
- E-13: `lib/internal/cluster/primary.js` 368-371行目 - Worker.prototype.destroy
- E-14: `lib/internal/cluster/child.js` 28行目 - module.exports = cluster
- E-15: `lib/internal/cluster/child.js` 30-34行目 - isWorker/isPrimary定義
- E-16: `lib/internal/cluster/child.js` 36-64行目 - _setupWorker()
- E-17: `lib/internal/cluster/child.js` 67-129行目 - _getServer()
- E-18: `lib/internal/cluster/child.js` 144-159行目 - shared()関数
- E-19: `lib/internal/cluster/child.js` 162-225行目 - rr()関数
- E-20: `lib/internal/cluster/child.js` 228-248行目 - onconnection()
- E-21: `lib/internal/cluster/child.js` 288-295行目 - Worker.prototype.disconnect
- E-22: `lib/internal/cluster/child.js` 297-309行目 - Worker.prototype.destroy
- E-23: `lib/internal/cluster/worker.js` 16-39行目 - Workerコンストラクタ
- E-24: `lib/internal/cluster/worker.js` 44-58行目 - kill/send/isDead/isConnected
- E-25: `lib/internal/cluster/round_robin_handle.js` 17-48行目 - RoundRobinHandleコンストラクタ
- E-26: `機能一覧.csv` - 機能No.19 cluster定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NODE_UNIQUE_IDでプライマリ/ワーカー判定 | E-01 | ○ |
| C-02 | プライマリがclusterモジュールをエクスポート | E-02 | ○ |
| C-03 | isWorker/isPrimary/workers/settingsが定義 | E-03 | ○ |
| C-04 | SCHED_NONE=1、SCHED_RR=2が定義 | E-04 | ○ |
| C-05 | Windowsではデフォルトでラウンドロビン無効 | E-05 | ○ |
| C-06 | setupPrimary()でワーカー設定を行う | E-06 | ○ |
| C-07 | setupMasterは非推奨エイリアス | E-07 | ○ |
| C-08 | createWorkerProcess()でchild_process.fork呼び出し | E-08 | ○ |
| C-09 | cluster.fork()でワーカー生成 | E-09 | ○ |
| C-10 | cluster.disconnect()で全ワーカー切断 | E-10 | ○ |
| C-11 | queryServer()でハンドル処理 | E-11 | ○ |
| C-12 | Worker.disconnect()でワーカー切断（プライマリ側） | E-12 | ○ |
| C-13 | Worker.destroy()でシグナル送信 | E-13 | ○ |
| C-14 | ワーカー側もclusterをエクスポート | E-14 | ○ |
| C-15 | ワーカー側でisWorker=true、isPrimary=false | E-15 | ○ |
| C-16 | _setupWorker()でワーカー初期化 | E-16 | ○ |
| C-17 | _getServer()でサーバーハンドル取得 | E-17 | ○ |
| C-18 | shared()で共有ハンドルモード | E-18 | ○ |
| C-19 | rr()でラウンドロビンモード | E-19 | ○ |
| C-20 | onconnection()で接続受信 | E-20 | ○ |
| C-21 | ワーカー側Worker.disconnect()の実装 | E-21 | ○ |
| C-22 | ワーカー側Worker.destroy()の実装 | E-22 | ○ |
| C-23 | WorkerはEventEmitter継承 | E-23 | ○ |
| C-24 | kill()はdestroy()へのエイリアス | E-24 | ○ |
| C-25 | RoundRobinHandleでラウンドロビン実装 | E-25 | ○ |
| C-26 | 機能一覧でNo.19がclusterとして定義 | E-26 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全体として十分な根拠がある
- shared_handle.jsは読み込んでいないが、round_robin_handle.jsと対になる実装であることは明らか

## 6) レビュアーチェックリスト（最小）

- [ ] プライマリ/ワーカーの判定ロジックが正確か確認
- [ ] スケジューリングポリシーの説明が正確か確認
- [ ] イベント（fork/online/listening/exit等）が網羅されているか確認
- [ ] ワーカー状態遷移（none→online→listening→disconnected→dead）が正確か確認
