---
generated_at: 2026-01-30 17:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-worker_threads.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `lib/worker_threads.js` 35-57行目 - module.exports定義
- E-02: `lib/internal/worker.js` 198-364行目 - Workerクラスconstructor
- E-03: `lib/internal/worker.js` 366-383行目 - kOnExit終了処理
- E-04: `lib/internal/worker.js` 395-423行目 - kOnMessageメッセージ処理
- E-05: `lib/internal/worker.js` 443-447行目 - postMessage()
- E-06: `lib/internal/worker.js` 449-464行目 - terminate()
- E-07: `lib/internal/worker.js` 466-468行目 - SymbolAsyncDispose
- E-08: `lib/internal/worker.js` 470-482行目 - ref/unref
- E-09: `lib/internal/worker.js` 484-494行目 - threadId/threadName getter
- E-10: `lib/internal/worker.js` 496-506行目 - stdin/stdout/stderr getter
- E-11: `lib/internal/worker.js` 508-512行目 - resourceLimits getter
- E-12: `lib/internal/worker.js` 514-527行目 - getHeapSnapshot()
- E-13: `lib/internal/worker.js` 529-538行目 - getHeapStatistics()
- E-14: `lib/internal/worker.js` 540-569行目 - cpuUsage()
- E-15: `lib/internal/worker.js` 572-596行目 - startCpuProfile/startHeapProfile
- E-16: `lib/internal/worker.js` 138-167行目 - CPUProfileHandle
- E-17: `lib/internal/worker.js` 169-196行目 - HeapProfileHandle
- E-18: `lib/internal/worker.js` 120-129行目 - setEnvironmentData/getEnvironmentData
- E-19: `lib/internal/worker.js` 109行目 - environmentData SafeMap
- E-20: `lib/internal/worker.js` 99行目 - SHARE_ENV定義
- E-21: `lib/internal/worker.js` 111-118行目 - cwdCounter/process.chdir上書き
- E-22: `lib/internal/worker.js` 626-640行目 - parseResourceLimits
- E-23: `lib/internal/worker.js` 104-105行目 - diagnostics_channel設定
- E-24: `lib/internal/worker.js` 247-253行目 - パスバリデーション（ERR_WORKER_PATH）
- E-25: `lib/internal/worker.js` 603-611行目 - InternalWorker
- E-26: `lib/internal/worker.js` 74-78行目 - isMainThread/isInternalThread/threadId
- E-27: `lib/worker_threads.js` 33行目 - locksインポート
- E-28: `機能一覧.csv` - 機能No.20 worker_threads定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 各種API（isMainThread等）をexport | E-01 | ○ |
| C-02 | Workerクラスのconstructor | E-02 | ○ |
| C-03 | kOnExitで終了処理 | E-03 | ○ |
| C-04 | kOnMessageでメッセージ受信処理 | E-04 | ○ |
| C-05 | postMessage()でメッセージ送信 | E-05 | ○ |
| C-06 | terminate()でワーカー終了 | E-06 | ○ |
| C-07 | SymbolAsyncDispose実装（using対応） | E-07 | ○ |
| C-08 | ref()/unref()でイベントループ制御 | E-08 | ○ |
| C-09 | threadId/threadName getter | E-09 | ○ |
| C-10 | stdin/stdout/stderr getter | E-10 | ○ |
| C-11 | resourceLimits getter | E-11 | ○ |
| C-12 | getHeapSnapshot()でヒープスナップショット | E-12 | ○ |
| C-13 | getHeapStatistics()でヒープ統計 | E-13 | ○ |
| C-14 | cpuUsage()でCPU使用量取得 | E-14 | ○ |
| C-15 | startCpuProfile/startHeapProfile | E-15 | ○ |
| C-16 | CPUProfileHandleクラス | E-16 | ○ |
| C-17 | HeapProfileHandleクラス | E-17 | ○ |
| C-18 | setEnvironmentData/getEnvironmentData | E-18 | ○ |
| C-19 | environmentDataはSafeMap | E-19 | ○ |
| C-20 | SHARE_ENVで環境変数共有 | E-20 | ○ |
| C-21 | process.chdirをcwdCounterで同期 | E-21 | ○ |
| C-22 | parseResourceLimitsでリソース制限パース | E-22 | ○ |
| C-23 | diagnostics_channelで監視可能 | E-23 | ○ |
| C-24 | 相対パスは./..必須 | E-24 | ○ |
| C-25 | InternalWorkerはPermission Modelバイパス | E-25 | ○ |
| C-26 | isMainThread/isInternalThread/threadIdが定義 | E-26 | ○ |
| C-27 | locksでWeb Locks API | E-27 | ○ |
| C-28 | 機能一覧でNo.20がworker_threadsとして定義 | E-28 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全体として十分な根拠がある
- InternalWorkerがPermission Modelをバイパスする点はセキュリティ上注意

## 6) レビュアーチェックリスト（最小）

- [ ] Worker生成時のオプションが網羅されているか確認
- [ ] メッセージ通信（postMessage/MessagePort）の説明が正確か確認
- [ ] resourceLimitsの各制限値の説明が正確か確認
- [ ] エラーケースが網羅されているか確認
