---
generated_at: 2026-01-30 17:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-events.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **captureRejectionsの動作詳細**：リジェクションハンドリングの確認
  2. **AsyncIteratorのバックプレッシャー**：highWaterMark/lowWaterMarkの挙動確認
  3. **EventEmitterAsyncResource**：async_hooksとの連携確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/events.js` 1-1218行目（全体）
- E-02: `lib/events.js` 208-210行目 EventEmitterコンストラクタ
- E-03: `lib/events.js` 255-257行目 プロトタイププロパティ
- E-04: `lib/events.js` 261行目 defaultMaxListeners = 10
- E-05: `lib/events.js` 455-534行目 emit関数
- E-06: `lib/events.js` 536-591行目 _addListener関数
- E-07: `lib/events.js` 669-721行目 removeListener関数
- E-08: `lib/events.js` 963-1005行目 once静的メソッド
- E-09: `lib/events.js` 1047-1201行目 on静的メソッド
- E-10: `lib/events.js` 865-876行目 arrayClone関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventEmitterは_events、_eventsCount、_maxListenersを持つ | E-03 | ○ |
| C-02 | デフォルト最大リスナー数は10 | E-04 | ○ |
| C-03 | 10を超えるリスナー登録時に警告が出る | E-06 (577-587行目) | ○ |
| C-04 | errorイベントでリスナーがない場合、例外をスロー | E-05 (467-500行目) | ○ |
| C-05 | newListenerイベントがリスナー追加時に発行される | E-06 (550-557行目) | ○ |
| C-06 | removeListenerイベントがリスナー削除時に発行される | E-07 (692-693行目, 716-717行目) | ○ |
| C-07 | onとaddListenerは同じ関数 | E-01 (603行目) | ○ |
| C-08 | offとremoveListenerは同じ関数 | E-01 (723行目) | ○ |
| C-09 | emitはリスナーが存在したかどうかをbooleanで返す | E-05 (505行目, 533行目) | ○ |
| C-10 | once静的メソッドはPromiseを返す | E-08 (969行目) | ○ |
| C-11 | on静的メソッドはAsyncIteratorを返す | E-09 (1070行目) | ○ |
| C-12 | AbortSignal対応がonce/onに含まれる | E-08 (967-968行目), E-09 (1051-1053行目) | ○ |
| C-13 | captureRejectionsでPromiseリジェクションを捕捉 | E-01 (224-235行目), E-05 (513-514行目, 527-528行目) | ○ |
| C-14 | kErrorMonitorでerrorイベントを監視可能 | E-05 (460-461行目) | ○ |
| C-15 | prependListenerはリスナーを先頭に追加する | E-06 (571行目 prepend ? [listener, existing]) | ○ |
| C-16 | eventNamesは登録済みイベント名一覧を返す | E-01 (861-863行目) | ○ |
| C-17 | listenerCountはリスナー数を返す | E-01 (824-854行目) | ○ |
| C-18 | arrayClone関数で配列クローン最適化 | E-10 | ○ |
| C-19 | 単一リスナーは配列を作成せず直接格納 | E-06 (562-563行目) | ○ |
| C-20 | EventEmitterAsyncResourceはasync_hooksと連携 | E-01 (102-201行目 lazyEventEmitterAsyncResource) | ○ |
| C-21 | on静的メソッドはhighWaterMark/lowWaterMark対応 | E-09 (1055-1059行目) | ○ |
| C-22 | kShapeModeで削除時の最適化を行う | E-07 (684-690行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能説明は正確
- 0: 低リスク - API仕様はコードと一致
- 0: 低リスク - パフォーマンス最適化も正確に記述

## 6) レビュアーチェックリスト（最小）
- [ ] captureRejectionsの実際の動作をサンプルコードで確認
- [ ] AsyncIteratorのバックプレッシャー（pause/resume）の動作確認
- [ ] EventEmitterAsyncResourceの使用例を確認
- [ ] EventTargetとの互換性を確認
- [ ] メモリリーク警告の閾値変更方法を確認
