---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-inspector.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **CDPプロトコルの詳細**：Chrome DevTools Protocolの仕様確認
  2. **セキュリティ警告の詳細**：公開IPバインド時の脆弱性理解
  3. **Network/DOMStorageの用途**：実際の使用例確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/inspector.js` 1-253行目（全体）
- E-02: `lib/inspector.js` 54-160行目 Sessionクラス
- E-03: `lib/inspector.js` 169-196行目 inspectorOpen関数
- E-04: `lib/inspector.js` 204-207行目 inspectorWaitForDebugger
- E-05: `lib/inspector.js` 209-213行目 broadcastToFrontend
- E-06: `lib/inspector.js` 215-226行目 Network
- E-07: `lib/inspector.js` 232-240行目 DOMStorage
- E-08: `lib/inspector.js` 242-252行目 module.exports
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | inspector.openはインスペクターを起動する | E-03 | ○ |
| C-02 | inspector.closeはインスペクターを停止する | E-08 (243行目 _debugEnd) | ○ |
| C-03 | inspector.url()はWebSocket接続URLを取得する | E-08 (244行目) | ○ |
| C-04 | inspector.waitForDebugger()はデバッガー接続を待機する | E-04 | ○ |
| C-05 | Sessionクラスは#connection、#nextId、#messageCallbacksを持つ | E-02 (55-57行目) | ○ |
| C-06 | Session.connect()はネイティブConnectionに接続する | E-02 (63-67行目) | ○ |
| C-07 | Session.connectToMainThread()はワーカースレッドでのみ使用可能 | E-02 (75-76行目) | ○ |
| C-08 | Session.post()はCDPメッセージをJSON化して送信する | E-02 (139行目) | ○ |
| C-09 | Session.disconnect()は保留中コールバックにエラー通知する | E-02 (153-157行目) | ○ |
| C-10 | 公開IPにバインド時にSecurityWarningを発行する | E-03 (180-189行目) | ○ |
| C-11 | 既にアクティブな場合ERR_INSPECTOR_ALREADY_ACTIVATED | E-03 (170-172行目) | ○ |
| C-12 | 既に接続済みの場合ERR_INSPECTOR_ALREADY_CONNECTED | E-02 (64-65行目, 77-78行目) | ○ |
| C-13 | 未接続でpostするとERR_INSPECTOR_NOT_CONNECTED | E-02 (128-129行目) | ○ |
| C-14 | Networkはネットワーク関連CDPイベントを送信する | E-06 | ○ |
| C-15 | DOMStorageはストレージ関連CDPイベントを送信する | E-07 | ○ |
| C-16 | broadcastToFrontendはemitProtocolEventを呼び出す | E-05 (212行目) | ○ |
| C-17 | System Analyzerが関連画面として存在する | E-09 | ○ |
| C-18 | Turbolizerが関連画面として存在する | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能説明は正確
- 0: 低リスク - API仕様はコードと一致
- 1: 中リスク - セキュリティ警告の詳細を本番環境で確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Chrome DevTools Protocolの仕様を確認
- [ ] 公開IPバインド時のセキュリティリスクを理解
- [ ] connectToMainThread()のワーカースレッドでの使用例を確認
- [ ] Network/DOMStorageの実際の使用例を確認
- [ ] inspector.consoleの機能を確認
