---
generated_at: 2026-01-30 17:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-perf_hooks.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. **PerformanceObserverの監視モード**：entryTypes/type排他制御の動作確認
  2. **バッファ警告閾値**：100万件での警告メッセージ確認
  3. **timerifyのPromise対応**：async関数の計測動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/perf_hooks.js` 1-55行目（全体）
- E-02: `lib/internal/perf/performance.js` 1-247行目（全体）
- E-03: `lib/internal/perf/observe.js` 1-581行目（全体）
- E-04: `lib/internal/perf/usertiming.js` 1-257行目（全体）
- E-05: `lib/internal/perf/timerify.js` 1-110行目（全体）
- E-06: `lib/perf_hooks.js` 34-47行目 module.exports
- E-07: `lib/internal/perf/performance.js` 51-165行目 Performanceクラス
- E-08: `lib/internal/perf/performance.js` 226-231行目 createPerformance
- E-09: `lib/internal/perf/observe.js` 81-91行目 kSupportedEntryTypes
- E-10: `lib/internal/perf/observe.js` 236-377行目 PerformanceObserverクラス
- E-11: `lib/internal/perf/usertiming.js` 69-109行目 PerformanceMarkクラス
- E-12: `lib/internal/perf/usertiming.js` 167-172行目 mark関数
- E-13: `lib/internal/perf/usertiming.js` 225-237行目 measure関数
- E-14: `lib/internal/perf/timerify.js` 55-107行目 timerify関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | perf_hooks.jsはPerformance、PerformanceObserver等をエクスポートする | E-06 | ○ |
| C-02 | Performanceクラスのコンストラクタは直接呼び出し不可（ERR_ILLEGAL_CONSTRUCTOR） | E-07 (52-54行目) | ○ |
| C-03 | performance.mark()はusertiming.markを呼び出す | E-07 (121-127行目) | ○ |
| C-04 | performance.measure()はusertiming.measureを呼び出す | E-07 (129-135行目) | ○ |
| C-05 | performance.now()はutils.nowを呼び出す | E-07 (137-140行目) | ○ |
| C-06 | performance.getEntries()はfilterBufferMapByNameAndTypeを呼び出す | E-07 (95-98行目) | ○ |
| C-07 | createPerformance()でPerformanceインスタンスを生成する | E-08 | ○ |
| C-08 | サポートされるentryTypesはdns, function, gc, http, http2, mark, measure, net, resource | E-09 | ○ |
| C-09 | PerformanceObserver.observe()はentryTypesとtypeを同時に指定不可 | E-10 (256-260行目) | ○ |
| C-10 | PerformanceObserver.observe()は監視モード変更不可（InvalidModificationError） | E-10 (267-278行目) | ○ |
| C-11 | PerformanceObserver.disconnect()は監視解除とバッファクリアを行う | E-10 (316-323行目) | ○ |
| C-12 | PerformanceObserver.takeRecords()はバッファを返して空にする | E-10 (325-329行目) | ○ |
| C-13 | PerformanceMarkクラスはdetailプロパティを持つ | E-11 (95-98行目) | ○ |
| C-14 | mark()はPerformanceMark作成、enqueue、bufferUserTimingを行う | E-12 | ○ |
| C-15 | measure()はcalculateStartDurationで期間計算を行う | E-13 (227-230行目) | ○ |
| C-16 | nodeTimingReadOnlyAttributesの名前はmark名として使用不可 | E-04 (75-76行目) | ○ |
| C-17 | timerifyはvalidateFunctionで引数検証を行う | E-14 (56行目) | ○ |
| C-18 | timerifyはhistogramオプションでRecordableHistogramに記録可能 | E-14 (63-69行目) | ○ |
| C-19 | timerifiedはPromise.finallyでasync関数の完了を待つ | E-14 (77-86行目) | ○ |
| C-20 | bufferUserTimingは100万件超で警告を発行する | E-03 (98行目, 410-423行目) | ○ |
| C-21 | resourceTimingBufferSizeLimitはデフォルト250 | E-03 (101行目) | ○ |
| C-22 | GC監視時にinstallGarbageCollectionTrackingが呼び出される | E-03 (158-162行目) | ○ |
| C-23 | queuePending()はsetImmediateでコールバックをバッチ処理する | E-03 (115-125行目) | ○ |
| C-24 | PerformanceObserverEntryListはstartTimeでソートされる | E-03 (167-169行目, 177行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能説明は正確
- 0: 低リスク - API仕様はコードと一致
- 1: 中リスク - monitorEventLoopDelayとeventLoopUtilizationの詳細実装確認を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] PerformanceObserverの監視モード切り替え時のエラー動作を確認
- [ ] mark/measureバッファの100万件警告メッセージを確認
- [ ] timerifyのasync関数計測動作を確認
- [ ] resourcetimingbufferfullイベントの発行条件を確認
- [ ] GCトラッキングの有効化/無効化動作を確認
