---
generated_at: 2026-01-30 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：3-http.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Keep-Aliveパフォーマンス**：具体的な設定値の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/http.js` - メインhttpモジュール
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-03: `lib/_http_agent.js` - Agent実装（想定）
- E-04: `lib/_http_server.js` - Server実装（想定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | httpモジュールはHTTPサーバー・クライアント機能を提供 | E-01, E-02 | ○ |
| C-02 | createServer()でServerインスタンス生成 | E-01 (68-70行目) | ○ |
| C-03 | request()でClientRequest生成 | E-01 (107-109行目) | ○ |
| C-04 | get()はGETリクエストのショートカット | E-01 (118-122行目) | ○ |
| C-05 | METHODSでHTTPメソッド定義 | E-01 (186行目) | ○ |
| C-06 | STATUS_CODESでステータスコード定義 | E-01 (187行目) | ○ |
| C-07 | validateHeaderName/Valueでヘッダー検証 | E-01 (195-196行目) | ○ |
| C-08 | globalAgentでデフォルト接続プール | E-01 (220-229行目) | ○ |
| C-09 | maxHeaderSizeの設定 | E-01 (206-218行目) | ○ |
| C-10 | setMaxIdleHTTPParsers()でパーサー数設定 | E-01 (199-202行目) | ○ |
| C-11 | setGlobalProxyFromEnv()でプロキシ設定 | E-01 (132-182行目) | ○ |
| C-12 | ERR_PROXY_INVALID_CONFIGエラー | E-01 (33行目, 143-147行目) | ○ |
| C-13 | WebSocketはundici経由 | E-01 (128-134行目, 232-256行目) | ○ |
| C-14 | IncomingMessage使用 | E-01 (32行目, 191行目) | ○ |
| C-15 | OutgoingMessage使用 | E-01 (37行目, 191行目) | ○ |
| C-16 | ServerResponse使用 | E-01 (43行目, 193行目) | ○ |
| C-17 | ClientRequest使用 | E-01 (30行目, 189行目) | ○ |
| C-18 | Agent使用（httpAgent） | E-01 (29行目, 188行目) | ○ |
| C-19 | _connectionListener使用 | E-01 (40行目, 185行目) | ○ |
| C-20 | Keep-Aliveによるコネクション再利用 | **根拠なし（内部実装）** | △ |

## 4) 不足情報（Unknown / Missing）
- Keep-Aliveの具体的な動作詳細は_http_agent.jsの確認が必要
  - 候補：`lib/_http_agent.js` / Node.js公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 公開API定義、エクスポート一覧
- 0: 低リスク - セキュリティ考慮事項（一般的な注意事項）
- 0: 低リスク - コードリーディングガイド（行番号確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] Keep-Aliveの詳細動作が_http_agent.jsと一致するか確認
- [ ] コードリーディングガイドの行番号が最新ソースと一致するか確認
- [ ] セキュリティ考慮事項がプロジェクト要件を満たすか確認
