---
generated_at: 2026-01-30 17:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-trace_events.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **ワーカースレッド制限**：ownsProcessStateのチェック動作確認
  2. **メモリリーク警告**：10個超時の警告メッセージ確認
  3. **async_hooksベースのトレーシング**：トレースイベントの形式確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/trace_events.js` 1-97行目（全体）
- E-02: `lib/internal/trace_events_async_hooks.js` 1-100行目（全体）
- E-03: `lib/trace_events.js` 8-19行目 モジュール初期化
- E-04: `lib/trace_events.js` 31-81行目 Tracingクラス
- E-05: `lib/trace_events.js` 83-91行目 createTracing関数
- E-06: `lib/trace_events.js` 93-96行目 module.exports
- E-07: `lib/internal/trace_events_async_hooks.js` 38-97行目 createHook関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | hasTracingがfalseの場合ERR_TRACE_EVENTS_UNAVAILABLEをスロー | E-03 (18-19行目) | ○ |
| C-02 | ownsProcessStateがfalseの場合ERR_TRACE_EVENTS_UNAVAILABLEをスロー | E-03 (18-19行目) | ○ |
| C-03 | Tracingクラスは#handle、#categories、#enabledのプライベートフィールドを持つ | E-04 (32-34行目) | ○ |
| C-04 | Tracingコンストラクタは CategorySetネイティブハンドルを生成する | E-04 (37行目) | ○ |
| C-05 | enable()は#enabledをtrueにしてhandle.enable()を呼び出す | E-04 (42-44行目) | ○ |
| C-06 | enable()はenabledTracingObjectsにTracingを追加する | E-04 (45行目) | ○ |
| C-07 | enabledTracingObjectsが10個超でメモリリーク警告を発行する | E-04 (46-51行目), E-01 (10行目 kMaxTracingCount) | ○ |
| C-08 | disable()は#enabledをfalseにしてhandle.disable()を呼び出す | E-04 (56-58行目) | ○ |
| C-09 | disable()はenabledTracingObjectsからTracingを削除する | E-04 (59行目) | ○ |
| C-10 | categoriesゲッターはカンマ区切り文字列を返す | E-04 (68行目) | ○ |
| C-11 | createTracingはvalidateObjectでoptions検証を行う | E-05 (84行目) | ○ |
| C-12 | createTracingはvalidateStringArrayでcategories検証を行う | E-05 (85行目) | ○ |
| C-13 | categories.length <= 0でERR_TRACE_EVENTS_CATEGORY_REQUIREDをスロー | E-05 (87-88行目) | ○ |
| C-14 | module.exportsはcreateTracingとgetEnabledCategoriesをエクスポート | E-06 | ○ |
| C-15 | trace_events_async_hooksのcreateHookはasync_hooks.createHookを使用する | E-07 (43行目) | ○ |
| C-16 | initフックはkBeforeEventでトレースを開始する | E-07 (48行目) | ○ |
| C-17 | destroyフックはkEndEventでトレースを終了しtypeMemoryをクリーンアップする | E-07 (74, 77行目) | ○ |
| C-18 | PromiseはnativeProvidersから除外される | E-02 (36行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能説明は正確
- 0: 低リスク - API仕様はコードと一致
- 1: 中リスク - トレースファイルの出力パスとフォーマットの詳細確認を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ワーカースレッドからの呼び出し時のエラー動作を確認
- [ ] 10個超のTracing有効化時の警告メッセージを確認
- [ ] --trace-event-categoriesコマンドラインオプションとの関係を確認
- [ ] トレースファイル（node_trace.*.log）の出力形式を確認
- [ ] Chrome DevToolsでのトレースファイル読み込みを確認
