---
generated_at: 2026-01-30 10:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：32-test

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **Node.js バージョン情報**：公式ドキュメント参照推奨
  2. **モック機能の詳細**：mock.js の詳細実装確認推奨
  3. **カバレッジ機能**：coverage.js の詳細実装確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/test.js` 1-80行目（モジュール全体）
- E-02: `lib/internal/test_runner/harness.js` 1-417行目（ハーネス全体）
- E-03: `lib/internal/test_runner/runner.js` 1-200行目（ランナー一部）
- E-04: `lib/test.js` 8行目（harness インポート）
- E-05: `lib/test.js` 9行目（runner インポート）
- E-06: `lib/test.js` 11-22行目（module.exports）
- E-07: `lib/test.js` 26-38行目（mock 遅延ロード）
- E-08: `lib/test.js` 43-62行目（snapshot 遅延ロード）
- E-09: `lib/internal/test_runner/harness.js` 43-113行目（createTestTree）
- E-10: `lib/internal/test_runner/harness.js` 361-392行目（runInParentContext）
- E-11: `lib/internal/test_runner/harness.js` 394-405行目（hook関数）
- E-12: `lib/internal/test_runner/harness.js` 407-416行目（module.exports）
- E-13: `lib/internal/test_runner/runner.js` 120-138行目（createTestFileList）
- E-14: `lib/internal/test_runner/harness.js` 229-308行目（setupProcessState）
- E-15: `lib/internal/test_runner/harness.js` 166-182行目（configureCoverage）
- E-16: ファイル存在確認: `lib/internal/test_runner/mock/mock.js`
- E-17: ファイル存在確認: `lib/internal/test_runner/snapshot.js`
- E-18: ファイル存在確認: `lib/internal/test_runner/reporter/spec.js`
- E-19: ファイル存在確認: `lib/internal/test_runner/reporter/tap.js`
- E-20: ファイル存在確認: `lib/internal/test_runner/reporter/junit.js`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 組み込みテストランナーを提供 | E-01, E-02 | ○ |
| C-02 | test() / it() でテストケース定義可能 | E-06, E-10 | ○ |
| C-03 | describe() / suite() でテストスイート定義可能 | E-06, E-12 | ○ |
| C-04 | before/after/beforeEach/afterEach フック提供 | E-06, E-11, E-12 | ○ |
| C-05 | モック機能を提供 | E-07, E-16 | ○ |
| C-06 | スナップショットテスト機能を提供 | E-08, E-17 | ○ |
| C-07 | コードカバレッジ計測機能を提供 | E-15 | ○ |
| C-08 | TAP形式レポーターを提供 | E-19 | ○ |
| C-09 | spec形式レポーターを提供 | E-18 | ○ |
| C-10 | junit形式レポーターを提供 | E-20 | ○ |
| C-11 | createTestTree でテストツリーを構築 | E-09 | ○ |
| C-12 | Glob パターンでテストファイル検出 | E-13 | ○ |
| C-13 | uncaughtException ハンドラを設定 | E-14 (297行目) | ○ |
| C-14 | unhandledRejection ハンドラを設定 | E-14 (298行目) | ○ |
| C-15 | skip オプションでテストスキップ可能 | E-10 (380行目 skip キーワード) | ○ |
| C-16 | only オプションで特定テストのみ実行可能 | E-10 (380行目 only キーワード) | ○ |
| C-17 | todo オプションでTODOマーク可能 | E-10 (380行目 todo キーワード) | ○ |
| C-18 | timeout オプションでタイムアウト設定可能 | E-03 (189行目) | ○ |
| C-19 | concurrency で並行実行数を制御可能 | E-09 (harness.config) | ○ |
| C-20 | async_hooks を使用してテストコンテキスト追跡 | E-02 (13-15行目, 230-247行目) | ○ |
| C-21 | runInParentContext で親コンテキストからテスト作成 | E-10 | ○ |
| C-22 | lazyBootstrapRoot でルートテストを遅延初期化 | E-02 (310-334行目) | ○ |
| C-23 | harness オブジェクトでカウンタ管理 | E-09 (57-68行目) | ○ |
| C-24 | startSubtestAfterBootstrap でサブテスト開始 | E-02 (336-359行目) | ○ |
| C-25 | getCallerLocation でテスト位置情報取得 | E-02 (11行目, 375行目) | ○ |
| C-26 | node --test でテストファイル直接実行可能 | E-03 (kFilterArgs に '--test' 含む) | ○ |
| C-27 | Node.js 18で実験的導入、20で安定版 | **根拠なし** | △ |
| C-28 | ERR_TEST_FAILURE エラーコードを使用 | E-02 (19行目), E-03 (48行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- Node.js のバージョン情報（18で実験的、20で安定版）は公式ドキュメントを参照する必要がある
  - 候補：Node.js公式ドキュメント / CHANGELOGファイル / GitHubリリースノート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア実装に関する記述はすべてソースコードで確認可能
- 1: 中リスク - バージョン履歴に関する記述は外部ドキュメント参照必要

## 6) レビュアーチェックリスト（最小）
- [ ] test() と describe() の実行フローが正しいか確認
- [ ] フック（before/after等）の実行順序が正しいか確認
- [ ] モック機能（MockTracker）の詳細実装を確認
- [ ] カバレッジ機能（V8 Coverage API連携）の詳細を確認
- [ ] 各レポーター（TAP/spec/junit）の出力フォーマットを確認
