---
generated_at: 2026-01-30 10:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：34-vm

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティに関する警告**：公式ドキュメント参照推奨
  2. **--experimental-vm-modules**：実験的機能の詳細確認推奨
  3. **cachedData互換性**：V8バージョン依存の詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/vm.js` 1-420行目（モジュール全体）
- E-02: `lib/vm.js` 33-37行目（internalBinding）
- E-03: `lib/vm.js` 78-82行目（isContext）
- E-04: `lib/vm.js` 84-130行目（Script コンストラクタ）
- E-05: `lib/vm.js` 132-155行目（runInThisContext/runInContext/runInNewContext）
- E-06: `lib/vm.js` 158-163行目（validateContext）
- E-07: `lib/vm.js` 165-194行目（getRunInContextArgs）
- E-08: `lib/vm.js` 225-266行目（createContext）
- E-09: `lib/vm.js` 290-302行目（runInContext関数）
- E-10: `lib/vm.js` 304-311行目（runInNewContext関数）
- E-11: `lib/vm.js` 313-318行目（runInThisContext関数）
- E-12: `lib/vm.js` 320-370行目（compileFunction）
- E-13: `lib/vm.js` 382-394行目（measureMemory）
- E-14: `lib/vm.js` 396-402行目（vmConstants）
- E-15: `lib/vm.js` 404-415行目（module.exports）
- E-16: `lib/vm.js` 417-419行目（ESMサポートコメント）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | V8仮想マシンのコンテキストを利用 | E-02 | ○ |
| C-02 | JavaScriptコードを分離された環境で実行 | E-08, E-09 | ○ |
| C-03 | Scriptクラスでコードをコンパイル | E-04 | ○ |
| C-04 | createContext()でコンテキスト作成 | E-08 | ○ |
| C-05 | runInThisContext()で現在コンテキスト実行 | E-05, E-11 | ○ |
| C-06 | runInContext()で指定コンテキスト実行 | E-05, E-09 | ○ |
| C-07 | runInNewContext()で新規コンテキスト実行 | E-05, E-10 | ○ |
| C-08 | compileFunction()で関数コンパイル | E-12 | ○ |
| C-09 | measureMemory()でメモリ計測 | E-13 | ○ |
| C-10 | filenameオプションでスタックトレース用名前指定 | E-04 (94行目) | ○ |
| C-11 | lineOffsetオプションで行番号オフセット指定 | E-04 (95行目) | ○ |
| C-12 | columnOffsetオプションで列番号オフセット指定 | E-04 (96行目) | ○ |
| C-13 | timeoutオプションでタイムアウト制御 | E-07 (168-173行目) | ○ |
| C-14 | cachedDataオプションでキャッシュ使用 | E-04 (97, 106-108行目) | ○ |
| C-15 | produceCachedDataでキャッシュ生成 | E-04 (98, 109行目) | ○ |
| C-16 | breakOnSigintでSIGINT割り込み対応 | E-07 (177行目) | ○ |
| C-17 | ERR_INVALID_ARG_TYPEエラー発生 | E-01 (39-41行目 require) | ○ |
| C-18 | ERR_CONTEXT_NOT_INITIALIZEDエラー発生 | E-01 (39行目), E-13 (391行目) | ○ |
| C-19 | isContext()でコンテキスト判定 | E-03 | ○ |
| C-20 | validateContext()でコンテキスト検証 | E-06 | ○ |
| C-21 | USE_MAIN_CONTEXT_DEFAULT_LOADER定数存在 | E-14 (398行目) | ○ |
| C-22 | DONT_CONTEXTIFY定数存在 | E-14 (399行目) | ○ |
| C-23 | Script は ContextifyScript を継承 | E-04 (84行目) | ○ |
| C-24 | codeGeneration オプションでeval/wasm制御 | E-08 (243-252行目) | ○ |
| C-25 | microtaskMode オプション対応 | E-08 (254-257行目) | ○ |
| C-26 | measureMemory は実験的機能 | E-13 (383行目 emitExperimentalWarning) | ○ |
| C-27 | vmはセキュリティメカニズムではない | **根拠なし** | △ |
| C-28 | --experimental-vm-modulesでESMサポート | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- vmモジュールがセキュリティメカニズムではないという警告は、公式ドキュメントに記載されているが、ソースコード内には明示的な記述がない
  - 候補：Node.js公式ドキュメント / セキュリティガイドライン / GitHubイシュー

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API構造と実装はソースコードで確認可能
- 2: 高リスク - セキュリティに関する警告は公式ドキュメントの確認が必須

## 6) レビュアーチェックリスト（最小）
- [ ] Script クラスの V8 連携（ContextifyScript）の動作確認
- [ ] createContext の詳細オプション（codeGeneration等）の効果確認
- [ ] timeout による実行中断の動作確認
- [ ] cachedData の互換性条件（V8バージョン依存）の確認
- [ ] セキュリティ警告について公式ドキュメントを確認
