---
generated_at: 2026-01-30 11:30:00
metrics:
  claims_total: 27
  claims_with_evidence: 26
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：37-async_hooks

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：26 / 27、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンスオーバーヘッド**：定量的なベンチマーク根拠なし
  2. **AsyncLocalStorageの実装選択**：条件の詳細確認推奨
  3. **destroyタイミング**：GC依存の詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/async_hooks.js` 1-297行目（モジュール全体）
- E-02: `lib/async_hooks.js` 31行目（internal_async_hooks インポート）
- E-03: `lib/async_hooks.js` 39-59行目（内部関数取得）
- E-04: `lib/async_hooks.js` 62-72行目（シンボル・定数取得）
- E-05: `lib/async_hooks.js` 75-166行目（AsyncHook クラス）
- E-06: `lib/async_hooks.js` 169-171行目（createHook 関数）
- E-07: `lib/async_hooks.js` 179-278行目（AsyncResource クラス）
- E-08: `lib/async_hooks.js` 282-296行目（module.exports）
- E-09: `lib/async_hooks.js` 284-288行目（AsyncLocalStorage getter）
- E-10: `lib/async_hooks.js` 76-89行目（AsyncHookコンストラクタ検証）
- E-11: `lib/async_hooks.js` 108-141行目（enable メソッド）
- E-12: `lib/async_hooks.js` 143-165行目（disable メソッド）
- E-13: `lib/async_hooks.js` 179-217行目（AsyncResourceコンストラクタ）
- E-14: `lib/async_hooks.js` 219-232行目（runInAsyncScope）
- E-15: `lib/async_hooks.js` 234-240行目（emitDestroy）
- E-16: `lib/async_hooks.js` 250-277行目（bind メソッド）
- E-17: `lib/async_hooks.js` 17-23行目（エラーコードインポート）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 非同期リソースのライフサイクルをトラッキング | E-01, E-05 | ○ |
| C-02 | init/before/after/destroy/promiseResolveコールバック | E-05, E-10 | ○ |
| C-03 | AsyncLocalStorageでコンテキスト伝搬 | E-09 | ○ |
| C-04 | createHook()でフック作成 | E-06 | ○ |
| C-05 | enable()/disable()でフック制御 | E-11, E-12 | ○ |
| C-06 | executionAsyncId()で実行コンテキスト取得 | E-03, E-08 (290行目) | ○ |
| C-07 | triggerAsyncId()でトリガーID取得 | E-03, E-08 (291行目) | ○ |
| C-08 | AsyncResourceでカスタムリソース作成 | E-07, E-08 (295行目) | ○ |
| C-09 | executionAsyncResource()でリソースアクセス | E-03, E-08 (292行目) | ○ |
| C-10 | ERR_ASYNC_CALLBACKエラー発生 | E-10 (77-86行目), E-17 | ○ |
| C-11 | ERR_ASYNC_TYPEエラー発生 | E-13 (204-206行目), E-17 | ○ |
| C-12 | ERR_INVALID_ASYNC_IDエラー発生 | E-13 (193-194行目), E-17 | ○ |
| C-13 | asyncIdは一意の識別子 | E-03 (51行目 newAsyncId) | ○ |
| C-14 | フック順序: init→before→after→destroy | E-04 (定数 kInit, kBefore, kAfter, kDestroy) | ○ |
| C-15 | triggerAsyncIdで親子関係追跡 | E-07 (201行目) | ○ |
| C-16 | destroyはGCに依存 | E-07 (211-216行目 registerDestroyHook) | ○ |
| C-17 | trackPromisesオプションで制御可能 | E-05 (87-105行目) | ○ |
| C-18 | runInAsyncScope()でスコープ内実行 | E-14 | ○ |
| C-19 | emitDestroy()で破棄イベント発火 | E-15 | ○ |
| C-20 | bind()で関数をリソースにバインド | E-16 | ○ |
| C-21 | 静的bind()メソッドが存在 | E-16 (274-277行目) | ○ |
| C-22 | asyncWrapProvidersをエクスポート | E-08 (293行目) | ○ |
| C-23 | AsyncContextFrame.enabledで実装選択 | E-09 (285-287行目) | ○ |
| C-24 | getHookArrays()でフック配列取得 | E-11 (113行目) | ○ |
| C-25 | enableHooks()/disableHooks()でネイティブ制御 | E-03 (46-47行目), E-11 (133行目), E-12 (161行目) | ○ |
| C-26 | contextFrameSymbolでコンテキスト保存 | E-07 (197行目) | ○ |
| C-27 | パフォーマンスオーバーヘッドが生じる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンスオーバーヘッドについては一般的な知識に基づく記述であり、具体的なベンチマークデータはソースコード内に存在しない
  - 候補：Node.jsパフォーマンスベンチマーク / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどの機能はソースコードで確認可能
- 1: 中リスク - パフォーマンス影響は外部ベンチマーク参照必要

## 6) レビュアーチェックリスト（最小）
- [ ] AsyncHookのコールバック呼び出しタイミングを確認
- [ ] AsyncResourceの使用方法とライフサイクルを確認
- [ ] AsyncLocalStorageの2つの実装の違いを確認
- [ ] trackPromisesオプションの効果を確認
- [ ] destroyフックのGC依存性の影響を確認
