---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：39-tty

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **SIGWINCHシグナル**：シグナル処理の詳細確認推奨
  2. **色深度判定ロジック**：internal/tty.js の確認推奨
  3. **ネイティブバインディング**：tty_wrap.cc の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/tty.js` 1-169行目（モジュール全体）
- E-02: `lib/tty.js` 29行目（net インポート）
- E-03: `lib/tty.js` 30行目（internalBinding('tty_wrap')）
- E-04: `lib/tty.js` 39-41行目（internal/tty インポート）
- E-05: `lib/tty.js` 46-49行目（isatty 関数）
- E-06: `lib/tty.js` 51-72行目（ReadStream コンストラクタ）
- E-07: `lib/tty.js` 74-75行目（ReadStream 継承）
- E-08: `lib/tty.js` 77-86行目（setRawMode）
- E-09: `lib/tty.js` 88-119行目（WriteStream コンストラクタ）
- E-10: `lib/tty.js` 121-122行目（WriteStream 継承）
- E-11: `lib/tty.js` 124行目（isTTY = true）
- E-12: `lib/tty.js` 126行目（getColorDepth）
- E-13: `lib/tty.js` 128行目（hasColors）
- E-14: `lib/tty.js` 130-145行目（_refreshSize）
- E-15: `lib/tty.js` 148-166行目（カーソル制御）
- E-16: `lib/tty.js` 164-166行目（getWindowSize）
- E-17: `lib/tty.js` 168行目（module.exports）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TTY判定機能を提供 | E-05 | ○ |
| C-02 | ReadStreamで端末入力 | E-06, E-17 | ○ |
| C-03 | WriteStreamで端末出力 | E-09, E-17 | ○ |
| C-04 | setRawMode()でRawモード設定 | E-08 | ○ |
| C-05 | getWindowSize()でサイズ取得 | E-16 | ○ |
| C-06 | columns/rowsプロパティでサイズ取得 | E-09 (116-117行目) | ○ |
| C-07 | getColorDepth()で色深度取得 | E-12 | ○ |
| C-08 | hasColors()で色サポート判定 | E-13 | ○ |
| C-09 | fdは0以上2147483647以下 | E-05 (47行目) | ○ |
| C-10 | ReadStreamはnet.Socket継承 | E-07 | ○ |
| C-11 | WriteStreamはnet.Socket継承 | E-10 | ○ |
| C-12 | ERR_INVALID_FDエラー | E-06 (54-55行目), E-09 (91-92行目) | ○ |
| C-13 | ERR_TTY_INIT_FAILEDエラー | E-06 (59-61行目), E-09 (96-98行目) | ○ |
| C-14 | TTYネイティブバインディング使用 | E-03 | ○ |
| C-15 | ReadStream.isRaw初期値false | E-06 (70行目) | ○ |
| C-16 | ReadStream.isTTY = true | E-06 (71行目) | ○ |
| C-17 | WriteStream.isTTY = true | E-11 | ○ |
| C-18 | WriteStreamでsetBlocking(true) | E-09 (111行目) | ○ |
| C-19 | _refreshSizeでサイズ更新 | E-14 | ○ |
| C-20 | resizeイベント発火 | E-14 (143行目) | ○ |
| C-21 | cursorTo/moveCursor/clearLine提供 | E-15 | ○ |
| C-22 | readlineを遅延ロード | E-15 (149行目等) | ○ |
| C-23 | internal/ttyから関数インポート | E-04 | ○ |
| C-24 | SIGWINCHでサイズ変更検知 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SIGWINCHシグナルによるウィンドウサイズ変更検知については、lib/tty.js内に直接的な記述がなく、プロセスレベルまたはネイティブ実装を参照する必要がある
  - 候補：src/tty_wrap.cc / process関連コード / Node.js公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能はソースコードで確認可能
- 1: 中リスク - シグナル処理とネイティブ実装の詳細は別途確認必要

## 6) レビュアーチェックリスト（最小）
- [ ] isatty()のfd有効範囲を確認
- [ ] setRawMode()の動作とエラー処理を確認
- [ ] getColorDepth()の判定ロジック（internal/tty.js）を確認
- [ ] _refreshSize()とresizeイベントの関係を確認
- [ ] ネイティブTTYハンドルの初期化処理を確認
