---
generated_at: 2026-01-30 12:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：40-domain

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンスオーバーヘッド**：async_hooks使用によるオーバーヘッドの定量的根拠なし
  2. **非推奨の代替案**：AsyncLocalStorage推奨の詳細確認推奨
  3. **VMモジュールとの連携**：サンドボックスエスケープ防止の詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/domain.js` 1-557行目（モジュール全体）
- E-02: `lib/domain.js` 24-27行目（非推奨警告コメント）
- E-03: `lib/domain.js` 47行目（EventEmitter インポート）
- E-04: `lib/domain.js` 48-52行目（エラーコードインポート）
- E-05: `lib/domain.js` 53行目（createHook インポート）
- E-06: `lib/domain.js` 62-71行目（process.domain 定義）
- E-07: `lib/domain.js` 75-120行目（asyncHook 定義）
- E-08: `lib/domain.js` 124-126行目（ERR_DOMAIN_CALLBACK_NOT_AVAILABLE）
- E-09: `lib/domain.js` 133-137行目（setUncaughtExceptionCaptureCallback 禁止）
- E-10: `lib/domain.js` 170行目（スタック定義）
- E-11: `lib/domain.js` 214-225行目（Domain コンストラクタ）
- E-12: `lib/domain.js` 229-231行目（create/createDomain）
- E-13: `lib/domain.js` 234行目（exports.active）
- E-14: `lib/domain.js` 238-317行目（_errorHandler）
- E-15: `lib/domain.js` 320-326行目（enter メソッド）
- E-16: `lib/domain.js` 329-340行目（exit メソッド）
- E-17: `lib/domain.js` 344-376行目（add メソッド）
- E-18: `lib/domain.js` 379-384行目（remove メソッド）
- E-19: `lib/domain.js` 387-393行目（run メソッド）
- E-20: `lib/domain.js` 396-417行目（intercepted 関数）
- E-21: `lib/domain.js` 420-428行目（intercept メソッド）
- E-22: `lib/domain.js` 431-437行目（bound 関数）
- E-23: `lib/domain.js` 440-456行目（bind メソッド）
- E-24: `lib/domain.js` 459行目（EventEmitter.usingDomains）
- E-25: `lib/domain.js` 462-475行目（EventEmitter.init 拡張）
- E-26: `lib/domain.js` 478-556行目（EventEmitter.emit 拡張）
- E-27: `lib/domain.js` 82-95行目（VM Promise 処理）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 非同期操作のエラーを一元管理 | E-01, E-14 | ○ |
| C-02 | モジュールは非推奨 | E-02 | ○ |
| C-03 | create()でDomain作成 | E-12 | ○ |
| C-04 | enter()/exit()でドメイン進入・退出 | E-15, E-16 | ○ |
| C-05 | add()/remove()でEventEmitter管理 | E-17, E-18 | ○ |
| C-06 | run()でドメイン内実行 | E-19 | ○ |
| C-07 | bind()でコールバックバインド | E-23 | ○ |
| C-08 | intercept()でエラーファーストコールバック | E-20, E-21 | ○ |
| C-09 | errorイベントでエラー処理 | E-14 (273-283行目) | ○ |
| C-10 | EventEmitter継承 | E-11 (214-216行目) | ○ |
| C-11 | membersでEventEmitter管理 | E-11 (218行目), E-17 (375行目) | ○ |
| C-12 | スタック構造でドメイン管理 | E-10, E-15, E-16 | ○ |
| C-13 | process.domainでアクティブドメイン参照 | E-06 | ○ |
| C-14 | exports.activeでアクティブドメイン参照 | E-13 | ○ |
| C-15 | async_hooksでコンテキスト伝搬 | E-05, E-07 | ○ |
| C-16 | ERR_DOMAIN_CALLBACK_NOT_AVAILABLEエラー | E-04, E-08 | ○ |
| C-17 | ERR_DOMAIN_CANNOT_SET_UNCAUGHT_EXCEPTION_CAPTUREエラー | E-04, E-09 | ○ |
| C-18 | domainThrown プロパティ設定 | E-14 (249行目) | ○ |
| C-19 | 循環参照防止 | E-17 (362-366行目) | ○ |
| C-20 | WeakReferenceでメモリ管理 | E-11 (219行目) | ○ |
| C-21 | EventEmitter.usingDomains = true | E-24 | ○ |
| C-22 | EventEmitter.init拡張 | E-25 | ○ |
| C-23 | EventEmitter.emit拡張 | E-26 | ○ |
| C-24 | VMのPromiseにはdomainプロパティなし | E-27 | ○ |
| C-25 | vmPromises WeakMapで管理 | E-07 (73行目), E-27 (94行目) | ○ |
| C-26 | DEP0097 MakeCallback非推奨警告 | E-01 (141-152行目) | ○ |
| C-27 | updateExceptionCaptureでuncaughtException制御 | E-01 (174-184行目) | ○ |
| C-28 | async_hooksによるパフォーマンスオーバーヘッド | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンスオーバーヘッドについては一般的な知識に基づく記述であり、具体的なベンチマークデータはソースコード内に存在しない
  - 候補：Node.jsパフォーマンスベンチマーク / 公式ドキュメント / async_hooks ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどの機能はソースコードで確認可能
- 1: 中リスク - 非推奨モジュールのため、新規採用時は代替案を検討必要
- 2: 要注意 - VMモジュールとの連携におけるセキュリティ考慮は詳細確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Domain クラスのライフサイクル（create → enter → run → exit）を確認
- [ ] _errorHandler のエラー伝搬メカニズムを確認
- [ ] asyncHook による非同期コンテキスト追跡を確認
- [ ] EventEmitter の init/emit 拡張の影響を確認
- [ ] VM Promise のサンドボックスエスケープ防止を確認
- [ ] 非推奨の代替案（AsyncLocalStorage）への移行パスを確認
