---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：41-punycode

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **IDNホモグラフ攻撃への対策は呼び出し側の責任**：セキュリティ観点の一般的見解であり、コード内に明示的根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/punycode.js` 6-12行目（非推奨警告DEP0040）
- E-02: `lib/punycode.js` 16-26行目（Bootstringパラメータ定義）
- E-03: `lib/punycode.js` 29-31行目（正規表現定義）
- E-04: `lib/punycode.js` 34-38行目（エラーメッセージ定義）
- E-05: `lib/punycode.js` 113-135行目（ucs2decode関数）
- E-06: `lib/punycode.js` 145行目（ucs2encode関数）
- E-07: `lib/punycode.js` 208-293行目（decode関数）
- E-08: `lib/punycode.js` 302-388行目（encode関数）
- E-09: `lib/punycode.js` 401-407行目（toUnicode関数）
- E-10: `lib/punycode.js` 420-426行目（toASCII関数）
- E-11: `lib/punycode.js` 84-98行目（mapDomain関数）
- E-12: `lib/punycode.js` 430-455行目（module.exports）
- E-13: `lib/punycode.js` 437行目（バージョン'2.1.0'）
- E-14: RFC 3492（Punycode仕様、外部参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Punycodeは国際化ドメイン名をACEに変換する | E-14 | ○ |
| C-02 | RFC 3492で定義されている | E-14 | ○ |
| C-03 | 非推奨警告DEP0040が発行される | E-01 | ○ |
| C-04 | node_modules内からの使用時は警告抑制 | E-01 | ○ |
| C-05 | encode関数はUnicode→Punycodeに変換 | E-08 | ○ |
| C-06 | decode関数はPunycode→Unicodeに変換 | E-07 | ○ |
| C-07 | toASCIIはドメイン全体をASCII形式に変換 | E-10, E-11 | ○ |
| C-08 | toUnicodeはドメイン全体をUnicode形式に変換 | E-09, E-11 | ○ |
| C-09 | 基底は36（a-z, 0-9） | E-02 | ○ |
| C-10 | 初期バイアスは72 | E-02 | ○ |
| C-11 | 初期nは128 | E-02 | ○ |
| C-12 | デリミタは'-' | E-02 | ○ |
| C-13 | xn--プレフィックスでPunycodeラベルを識別 | E-03, E-09, E-10 | ○ |
| C-14 | overflow/not-basic/invalid-inputエラー | E-04 | ○ |
| C-15 | バージョンは2.1.0 | E-13 | ○ |
| C-16 | ucs2.encode/decodeユーティリティを提供 | E-05, E-06, E-12 | ○ |
| C-17 | RFC 3490セパレータを認識 | E-03 | ○ |
| C-18 | IDNホモグラフ攻撃対策は呼び出し側責任 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18のセキュリティに関する主張はコード内に明示的な記載がない
  - 候補：Node.js公式ドキュメント / セキュリティガイドライン / RFC 5892

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能設計書の技術的正確性は高い
- 1: 中リスク - セキュリティ考慮事項の一部は一般的知識に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] Bootstringパラメータがコードと一致しているか確認
- [ ] 非推奨警告の条件（isInsideNodeModules）が正しく記載されているか確認
- [ ] エラーケースが網羅されているか確認
- [ ] セキュリティ考慮事項の妥当性を評価
