---
generated_at: 2026-01-30 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：42-wasi

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/wasi.js` 29-33行目（Symbol定義）
- E-02: `lib/wasi.js` 35行目（emitExperimentalWarning）
- E-03: `lib/wasi.js` 38-110行目（コンストラクタ）
- E-04: `lib/wasi.js` 42-57行目（version処理）
- E-05: `lib/wasi.js` 59-61行目（args処理）
- E-06: `lib/wasi.js` 63-72行目（env処理）
- E-07: `lib/wasi.js` 74-82行目（preopens処理）
- E-08: `lib/wasi.js` 84-88行目（stdin/stdout/stderr処理）
- E-09: `lib/wasi.js` 96-102行目（returnOnExit処理）
- E-10: `lib/wasi.js` 112-126行目（finalizeBindings）
- E-11: `lib/wasi.js` 129-146行目（start）
- E-12: `lib/wasi.js` 149-159行目（initialize）
- E-13: `lib/wasi.js` 161-163行目（getImportObject）
- E-14: `lib/wasi.js` 166行目（module.exports）
- E-15: `lib/wasi.js` 169-176行目（wasiReturnOnProcExit）
- E-16: `src/node_wasi.cc` 1-13行目（インクルード・uvwasi使用）
- E-17: `src/node_wasi.cc` 79-93行目（WASIコンストラクタ）
- E-18: `lib/internal/errors.js`（ERR_WASI_ALREADY_STARTED定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WASIは実験的機能で警告が発行される | E-02 | ○ |
| C-02 | versionは'unstable'か'preview1'のみ有効 | E-04 | ○ |
| C-03 | unstableはwasi_unstableバインディング名 | E-04 | ○ |
| C-04 | preview1はwasi_snapshot_preview1バインディング名 | E-04 | ○ |
| C-05 | argsオプションは配列で検証される | E-05 | ○ |
| C-06 | envオプションはオブジェクトで検証される | E-06 | ○ |
| C-07 | preopensオプションはオブジェクトで検証される | E-07 | ○ |
| C-08 | stdin/stdout/stderrのデフォルトは0/1/2 | E-08 | ○ |
| C-09 | returnOnExitのデフォルトはtrue | E-09 | ○ |
| C-10 | kStartedフラグで2回目の開始を防止 | E-10 | ○ |
| C-11 | start()は_startを呼び出す | E-11 | ○ |
| C-12 | start()は_initializeが存在しないことを検証 | E-11 | ○ |
| C-13 | initialize()は_startが存在しないことを検証 | E-12 | ○ |
| C-14 | getImportObject()はkBindingNameをキーとして返す | E-13 | ○ |
| C-15 | wasiReturnOnProcExitは終了コードを保存してスロー | E-15 | ○ |
| C-16 | C++側でuvwasiを使用 | E-16, E-17 | ○ |
| C-17 | ERR_WASI_ALREADY_STARTEDエラーが定義されている | E-18 | ○ |
| C-18 | WASIクラスのみがエクスポートされる | E-14 | ○ |
| C-19 | finalizeBindingsでメモリを設定 | E-10 | ○ |
| C-20 | 各メソッドはthisにバインドされる | E-03 (92-94行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能設計書の技術的正確性は高い
- 実験的機能のため、将来のAPI変更可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] versionオプションの検証ロジックが正しく記載されているか確認
- [ ] start/initializeの排他的実行条件が正しいか確認
- [ ] returnOnExitの動作説明が正確か確認
- [ ] C++バインディングとの連携が正しく説明されているか確認
