---
generated_at: 2026-01-30 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：44-sea

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/sea.js` 1-4行目（primordials import）
- E-02: `lib/sea.js` 6行目（internalBinding('sea')からのインポート）
- E-03: `lib/sea.js` 7行目（TextDecoder import）
- E-04: `lib/sea.js` 8行目（validateString import）
- E-05: `lib/sea.js` 9-12行目（エラーコード import）
- E-06: `lib/sea.js` 13行目（Blob import）
- E-07: `lib/sea.js` 23-35行目（getRawAsset関数）
- E-08: `lib/sea.js` 46-56行目（getAsset関数）
- E-09: `lib/sea.js` 66-69行目（getAssetAsBlob関数）
- E-10: `lib/sea.js` 76-82行目（getAssetKeys関数）
- E-11: `lib/sea.js` 84-90行目（module.exports）
- E-12: `lib/sea.js` 15-21行目（JSDocコメント）
- E-13: `lib/sea.js` 37-44行目（JSDocコメント）
- E-14: `lib/sea.js` 58-64行目（JSDocコメント）
- E-15: `lib/sea.js` 71-74行目（JSDocコメント）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | isSea()はC++バインディングから直接取得 | E-02, E-11 | ○ |
| C-02 | getRawAssetは変更不可のArrayBufferを返す | E-07, E-12 | ○ |
| C-03 | getRawAssetはSEA環境でなければエラー | E-07 (26-28行目) | ○ |
| C-04 | getRawAssetはアセット未検出でエラー | E-07 (31-33行目) | ○ |
| C-05 | getAssetはencoding指定時にTextDecoderを使用 | E-08 (54-55行目), E-03 | ○ |
| C-06 | getAssetはencoding未指定時にArrayBufferコピーを返す | E-08 (51-52行目), E-01 | ○ |
| C-07 | getAssetAsBlobはBlobにラップして返す | E-09, E-06 | ○ |
| C-08 | getAssetKeysはSEA環境でなければエラー | E-10 (77-79行目) | ○ |
| C-09 | getAssetKeysは文字列配列を返す | E-10 (81行目), E-15 | ○ |
| C-10 | ERR_NOT_IN_SINGLE_EXECUTABLE_APPLICATIONエラー | E-05, E-07, E-10 | ○ |
| C-11 | ERR_SINGLE_EXECUTABLE_APPLICATION_ASSET_NOT_FOUNDエラー | E-05, E-07 | ○ |
| C-12 | keyはvalidateStringでバリデーション | E-04, E-07, E-08 | ○ |
| C-13 | encodingはvalidateStringでバリデーション | E-04, E-08 (47-49行目) | ○ |
| C-14 | isSea, getAsset, getRawAsset, getAssetAsBlob, getAssetKeysがエクスポート | E-11 | ○ |
| C-15 | ArrayBufferPrototypeSliceでコピー作成 | E-01, E-08 (52行目) | ○ |
| C-16 | getAssetKeysは空配列のフォールバックあり | E-10 (81行目) | ○ |
| C-17 | getAssetAsBlobはoptionsをBlobに渡す | E-09 (68行目) | ○ |
| C-18 | getAssetInternalとgetAssetKeysInternalはC++バインディング | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能設計書の技術的正確性は高い
- コードが明確で、すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] getRawAssetの「変更するとクラッシュ」の警告がJSDocと一致しているか確認
- [ ] エラーコードの定義が実際のinternal/errorsと一致しているか確認
- [ ] getAssetのArrayBufferコピー処理が正しく説明されているか確認
- [ ] C++バインディング（internalBinding('sea')）の実装を必要に応じて確認
