---
generated_at: 2026-01-30 10:55:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-net.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/net.js` - メインnetモジュール
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | netモジュールはTCP/IPソケット通信を提供 | E-01, E-02 | ○ |
| C-02 | SocketはDuplexストリームを継承 | E-01 (516-517行目) | ○ |
| C-03 | ServerはEventEmitterを継承 | E-01 (1823-1824行目) | ○ |
| C-04 | createServer()でServerインスタンス生成 | E-01 (218-220行目) | ○ |
| C-05 | connect()でSocket接続 | E-01 (235-246行目) | ○ |
| C-06 | Socket関数（コンストラクタ） | E-01 (362-515行目) | ○ |
| C-07 | Server関数（コンストラクタ） | E-01 (1763-1824行目) | ○ |
| C-08 | createServerHandle()でハンドル生成 | E-01 (1830-1886行目) | ○ |
| C-09 | setupListenHandle()で待受設定 | E-01 (1888-1971行目) | ○ |
| C-10 | onconnection()で接続受付 | E-01 (2235-2308行目) | ○ |
| C-11 | Socket.prototype.connect()実装 | E-01 (1222-1288行目) | ○ |
| C-12 | lookupAndConnect()でDNS解決 | E-01 (1310-1440行目) | ○ |
| C-13 | internalConnect()で接続処理 | E-01 (1046-1115行目) | ○ |
| C-14 | afterConnect()で接続完了 | E-01 (1590-1650行目) | ○ |
| C-15 | internalConnectMultiple()でautoSelectFamily | E-01 (1118-1220行目) | ○ |
| C-16 | Server.prototype.listen()実装 | E-01 (2038-2160行目) | ○ |
| C-17 | デフォルトバックログ511 | E-01 (1937行目) | ○ |
| C-18 | IPv6優先バインド | E-01 (1866-1872行目) | ○ |
| C-19 | autoSelectFamilyデフォルト有効 | E-01 (143行目) | ○ |
| C-20 | BlockList対応 | E-01 (509-514行目, 1816-1821行目) | ○ |
| C-21 | diagnostics_channelチャネル | E-01 (156-159行目) | ○ |
| C-22 | isIP, isIPv4, isIPv6エクスポート | E-01 (2491-2493行目) | ○ |
| C-23 | モジュールエクスポート | E-01 (2477-2501行目) | ○ |
| C-24 | tcp_wrap, pipe_wrapバインディング使用 | E-01 (69-78行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（ソースコードから全主張を確認可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 公開API定義、クラス継承関係
- 0: 低リスク - 処理フロー（行番号確認済み）
- 0: 低リスク - コードリーディングガイド（行番号確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] コードリーディングガイドの行番号が最新ソースと一致するか確認
- [ ] クラスター環境での動作が期待通りか確認
- [ ] BlockList機能のセキュリティ要件確認
