---
generated_at: 2026-01-30 11:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-dgram.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/dgram.js` - メインdgramモジュール
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | dgramモジュールはUDPデータグラムソケットを提供 | E-01, E-02 | ○ |
| C-02 | SocketはEventEmitterを継承 | E-01 (186-187行目) | ○ |
| C-03 | createSocket()でSocketインスタンス生成 | E-01 (190-192行目) | ○ |
| C-04 | Socket関数（コンストラクタ） | E-01 (108-185行目) | ○ |
| C-05 | BIND_STATE定数定義 | E-01 (87-89行目) | ○ |
| C-06 | CONNECT_STATE定数定義 | E-01 (91-93行目) | ○ |
| C-07 | Socket.prototype.bind()実装 | E-01 (267-410行目) | ○ |
| C-08 | Socket.prototype.send()実装 | E-01 (615-714行目) | ○ |
| C-09 | startListening()で受信開始 | E-01 (195-211行目) | ○ |
| C-10 | doSend()で送信実行 | E-01 (716-766行目) | ○ |
| C-11 | afterSend()で送信完了コールバック | E-01 (768-776行目) | ○ |
| C-12 | onMessage()でメッセージ受信 | E-01 (981-992行目) | ○ |
| C-13 | setBroadcast()でブロードキャスト設定 | E-01 (843-848行目) | ○ |
| C-14 | setMulticastTTL()でマルチキャストTTL設定 | E-01 (863-872行目) | ○ |
| C-15 | addMembership()でマルチキャストグループ参加 | E-01 (895-908行目) | ○ |
| C-16 | dropMembership()でマルチキャストグループ脱退 | E-01 (911-924行目) | ○ |
| C-17 | addSourceSpecificMembership()でSSM参加 | E-01 (926-941行目) | ○ |
| C-18 | receiveBlockList/sendBlockListサポート | E-01 (129-140行目, 163-164行目) | ○ |
| C-19 | diagnostics_channelでudp.socketチャネル | E-01 (84-85行目, 180-184行目) | ○ |
| C-20 | udp_wrapバインディング使用 | E-01 (78-82行目) | ○ |
| C-21 | モジュールエクスポート | E-01 (1056-1059行目) | ○ |
| C-22 | reusePort時にexclusive=true | E-01 (377-380行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（ソースコードから全主張を確認可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 公開API定義、状態定数
- 0: 低リスク - マルチキャスト処理（行番号確認済み）
- 0: 低リスク - コードリーディングガイド（行番号確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] コードリーディングガイドの行番号が最新ソースと一致するか確認
- [ ] BlockList機能のセキュリティ要件確認
- [ ] マルチキャスト/ブロードキャスト設定がネットワーク環境に適合するか確認
