---
generated_at: 2026-01-30 11:10:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-crypto.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/crypto.js` - メインcryptoモジュール
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cryptoモジュールは暗号化・ハッシュ・署名機能を提供 | E-01, E-02 | ○ |
| C-02 | assertCrypto()で利用可能チェック | E-01 (36行目) | ○ |
| C-03 | createHash()関数 | E-01 (144-146行目) | ○ |
| C-04 | createCipheriv(), createDecipheriv()関数 | E-01 (148-154行目) | ○ |
| C-05 | createHmac(), createSign(), createVerify()関数 | E-01 (168-178行目) | ○ |
| C-06 | internal/crypto/randomインポート | E-01 (49-59行目) | ○ |
| C-07 | internal/crypto/argon2インポート | E-01 (61-63行目) | ○ |
| C-08 | internal/crypto/pbkdf2インポート | E-01 (64-67行目) | ○ |
| C-09 | internal/crypto/scryptインポート | E-01 (68-71行目) | ○ |
| C-10 | internal/crypto/hkdfインポート | E-01 (72-75行目) | ○ |
| C-11 | internal/crypto/keygenインポート | E-01 (76-81行目) | ○ |
| C-12 | internal/crypto/keysインポート | E-01 (82-87行目) | ○ |
| C-13 | internal/crypto/diffiehellmanインポート | E-01 (88-93行目) | ○ |
| C-14 | internal/crypto/cipherインポート | E-01 (94-102行目) | ○ |
| C-15 | internal/crypto/sigインポート | E-01 (103-108行目) | ○ |
| C-16 | internal/crypto/hashインポート | E-01 (109-113行目) | ○ |
| C-17 | internal/crypto/x509インポート | E-01 (114-116行目) | ○ |
| C-18 | getFips(), setFips()実装 | E-01 (251-265行目) | ○ |
| C-19 | lazyWebCrypto()遅延ロード | E-01 (130-134行目) | ○ |
| C-20 | webcrypto, subtleプロパティ | E-01 (355-369行目) | ○ |
| C-21 | getRandomValuesプロパティ | E-01 (371-377行目) | ○ |
| C-22 | Hash/Hmac非推奨警告 | E-01 (242-243行目) | ○ |
| C-23 | モジュールエクスポート | E-01 (180-249行目) | ○ |
| C-24 | constants定義 | E-01 (42行目, 348-353行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（ソースコードから全主張を確認可能）
- 各internal/crypto/*の詳細実装は別途確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 公開API定義、内部モジュール構成
- 0: 低リスク - FIPS関連処理（行番号確認済み）
- 0: 低リスク - コードリーディングガイド（行番号確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] コードリーディングガイドの行番号が最新ソースと一致するか確認
- [ ] internal/crypto/*の各モジュール実装を確認
- [ ] 非推奨API（DEP0093, DEP0115, DEP0179, DEP0181）の使用状況確認
- [ ] セキュリティ考慮事項がプロジェクト要件を満たすか確認
