---
generated_at: 2026-01-30 16:30:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `deps/v8/tools/index.html` - V8 Tools Landing Page
- E-02: `deps/v8/tools/system-analyzer/index.html` - System Analyzer
- E-03: `deps/v8/tools/profview/index.html` - Profview
- E-04: `deps/v8/tools/turbolizer/index.html` - Turbolizer
- E-05: `deps/v8/tools/turbolizer/info-view.html` - Turbolizer Info View
- E-06: `deps/v8/tools/heap-stats/index.html` - Heap Statistics
- E-07: `deps/v8/tools/heap-layout/index.html` - Heap Layout
- E-08: `deps/v8/tools/zone-stats/index.html` - Zone Statistics
- E-09: `deps/v8/tools/callstats.html` - Callstats
- E-10: `deps/v8/tools/parse-processor.html` - Parse Processor
- E-11: `README.md` - プロジェクト概要（Node.jsランタイム）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | V8 Tools Landing Pageが存在し、各ツールへのリンクを提供 | E-01 | ○ |
| C-02 | System AnalyzerはMaps/ICsの分析ツール | E-02 | ○ |
| C-03 | ProfviewはV8プロファイリングログビジュアライザー | E-03 | ○ |
| C-04 | TurbolizerはTurboFanのSea of Nodesグラフ可視化ツール | E-04 | ○ |
| C-05 | Turbolizer Info Viewはキーボードショートカットヘルプ | E-05 | ○ |
| C-06 | Heap Statisticsはヒープメモリ使用状況ビジュアライザー | E-06 | ○ |
| C-07 | Heap Layoutはヒープレイアウト可視化ツール | E-07 | ○ |
| C-08 | Zone StatisticsはZoneメモリ統計ツール | E-08 | ○ |
| C-09 | Callstatsはランタイムコール統計ビジュアライザー | E-09 | ○ |
| C-10 | Parse Processorはパース・コンパイル分析ツール | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全ての画面についてHTMLファイルが存在し、titleタグや説明文から機能を特定できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク
  - プロジェクトはNode.jsランタイムであり、エンドユーザー向けUIアプリケーションではない
  - 検出された画面は全てV8エンジン開発者向けのデバッグ/分析ツール
  - テストフィクスチャ内のHTMLファイルは画面一覧から除外（テスト用のため）

## 6) レビュアーチェックリスト（最小）
- [ ] V8 Toolsの画面一覧が網羅的かどうか確認
- [ ] deps/v8/tools/配下に他に重要なツール画面がないか確認
- [ ] 画面遷移図がLanding Pageからの遷移関係を正しく表現しているか確認
- [ ] このプロジェクトにエンドユーザー向けUI画面が本当に存在しないことを確認
