# 画面遷移図

## 概要

このプロジェクト（Node.js）は、JavaScriptランタイム環境のソースコードリポジトリです。エンドユーザー向けのUIアプリケーションではありませんが、V8エンジン（JavaScriptエンジン）の開発・デバッグ用のWebベースのツール群が含まれています。

## V8 Tools 画面遷移図

```mermaid
flowchart TB
    subgraph V8_Tools["V8 開発ツール群"]
        Landing["V8 Tools Landing Page<br/>(deps/v8/tools/index.html)"]

        subgraph Analyzer["解析ツール"]
            SystemAnalyzer["System Analyzer<br/>(Maps/ICs分析)"]
            Profview["Profview<br/>(プロファイリング)"]
            ParseProcessor["Parse Processor<br/>(パース分析)"]
        end

        subgraph Compiler["コンパイラツール"]
            Turbolizer["Turbolizer<br/>(TurboFanグラフ可視化)"]
            TurbolizerInfo["Turbolizer Info View<br/>(ヘルプ)"]
        end

        subgraph Memory["メモリ分析ツール"]
            HeapStats["Heap Statistics<br/>(ヒープ統計)"]
            HeapLayout["Heap Layout<br/>(ヒープレイアウト)"]
            ZoneStats["Zone Statistics<br/>(Zone統計)"]
        end

        subgraph Performance["パフォーマンスツール"]
            Callstats["Callstats<br/>(コール統計)"]
        end
    end

    Landing -->|"リンク"| SystemAnalyzer
    Landing -->|"リンク"| Profview
    Landing -->|"リンク"| ParseProcessor
    Landing -->|"リンク"| Turbolizer
    Landing -->|"リンク"| HeapStats
    Landing -->|"リンク"| HeapLayout
    Landing -->|"リンク"| ZoneStats
    Landing -->|"リンク"| Callstats

    Turbolizer -.->|"内部ビュー"| TurbolizerInfo

    style Landing fill:#4a90d9,stroke:#333,stroke-width:2px,color:#fff
    style SystemAnalyzer fill:#5da5da,stroke:#333,color:#fff
    style Profview fill:#5da5da,stroke:#333,color:#fff
    style ParseProcessor fill:#5da5da,stroke:#333,color:#fff
    style Turbolizer fill:#faa43a,stroke:#333,color:#fff
    style TurbolizerInfo fill:#faa43a,stroke:#333,color:#fff
    style HeapStats fill:#60bd68,stroke:#333,color:#fff
    style HeapLayout fill:#60bd68,stroke:#333,color:#fff
    style ZoneStats fill:#60bd68,stroke:#333,color:#fff
    style Callstats fill:#f15854,stroke:#333,color:#fff
```

## 画面遷移詳細

### 1. V8 Tools Landing Page (エントリポイント)

| 遷移元 | 遷移先 | トリガー | 説明 |
|--------|--------|----------|------|
| - | V8 Tools Landing Page | URL直接アクセス | ツール群のポータルページ |

### 2. Landing Page からの遷移

| 遷移元 | 遷移先 | トリガー | 説明 |
|--------|--------|----------|------|
| Landing Page | System Analyzer | リンククリック | Maps/ICs分析ツールへ遷移 |
| Landing Page | Callstats | リンククリック | コール統計ツールへ遷移 |
| Landing Page | Heap Stats | リンククリック | ヒープ統計ツールへ遷移 |
| Landing Page | Heap Layout | リンククリック | ヒープレイアウトツールへ遷移 |
| Landing Page | Parse Processor | リンククリック | パース分析ツールへ遷移 |
| Landing Page | Profview | リンククリック | プロファイリングツールへ遷移 |
| Landing Page | Turbolizer | リンククリック | TurboFanグラフ可視化ツールへ遷移 |
| Landing Page | Zone Stats | リンククリック | Zoneメモリ統計ツールへ遷移 |

### 3. Turbolizer 内部遷移

| 遷移元 | 遷移先 | トリガー | 説明 |
|--------|--------|----------|------|
| Turbolizer | Info View | ヘルプ表示 | キーボードショートカット情報の表示 |

## 注意事項

- これらのツールは全てスタンドアロンのWebアプリケーションとして動作します
- 各ツールは独立しており、ファイル（v8.log、trace.jsonなど）のアップロードによってデータを読み込みます
- ツール間でのデータ共有や状態の引き継ぎはありません
- 各ツールはブラウザで直接HTMLファイルを開くか、ローカルサーバーで提供して使用します
