---
generated_at: 2026-01-30 15:30:00
metrics:
  claims_total: 26
  claims_with_evidence: 22
  claims_without_evidence: 4
confidence_derived: 0.85
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：22 / 26、根拠なし：4
- 優先レビュー（高）
  1. **inspector機能との関連**：直接的なコード参照がない推定に基づく
  2. **fs機能との関連**：ブラウザ側File APIであり、Node.js fsモジュールとは異なる
  3. **trace_events機能との関連**：V8トレースイベントはNode.js trace_eventsと異なる可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `deps/v8/tools/index.html`
- E-04: `deps/v8/tools/system-analyzer/index.html`
- E-05: `deps/v8/tools/profview/index.html`
- E-06: `deps/v8/tools/turbolizer/index.html`
- E-07: `deps/v8/tools/turbolizer/info-view.html`
- E-08: `deps/v8/tools/heap-stats/index.html`
- E-09: `deps/v8/tools/heap-layout/index.html`
- E-10: `deps/v8/tools/zone-stats/index.html`
- E-11: `deps/v8/tools/callstats.html`
- E-12: `deps/v8/tools/parse-processor.html`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.1「V8 Tools Landing Page」はv8機能（機能No.36）と関連（主機能） | E-03 | ○ |
| C-02 | 画面No.2「System Analyzer」はv8機能（機能No.36）と関連（主機能） | E-04 | ○ |
| C-03 | 画面No.2「System Analyzer」はinspector機能（機能No.27）と関連（補助機能） | E-04 | △ |
| C-04 | 画面No.2「System Analyzer」はperf_hooks機能（機能No.29）と関連（補助機能） | E-04 | ○ |
| C-05 | 画面No.2「System Analyzer」はtrace_events機能（機能No.30）と関連（補助機能） | E-04 | △ |
| C-06 | 画面No.3「Profview」はv8機能（機能No.36）と関連（主機能） | E-05 | ○ |
| C-07 | 画面No.3「Profview」はperf_hooks機能（機能No.29）と関連（補助機能） | E-05 | ○ |
| C-08 | 画面No.3「Profview」はfs機能（機能No.1）と関連（補助機能） | E-05 | △ |
| C-09 | 画面No.4「Turbolizer」はv8機能（機能No.36）と関連（主機能） | E-06 | ○ |
| C-10 | 画面No.4「Turbolizer」はinspector機能（機能No.27）と関連（補助機能） | E-06 | △ |
| C-11 | 画面No.4「Turbolizer」はfs機能（機能No.1）と関連（補助機能） | E-06 | ○ |
| C-12 | 画面No.5「Turbolizer Info View」はv8機能（機能No.36）と関連（補助機能） | E-07 | ○ |
| C-13 | 画面No.6「Heap Statistics」はv8機能（機能No.36）と関連（主機能） | E-08 | ○ |
| C-14 | 画面No.6「Heap Statistics」はperf_hooks機能（機能No.29）と関連（補助機能） | E-08 | ○ |
| C-15 | 画面No.6「Heap Statistics」はfs機能（機能No.1）と関連（補助機能） | E-08 | ○ |
| C-16 | 画面No.7「Heap Layout」はv8機能（機能No.36）と関連（主機能） | E-09 | ○ |
| C-17 | 画面No.7「Heap Layout」はperf_hooks機能（機能No.29）と関連（補助機能） | E-09 | ○ |
| C-18 | 画面No.7「Heap Layout」はfs機能（機能No.1）と関連（補助機能） | E-09 | ○ |
| C-19 | 画面No.8「Zone Statistics」はv8機能（機能No.36）と関連（主機能） | E-10 | ○ |
| C-20 | 画面No.8「Zone Statistics」はperf_hooks機能（機能No.29）と関連（補助機能） | E-10 | ○ |
| C-21 | 画面No.8「Zone Statistics」はfs機能（機能No.1）と関連（補助機能） | E-10 | ○ |
| C-22 | 画面No.9「Callstats」はv8機能（機能No.36）と関連（主機能） | E-11 | ○ |
| C-23 | 画面No.9「Callstats」はperf_hooks機能（機能No.29）と関連（補助機能） | E-11 | ○ |
| C-24 | 画面No.10「Parse Processor」はv8機能（機能No.36）と関連（主機能） | E-12 | ○ |
| C-25 | 画面No.10「Parse Processor」はperf_hooks機能（機能No.29）と関連（補助機能） | E-12 | ○ |
| C-26 | 画面No.10「Parse Processor」はfs機能（機能No.1）と関連（補助機能） | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- **inspector機能との直接的な関連の根拠**：System Analyzer、TurbolizerでV8デバッグ情報を扱うことは確認できるが、Node.jsのinspectorモジュールを直接利用しているかは不明
  - 候補：V8 Inspector Protocol / Chrome DevTools Protocol / Node.js inspector API
- **trace_events機能との関連の根拠**：V8のトレースイベントとNode.jsのtrace_eventsモジュールの関係が不明確
  - 候補：V8 Trace Events / Node.js trace_events API / Chrome Tracing
- **fs機能の解釈**：これらのツールはブラウザ上で動作するため、File APIを使用しており、Node.jsのfsモジュールではない可能性が高い
  - 候補：Browser File API / Node.js fs module / ファイル読み込み概念としてのマッピング

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**：V8 Toolsは主にブラウザ上で動作するWebアプリケーションであり、Node.jsのサーバーサイドAPIとの直接的な関連は限定的
- **0（低リスク）**：v8機能（機能No.36）との関連は全画面で明確
- **1（中リスク）**：機能一覧にあるNode.jsコアモジュールの多くは、これらのV8 Tools画面では使用されていない

## 6) レビュアーチェックリスト（最小）
- [ ] 各画面の主機能が正しくv8（機能No.36）にマッピングされているか確認
- [ ] 補助機能として挙げたinspector、perf_hooks、trace_events、fsの関連が妥当か確認
- [ ] ブラウザFile APIとNode.js fsモジュールの区別が必要か判断
- [ ] 追加すべき機能関連（例：stream、buffer等）がないか確認
- [ ] 関連種別（主機能/補助機能/遷移先機能/API連携）の分類が適切か確認
