# 画面設計書 1-V8 Tools Landing Page

## 概要

本ドキュメントは、V8 Tools Landing Pageの画面設計について記述する。V8 Tools Landing PageはV8エンジン開発ツール群のポータルページとして、各種V8デバッグ・分析ツールへのナビゲーションを提供するエントリポイント画面である。

### 本画面の処理概要

**業務上の目的・背景**：V8エンジンは複数の開発・デバッグ・分析ツールを提供しており、開発者がこれらのツールに効率的にアクセスするための統一されたエントリポイントが必要である。本画面は、System Analyzer、Profview、Turbolizer、Heap Stats、Zone Statsなど8つの主要なV8開発ツールへの集約的なナビゲーションを提供し、開発者の生産性向上を支援する。

**画面へのアクセス方法**：ブラウザでHTMLファイル（deps/v8/tools/index.html）を直接開くか、ローカルWebサーバー経由でアクセスする。v8.devのToolsセクションからもアクセス可能である。

**主要な操作・処理内容**：
1. 各ツールカードをクリックして、対応するツール画面に遷移する
2. ヘッダーナビゲーションからTools Versions、V8 Main Pageにアクセスする
3. フッターからGitHubリポジトリにアクセスする

**画面遷移**：
- 遷移先：System Analyzer、Callstats、Heap Stats、Heap Layout、Parse Processor、Profview、Turbolizer、Zone Stats
- 遷移元：v8.devメインページ、直接URL入力

**権限による表示制御**：本画面は認証・権限制御を持たない静的HTMLページである。全てのユーザーが同一のコンテンツを閲覧できる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | v8 | 主機能 | V8エンジン関連ツール群へのナビゲーションを提供するポータルページ |

## 画面種別

ポータル / ナビゲーション（一覧リンク）

## URL/ルーティング

```
/deps/v8/tools/index.html
```

または

```
https://v8.dev/tools/
```

## 入出力項目

本画面は静的HTMLページのため、ユーザー入力項目はなし。

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| - | - | - | - | - |

## 表示項目

### ヘッダー領域

| 項目名 | 型 | 説明 |
|--------|-----|------|
| V8ロゴ | リンク | v8.devへのリンク |
| Toolsリンク | リンク | 現在のページ（アクティブ状態） |
| Tools Versionsリンク | リンク | ツールバージョン一覧ページへのリンク |
| Main Pageリンク | リンク | v8.devメインページへのリンク |

### ツールカードグリッド

| 項目名 | 型 | 説明 |
|--------|-----|------|
| System Analyzerカード | カード | Maps/ICsのトレース・デバッグ・分析ツールへのリンク |
| Callstatsカード | カード | ランタイムコール統計のビジュアライズ・比較ツールへのリンク |
| Heap Statsカード | カード | ヒープメモリ使用状況のビジュアライズツールへのリンク |
| Heap Layoutカード | カード | ヒープメモリレイアウトのビジュアライズツールへのリンク |
| Parse Processorカード | カード | パース・コンパイル・初回実行分析ツールへのリンク |
| Profviewカード | カード | サンプリングプロファイルビューワーへのリンク |
| Turbolizerカード | カード | TurboFanグラフ可視化ツールへのリンク |
| Zone Statsカード | カード | Zoneメモリ使用量分析ツールへのリンク |

### フッター領域

| 項目名 | 型 | 説明 |
|--------|-----|------|
| GitHubリンク | リンク | ツールのソースコードリポジトリへのリンク |

## イベント仕様

### 1-ツールカードクリック

各ツールカード（dt要素内のaタグ）をクリックすると、対応するツール画面に遷移する。

| カード名 | 遷移先URL |
|---------|-----------|
| System Analyzer | ./system-analyzer/index.html |
| Callstats | ./callstats.html |
| Heap Stats | ./heap-stats/index.html |
| Heap Layout | ./heap-layout/index.html |
| Parse Processor | ./parse-processor.html |
| Profview | ./profview/index.html |
| Turbolizer | ./turbolizer/index.html |
| Zone Stats | ./zone-stats/index.html |

### 2-ヘッダーナビゲーションクリック

| 項目 | 遷移先 |
|-----|--------|
| V8ロゴ | //v8.dev |
| Tools | 現在のページ（リロード） |
| Tools Versions | //v8.dev/tools/versions |
| Main Page | //v8.dev |

## データベース更新仕様

本画面は静的HTMLページのため、データベース操作はなし。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

本画面はメッセージ表示機能を持たない。

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| - | - | - | - |

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| ファイルが見つからない | ブラウザの404エラー表示 |
| CSSファイル読み込み失敗 | スタイルなしで表示される |

## 備考

- 本画面はダークテーマ（class="js dark"）で設計されている
- CSSは外部v8.devサイトのスタイルシート（//v8.dev/_css/main.css）に依存している
- グリッドレイアウト（3列）を使用してツールカードを配置している
- ホバー時にカードにシャドウエフェクトが適用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: HTMLファイル構造を理解する

本画面は単一の静的HTMLファイルで構成されており、外部リソースは主にCSSのみである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | index.html | `deps/v8/tools/index.html` | HTML構造、グリッドレイアウト、リンク先の理解 |

**読解のコツ**: 本ファイルは純粋なHTMLであり、JavaScriptは含まれない。グリッドレイアウトのCSSクラス（grid-container、card）に注目すること。

#### Step 2: レイアウト構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `deps/v8/tools/index.html` | インラインCSS（lines 12-40）でのスタイル定義 |

**主要処理フロー**:
1. **Line 5**: html要素に`js dark`クラスが適用されダークテーマが有効
2. **Lines 13-22**: `.grid-container`でCSS Gridレイアウトを定義（3列）
3. **Lines 26-35**: `.card`でツールカードのスタイルを定義
4. **Lines 56-89**: `<dl class="grid-container">`内に8つのツールカードを配置

#### Step 3: ナビゲーション構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html | `deps/v8/tools/index.html` | ヘッダーナビゲーション（lines 43-54）とカードリンク構造 |

**主要処理フロー**:
- **Lines 43-54**: `<header>`内のナビゲーションメニュー
- **Lines 57-59**: System Analyzerカードの構造（dt/dd要素）
- **Lines 91-95**: フッター領域のGitHubリンク

### プログラム呼び出し階層図

```
index.html (静的HTML)
    |
    +-- 外部CSS読み込み
    |      └── //v8.dev/_css/main.css
    |
    +-- インラインCSS
    |      └── .grid-container, .card スタイル定義
    |
    +-- ヘッダーナビゲーション
    |      +-- V8ロゴ → //v8.dev
    |      +-- Tools (現在地)
    |      +-- Tools Versions → //v8.dev/tools/versions
    |      └── Main Page → //v8.dev
    |
    +-- ツールカードグリッド
    |      +-- System Analyzer → ./system-analyzer/index.html
    |      +-- Callstats → ./callstats.html
    |      +-- Heap Stats → ./heap-stats/index.html
    |      +-- Heap Layout → ./heap-layout/index.html
    |      +-- Parse Processor → ./parse-processor.html
    |      +-- Profview → ./profview/index.html
    |      +-- Turbolizer → ./turbolizer/index.html
    |      └── Zone Stats → ./zone-stats/index.html
    |
    └── フッター
           └── GitHub → https://github.com/v8/tools
```

### データフロー図

```
[入力]               [処理]                    [出力]

ユーザーアクセス ───> index.html表示 ───> ブラウザ描画
                          │
                          └───> カードクリック ───> 各ツール画面へ遷移
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `deps/v8/tools/index.html` | ソース | ランディングページ本体 |
| main.css | `//v8.dev/_css/main.css` | 外部CSS | v8.devサイト共通スタイル |
