# 画面設計書 10-Parse Processor

## 概要

本ドキュメントは、V8 Parse Processor（PARSEROR）の画面設計について記述する。Parse ProcessorはV8のパース・コンパイル・初回実行の分析ツールであり、`--log-function-events`フラグで収集したログデータを可視化する。

### 本画面の処理概要

**業務上の目的・背景**：JavaScriptの起動パフォーマンスを最適化するためには、パース・コンパイル・初回実行の各フェーズでどれだけの時間が消費されているかを理解する必要がある。本画面は、スクリプトごとのパース・コンパイル時間を可視化し、ボトルネックとなるスクリプトや関数を特定できるようにする。

**画面へのアクセス方法**：
1. V8 Tools Landing Pageから「Parse Processor」カードをクリック
2. ブラウザでdeps/v8/tools/parse-processor.htmlを直接開く

**主要な操作・処理内容**：
1. v8.logファイル（--log-function-eventsで生成）をアップロード
2. スクリプト一覧でスクリプトサイズと種類を確認
3. スクリプトごとの詳細グラフで時間推移を分析
4. グラフクリックで特定時点の関数リストを表示

**画面遷移**：
- 遷移元：V8 Tools Landing Page
- 遷移先：なし（単一画面アプリケーション）

**権限による表示制御**：本画面は認証・権限制御を持たない。全てのユーザーが同一のコンテンツを閲覧できる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | v8 | 主機能 | V8パース・コンパイル・初回実行の分析（--log-function-events） |
| 29 | perf_hooks | 補助機能 | パース・コンパイル時間のグラフ表示と分析 |
| 1 | fs | 補助機能 | V8ログファイルの読み込み |

## 画面種別

分析 / ビジュアライザー

## URL/ルーティング

```
/deps/v8/tools/parse-processor.html
```

## 入出力項目

### 入力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| v8.log | 入力 | File | 必須 | --log-function-eventsで生成したログファイル |

### 出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| スクリプト一覧 | 出力 | DIV | スクリプトサイズバー表示 |
| スクリプト詳細 | 出力 | Chart | パース・コンパイル時間のグラフ |
| 関数リスト | 出力 | UL | 選択時点の関数一覧 |

## 表示項目

### ヘッダー

| 項目名 | 型 | 説明 |
|--------|-----|------|
| タイトル | H1 | "BEHOLD, THIS IS PARSEROR!" |

### 使用方法セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Usage説明 | H2 | 使用方法の見出し |
| コマンド例 | CODE | `/path/to/d8 --log-function-events your_script.js` |

### データセクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Data見出し | H2 | データセクションの見出し |
| uploadInput | INPUT(file) | ファイル選択 |
| count | SPAN | トレースエントリ数 |

### スクリプト一覧セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Scripts見出し | H2 | スクリプトセクションの見出し |
| scripts | DIV | スクリプトサイズバー表示コンテナ |

### スクリプトサイズバー

| 項目名 | 型 | 説明 |
|--------|-----|------|
| script-size | A | スクリプトリンク（サイズに応じた幅） |
| script-details.id | DIV | スクリプトID |
| script-details(size) | DIV | スクリプトサイズ（バイト表示） |
| script-details(url) | DIV | スクリプトURL/名前 |

### スクリプトサイズバーのカラーコード

| クラス | 色 | 意味 |
|--------|-----|------|
| （デフォルト） | #505050 | 通常スクリプト |
| .eval | #ee6300fc | eval由来スクリプト |
| .streaming | #008aff | ストリーミングコンパイル |
| .deserialized | #1fad00fc | デシリアライズ済み |

### 結果セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Result見出し | H2 | 結果セクションの見出し |
| result | DIV | スクリプト詳細グラフコンテナ |

### スクリプト詳細

| 項目名 | 型 | 説明 |
|--------|-----|------|
| script | DIV | 個別スクリプトコンテナ |
| script h3 | H3 | スクリプトタイトル（ID + URL） |
| script-details | PRE | スクリプトサマリー |
| chart | DIV | Google Chartsグラフ |
| funktion-list | DIV | 関数リスト |

### グラフ凡例

| 系列 | 色 | 説明 |
|------|-----|------|
| Any Parse | #4D4D4D | 任意のパースイベント |
| 1st Exec | #fff700 | 初回実行 |
| Any Compile | #5DA5DA | 任意のコンパイルイベント |
| Eager Compile | #FAA43A | 即時コンパイル |
| Lazy Compile | #FAA43A (dash) | 遅延コンパイル |
| Parsing | #F17CB0 | パース処理 |
| Preparse | #B2912F | プリパース |
| Preparse with Var. Resolution | #B276B2 | 変数解決付きプリパース |
| Deserialization | #DECF3F | デシリアライズ |
| Baseline | #606611 (dash) | ベースラインコンパイル |
| Optimize | #F15854 | 最適化 |

## イベント仕様

### 1-ファイルアップロード

**トリガー**: `#uploadInput`でのファイル選択

**処理フロー**:
1. ファイル選択でonchange発火
2. loadFile() 呼び出し
3. FileReaderでファイル読み込み
4. ParseProcessor.processString()でログ解析
5. renderParseResults()で結果表示
6. document.parseProcessorにインスタンス保存

### 2-スクリプトリンククリック

**トリガー**: scripts内のスクリプトサイズバークリック

**処理フロー**:
1. href="#script{id}"でページ内リンク
2. 対応するスクリプト詳細セクションにスクロール

### 3-グラフポイント選択

**トリガー**: グラフ上のポイントクリック

**処理フロー**:
1. chart.getSelection()で選択取得
2. selectGraphPointHandler()呼び出し
3. 選択時点のrow、columnから時刻とメトリクスを特定
4. script.getFunktionsAtTime()で該当関数を取得
5. createFunktionList()で関数リストを生成
6. funktion-listを置換

### 4-グラフズーム

**トリガー**: グラフ上でのドラッグ（dragToZoom）

**処理フロー**:
1. Google Chartsのexplorerオプションで処理
2. ズームイン（最大0.01まで）
3. 右クリックでリセット

## データベース更新仕様

本画面はクライアントサイドのみで動作し、データベース操作はなし。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし（ローカルファイル処理のみ） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| - | - | - | console.time/timeEndでパース時間を出力 |

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| 不正なログファイル | パースエラー、処理中断 |
| 空のスクリプト | renderScript()でスキップ |

## 備考

- Google Chartsライブラリ（corechart）を使用
- ES Modulesを使用（parse-processor.mjs）
- IntersectionObserverでグラフの遅延読み込み
- kMaxTime = 120秒でグラフの最大時間を制限
- kTimeIncrement = 1（グラフの時間解像度）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ParseProcessorのデータモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | parse-processor.mjs | `deps/v8/tools/parse-processor.mjs` | ParseProcessorクラス、Scriptクラス |

**読解のコツ**: v8.logには関数イベント（parse、preparse、compile等）がタイムスタンプ付きで記録されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | parse-processor.html | `deps/v8/tools/parse-processor.html` | HTML構造、インラインモジュール |

**主要処理フロー**:
1. **Lines 113**: Google Charts読み込み
2. **Lines 114-118**: 初期化
3. **Lines 116**: ParseProcessorインポート
4. **Lines 118**: Google Charts初期化
5. **Lines 124-126**: DOMContentLoaded でフォーカス設定
6. **Lines 128-144**: loadFile() - ファイル読み込み・解析

#### Step 3: レンダリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | parse-processor.html | `deps/v8/tools/parse-processor.html` | renderParseResults()、appendGraph() |

**主要処理フロー**:
- **Lines 189-212**: renderParseResults() - 結果表示
- **Lines 218-235**: renderScript() - スクリプト詳細表示
- **Lines 237-264**: renderScriptSizes() - スクリプトサイズバー表示
- **Lines 305-370**: appendGraph() - Google Chartsグラフ生成
- **Lines 372-405**: グラフ選択ハンドラ、関数リスト生成

#### Step 4: グラフ系列を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | parse-processor.html | `deps/v8/tools/parse-processor.html` | series定義 |

**主要処理フロー**:
- **Lines 272-297**: Seriesクラスと系列定義（11種類のメトリクス）

### プログラム呼び出し階層図

```
parse-processor.html
    │
    ├── Google Charts
    │       └── google.charts.load('current', {packages: ['corechart']})
    │
    ├── parse-processor.mjs (ES Module)
    │       ├── ParseProcessor
    │       │       └── processString()
    │       └── kSecondsToMillis, BYTES, PERCENT
    │
    ├── loadFile()
    │       ├── FileReader
    │       ├── ParseProcessor.processString()
    │       └── renderParseResults()
    │
    ├── renderParseResults()
    │       ├── renderScript() (各スクリプト)
    │       ├── renderScriptSizes()
    │       └── IntersectionObserver (遅延グラフ読み込み)
    │
    ├── appendGraph()
    │       ├── google.visualization.DataTable
    │       ├── google.visualization.ComboChart
    │       └── selectGraphPointHandler()
    │
    └── selectGraphPointHandler()
            ├── script.getFunktionsAtTime()
            └── createFunktionList()
```

### データフロー図

```
[入力]               [処理]                    [出力]

v8.log ─────────> loadFile() ──────────────> FileReader
    ファイル選択        │
                       ▼
                  ParseProcessor.processString()
                       │
                       ├─> scripts 配列
                       │
                       └─> totalScript
                               │
                               ▼
                         renderParseResults()
                               │
                               ├─> renderScriptSizes() ──> #scripts
                               │
                               └─> renderScript() (各スクリプト)
                                       │
                                       └─> IntersectionObserver
                                               │
                                               └─> appendGraph()
                                                       │
                                                       └─> Google Charts
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| parse-processor.html | `deps/v8/tools/parse-processor.html` | HTML | メインHTMLファイル（JS含む） |
| parse-processor.mjs | `deps/v8/tools/parse-processor.mjs` | JS | ParseProcessorクラス |
