# 画面設計書 2-System Analyzer

## 概要

本ドキュメントは、System Analyzer（Indicium）の画面設計について記述する。System AnalyzerはV8ログファイル（v8.log）を読み込み、Maps/ICs/Deopt情報の解析・トレース・デバッグを行う統合Webインターフェースである。

### 本画面の処理概要

**業務上の目的・背景**：V8エンジンの内部動作（特にMaps、Inline Caches、Deoptimization）を理解・分析するためには、ランタイムで生成されるログデータを可視化・解析する必要がある。本画面は、V8が出力するv8.logファイルを解析し、タイムライン表示、リスト表示、詳細パネルを通じて、開発者がパフォーマンス問題やランタイム動作を深く理解できるようにする。

**画面へのアクセス方法**：
1. V8 Tools Landing Pageから「System Analyzer」カードをクリック
2. ブラウザでdeps/v8/tools/system-analyzer/index.htmlを直接開く
3. ローカルサーバー（tools/system-analyzer/local-server.sh）経由でアクセス

**主要な操作・処理内容**：
1. v8.logファイルをドラッグ＆ドロップまたはファイル選択でアップロード
2. タイムラインパネルで時間範囲を選択してフィルタリング
3. 各種トラック（Samples、Timers、Map、IC、Deopt、Code）でイベントを確認
4. パネル（Script、Code、Map、IC List、Map Events、Deopt Events、Code Events、Profiler）で詳細情報を表示
5. キーボードショートカットでナビゲーション操作

**画面遷移**：
- 遷移元：V8 Tools Landing Page
- 遷移先：なし（単一画面アプリケーション）
- 内部遷移：タイムライン選択による各パネル間の連動

**権限による表示制御**：本画面は認証・権限制御を持たない。全てのユーザーが同一のコンテンツを閲覧できる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | v8 | 主機能 | V8ログファイル（v8.log）の読み込みとMaps/ICs/Deopt情報の解析・表示 |
| 27 | inspector | 補助機能 | V8インスペクターデバッグ情報の可視化とトレース |
| 29 | perf_hooks | 補助機能 | サンプリングプロファイルのタイムライン表示 |
| 30 | trace_events | 補助機能 | トレースイベントのタイムライン表示とフィルタリング |

## 画面種別

分析 / ダッシュボード

## URL/ルーティング

```
/deps/v8/tools/system-analyzer/index.html
```

または

```
http://localhost:8000/system-analyzer/index.html
```

## 入出力項目

### 入力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| v8.logファイル | 入力 | File | 必須 | V8ログファイル（--log-allまたは個別フラグで生成） |

### 出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| タイムラインデータ | 出力 | Object | 解析されたログイベントのタイムライン |
| Maps情報 | 出力 | Array | Mapオブジェクトの生成・遷移情報 |
| ICs情報 | 出力 | Array | Inline Cacheの状態遷移情報 |
| Deopt情報 | 出力 | Array | 最適化解除イベント情報 |
| Code情報 | 出力 | Array | コード生成・コンパイル情報 |
| Tick情報 | 出力 | Array | サンプリングプロファイラのtick情報 |
| Timer情報 | 出力 | Array | タイマーイベント情報 |

## 表示項目

### ファイル読み込みセクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| log-file-reader | カスタム要素 | ファイルドラッグ＆ドロップ・選択エリア |

### タイムラインパネル

| 項目名 | 型 | 説明 |
|--------|-----|------|
| tick-track | トラック | サンプリングプロファイラのtickデータ表示 |
| timer-track | トラック | タイマーイベント表示 |
| map-track | トラック | Mapイベント表示 |
| ic-track | トラック | ICイベント表示 |
| deopt-track | トラック | Deoptイベント表示 |
| code-track | トラック | コードイベント表示 |

### 詳細パネル群

| 項目名 | 型 | 説明 |
|--------|-----|------|
| script-panel | パネル | スクリプトソースコード表示 |
| code-panel | パネル | 生成コード詳細表示 |
| map-panel | パネル | Map遷移図表示 |
| ic-list | リスト | ICイベント一覧（凡例付き） |
| map-list | リスト | Mapイベント一覧 |
| deopt-list | リスト | Deoptイベント一覧 |
| code-list | リスト | コードイベント一覧 |
| profiler-panel | パネル | プロファイラー詳細表示 |

### Instructions セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 使用方法説明 | テキスト | d8/Chromeでのログ生成方法 |
| LOG_FLAGS一覧 | 定義リスト | 利用可能なV8フラグ説明 |
| キーボードショートカット | 定義リスト | ナビゲーション操作説明 |

## イベント仕様

### 1-ファイルアップロード

ユーザーがv8.logファイルをアップロードすると、以下の処理が実行される。

**トリガー**: log-file-readerへのファイルドロップまたは選択

**処理フロー**:
1. `fileuploadstart`イベント発火 → App.handleFileUploadStart()
2. Processorインスタンス生成、Stateリセット
3. `fileuploadchunk`イベント発火 → App.handleFileUploadChunk()でチャンク処理
4. `fileuploadend`イベント発火 → App.handleFileUploadEnd()で解析完了
5. 各タイムラインデータをビューにバインド
6. containerのクラスを'loaded'に変更して表示

### 2-タイムライン時間範囲選択

**トリガー**: タイムラインパネル上でのドラッグ選択

**処理フロー**:
1. `SelectTimeEvent`イベント発火
2. App.handleTimeRangeSelect() → App.selectTimeRange()
3. 選択範囲に該当するエントリを各パネルに表示

### 3-エントリ選択

**トリガー**: リストまたはパネル内のエントリクリック

**処理フロー**:
1. `SelectionEvent`または`SelectRelatedEvent`イベント発火
2. App.handleSelectEntries() → App.selectEntries()
3. エントリタイプに応じた表示処理（showMapEntries, showIcEntries等）

### 4-エントリフォーカス

**トリガー**: エントリのダブルクリックまたは特定操作

**処理フロー**:
1. `FocusEvent`イベント発火
2. App.handleFocusLogEntry() → App.focusLogEntry()
3. エントリタイプに応じたフォーカス処理

### 5-キーボードナビゲーション

| キー | 動作 |
|-----|------|
| CTRL + Mouse Move | ツールチップ即座表示 |
| A | 左スクロール |
| D | 右スクロール |
| SHIFT + Arrow Up | Map遷移を前方へ（最初の子） |
| SHIFT + Arrow Down | Map遷移を後方へ |
| Arrow Up | 前のMapチャンクへ |
| Arrow Down | 次のMapへ |
| Arrow Left | 前のチャンクへ |
| Arrow Right | 次のチャンクへ |
| + | タイムラインズームイン |
| - | タイムラインズームアウト |

## データベース更新仕様

本画面はクライアントサイドのみで動作し、データベース操作はなし。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし（ローカルファイル処理のみ） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-001 | エラー | Log file contains errors! | ファイル解析中にエラー発生時 |

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| 不正なファイル形式 | エラーメッセージ表示、処理中断 |
| ファイル解析エラー | log-file-readerにエラー表示 |
| 大容量ファイル | プログレスコールバックで進捗表示 |

## 備考

- 本画面はES Modulesを使用したモダンJavaScriptアプリケーション
- Web Componentsを使用したカスタム要素で構成
- ローカルシンボルサーバー使用時はlocal-server.shで起動
- CORSの関係でWebサーバー経由でのアクセスが推奨

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ログエントリの種類とデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | log.mjs | `deps/v8/tools/system-analyzer/log/log.mjs` | LogEntryベースクラスの構造 |
| 1-2 | map.mjs | `deps/v8/tools/system-analyzer/log/map.mjs` | MapLogEntryの構造 |
| 1-3 | ic.mjs | `deps/v8/tools/system-analyzer/log/ic.mjs` | IcLogEntryの構造 |
| 1-4 | code.mjs | `deps/v8/tools/system-analyzer/log/code.mjs` | CodeLogEntry, DeoptLogEntryの構造 |
| 1-5 | tick.mjs | `deps/v8/tools/system-analyzer/log/tick.mjs` | TickLogEntryの構造 |

**読解のコツ**: 各LogEntryクラスはLogEntryを継承しており、timestamp、type等の共通プロパティを持つ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `deps/v8/tools/system-analyzer/index.html` | HTML構造、カスタム要素の配置 |
| 2-2 | index.mjs | `deps/v8/tools/system-analyzer/index.mjs` | Appクラスの初期化と各種イベントハンドラ |

**主要処理フロー**:
1. **Line 19-22**: スクリプト読み込み、log-file-reader初期化
2. **Line 21**: Appインスタンス作成（globalThis.app）
3. **index.mjs Line 23-56**: Appコンストラクタでビュー要素への参照設定
4. **index.mjs Line 71-84**: カスタム要素の動的インポート

#### Step 3: ファイル処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | processor.mjs | `deps/v8/tools/system-analyzer/processor.mjs` | ログファイル解析の中心 |
| 3-2 | log-file-reader.mjs | `deps/v8/tools/system-analyzer/view/log-file-reader.mjs` | ファイル読み込みUI |

**主要処理フロー**:
- **index.mjs Line 343-349**: handleFileUploadStart - Processor生成
- **index.mjs Line 351-353**: handleFileUploadChunk - チャンク処理
- **index.mjs Line 355-388**: handleFileUploadEnd - 解析完了、ビューへデータバインド

#### Step 4: 状態管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | app-model.mjs | `deps/v8/tools/system-analyzer/app-model.mjs` | Stateクラスによる状態管理 |
| 4-2 | timeline.mjs | `deps/v8/tools/system-analyzer/timeline.mjs` | タイムラインデータ構造 |

#### Step 5: ビューコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | events.mjs | `deps/v8/tools/system-analyzer/view/events.mjs` | カスタムイベント定義 |
| 5-2 | timeline-panel.mjs | `deps/v8/tools/system-analyzer/view/timeline-panel.mjs` | タイムラインUI |
| 5-3 | map-panel.mjs | `deps/v8/tools/system-analyzer/view/map-panel.mjs` | Map詳細表示 |
| 5-4 | list-panel.mjs | `deps/v8/tools/system-analyzer/view/list-panel.mjs` | リスト表示共通 |

### プログラム呼び出し階層図

```
index.html
    │
    └── index.mjs (App クラス)
            │
            ├── view/log-file-reader.mjs
            │       └── fileuploadstart/chunk/end イベント
            │
            ├── processor.mjs (Processor クラス)
            │       ├── processChunk()
            │       ├── finalize()
            │       └── 各種Timeline生成
            │
            ├── app-model.mjs (State クラス)
            │       └── 各Timeline保持
            │
            └── view/*.mjs (各種パネル)
                    ├── timeline-panel.mjs
                    ├── map-panel.mjs
                    ├── script-panel.mjs
                    ├── code-panel.mjs
                    ├── list-panel.mjs
                    └── profiler-panel.mjs
```

### データフロー図

```
[入力]               [処理]                    [出力]

v8.log ─────────> log-file-reader ─────────> ファイルチャンク
    ファイル選択        │
                       ▼
                  Processor.processChunk() ─> ログ解析
                       │
                       ▼
                  Processor.finalize() ─────> Timeline生成
                       │
                       ├─> mapTimeline ────────> map-panel, map-track
                       ├─> icTimeline ─────────> ic-list, ic-track
                       ├─> deoptTimeline ──────> deopt-list, deopt-track
                       ├─> codeTimeline ───────> code-panel, code-track
                       ├─> tickTimeline ───────> tick-track, profiler-panel
                       └─> timerTimeline ──────> timer-track
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `deps/v8/tools/system-analyzer/index.html` | HTML | メインHTMLファイル |
| index.mjs | `deps/v8/tools/system-analyzer/index.mjs` | JS | アプリケーションエントリーポイント |
| index.css | `deps/v8/tools/system-analyzer/index.css` | CSS | スタイルシート |
| app-model.mjs | `deps/v8/tools/system-analyzer/app-model.mjs` | JS | 状態管理 |
| processor.mjs | `deps/v8/tools/system-analyzer/processor.mjs` | JS | ログ解析処理 |
| timeline.mjs | `deps/v8/tools/system-analyzer/timeline.mjs` | JS | タイムラインデータ構造 |
| helper.mjs | `deps/v8/tools/system-analyzer/helper.mjs` | JS | ユーティリティ関数 |
| profiling.mjs | `deps/v8/tools/system-analyzer/profiling.mjs` | JS | プロファイリング処理 |
| log/log.mjs | `deps/v8/tools/system-analyzer/log/log.mjs` | JS | LogEntryベースクラス |
| log/map.mjs | `deps/v8/tools/system-analyzer/log/map.mjs` | JS | MapLogEntry |
| log/ic.mjs | `deps/v8/tools/system-analyzer/log/ic.mjs` | JS | IcLogEntry |
| log/code.mjs | `deps/v8/tools/system-analyzer/log/code.mjs` | JS | CodeLogEntry |
| log/tick.mjs | `deps/v8/tools/system-analyzer/log/tick.mjs` | JS | TickLogEntry |
| log/timer.mjs | `deps/v8/tools/system-analyzer/log/timer.mjs` | JS | TimerLogEntry |
| view/log-file-reader.mjs | `deps/v8/tools/system-analyzer/view/log-file-reader.mjs` | JS | ファイル読み込みUI |
| view/timeline-panel.mjs | `deps/v8/tools/system-analyzer/view/timeline-panel.mjs` | JS | タイムラインパネル |
| view/map-panel.mjs | `deps/v8/tools/system-analyzer/view/map-panel.mjs` | JS | Mapパネル |
| view/list-panel.mjs | `deps/v8/tools/system-analyzer/view/list-panel.mjs` | JS | リストパネル |
| view/script-panel.mjs | `deps/v8/tools/system-analyzer/view/script-panel.mjs` | JS | スクリプトパネル |
| view/code-panel.mjs | `deps/v8/tools/system-analyzer/view/code-panel.mjs` | JS | コードパネル |
| view/profiler-panel.mjs | `deps/v8/tools/system-analyzer/view/profiler-panel.mjs` | JS | プロファイラーパネル |
| view/events.mjs | `deps/v8/tools/system-analyzer/view/events.mjs` | JS | カスタムイベント定義 |
| view/helper.mjs | `deps/v8/tools/system-analyzer/view/helper.mjs` | JS | ビューヘルパー |
| view/tool-tip.mjs | `deps/v8/tools/system-analyzer/view/tool-tip.mjs` | JS | ツールチップ |
| local-server.sh | `deps/v8/tools/system-analyzer/local-server.sh` | Shell | ローカルサーバー起動スクリプト |
