# 画面設計書 3-Profview (Tick Processor)

## 概要

本ドキュメントは、Profview（Tick Processor）の画面設計について記述する。ProfviewはV8プロファイリングログ（v8.json）を読み込み、サンプリングプロファイルをビジュアライズするツールである。コールツリー、タイムライン、関数詳細などの形式でプロファイリングデータを表示する。

### 本画面の処理概要

**業務上の目的・背景**：JavaScriptアプリケーションのパフォーマンス最適化において、どの関数がどれだけの実行時間を消費しているかを把握することは重要である。本画面は、V8の`--prof`フラグで収集したサンプリングプロファイルを可視化し、開発者がパフォーマンスボトルネックを特定・分析できるようにする。

**画面へのアクセス方法**：
1. V8 Tools Landing Pageから「Profview」カードをクリック
2. ブラウザでdeps/v8/tools/profview/index.htmlを直接開く

**主要な操作・処理内容**：
1. v8.jsonファイル（前処理済みプロファイルデータ）をファイル選択でアップロード
2. タイムラインで時間範囲を選択してフィルタリング
3. コールツリーで階層的な関数呼び出しを分析
4. 表示モード（Bottom-up、Top-down、Function List）を切り替えて分析
5. Attribution、Categories、Sortの各オプションで表示をカスタマイズ
6. ソースコード表示（--log-source-code使用時）

**画面遷移**：
- 遷移元：V8 Tools Landing Page
- 遷移先：なし（単一画面アプリケーション）

**権限による表示制御**：本画面は認証・権限制御を持たない。全てのユーザーが同一のコンテンツを閲覧できる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | v8 | 主機能 | V8プロファイリングログ（v8.json）のビジュアライズとコールツリー表示 |
| 29 | perf_hooks | 補助機能 | サンプリングプロファイルの時間分析とパフォーマンス測定 |
| 1 | fs | 補助機能 | プロファイルファイル（v8.json）の読み込み処理 |

## 画面種別

分析 / ビューワー

## URL/ルーティング

```
/deps/v8/tools/profview/index.html
```

## 入出力項目

### 入力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| v8.jsonファイル | 入力 | File | 必須 | linux-tick-processor --preprocessで生成したJSONファイル |

### 出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| タイムライン | 出力 | Canvas | サンプルの時系列表示 |
| コールツリー | 出力 | Table | 関数呼び出しの階層表示 |
| サマリー | 出力 | HTML | プロファイル全体の概要 |
| 関数詳細 | 出力 | HTML | 選択した関数の詳細情報 |

## 表示項目

### ヘルプセクション（初期表示）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Usage説明 | テキスト | プロファイル記録・前処理方法の説明 |
| d8コマンド例 | コード | `d8 --prof your-file.js` |
| 前処理コマンド例 | コード | `linux-tick-processor --preprocess v8.log > v8.json` |
| Chromeでの記録方法 | テキスト | --no-sandbox --js-flags=--prof |
| Androidでの記録方法 | テキスト | --single-process --no-sandbox --js-flags=--prof |

### タイムラインセクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| timeline-canvas | Canvas | プロファイルデータのタイムライン描画 |
| timeline-legend | DIV | 色凡例 |
| show-logging | Checkbox | ロギング表示切替 |
| timeline-currentCode | SPAN | 現在選択中のコードオブジェクト表示 |
| source-viewer | TABLE | ソースコード表示テーブル |
| source-viewer-hide-button | Button | ソースビューワー非表示ボタン |

### モードバー

| 項目名 | 型 | 説明 |
|--------|-----|------|
| mode-bar | DIV | 表示モード切替ボタン群 |

### コールツリーセクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| calltree-attribution | SELECT | 帰属方法選択（js-exclude-bc等） |
| calltree-categories | SELECT | カテゴリ選択（code-type、none等） |
| calltree-sort | SELECT | ソート方法選択（time、own-time等） |
| calltree-table | TABLE | コールツリー表示テーブル |

### コールツリーテーブルヘッダー

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Time (incl) | TH | 包含実行時間 |
| % of parent | TH | 親に対する割合 |
| Own time | TH | 自己実行時間 |
| Function/category | TH | 関数名またはカテゴリ |
| Ticks | TH | tick数 |
| Own ticks | TH | 自己tick数 |

### サマリーセクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| summary | DIV | プロファイル全体のサマリー表示 |

### 関数詳細セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| function-details | DIV | 選択した関数の詳細情報 |

## イベント仕様

### 1-ファイル選択

**トリガー**: `#fileinput`でのファイル選択

**処理フロー**:
1. ファイル選択ダイアログでv8.jsonを選択
2. FileReaderでファイル内容を読み込み
3. JSONパースしてプロファイルデータを取得
4. `main.setFile()`でデータを設定
5. 各ビューコンポーネントを更新

### 2-モード切替

**トリガー**: mode-bar内のボタンクリック

**処理フロー**:
1. `main.setMode(mode)`を呼び出し（bottom-up、top-down、function-list）
2. コールツリーのattribution、categories、sortを更新
3. `main.delayRender()`で再描画をスケジュール

### 3-タイムライン範囲選択

**トリガー**: timeline-canvas上でのドラッグ

**処理フロー**:
1. `main.setViewInterval(start, end)`を呼び出し
2. 選択範囲のtickデータをフィルタリング
3. コールツリーを再計算
4. 各ビューを更新

### 4-コールツリー操作

**トリガー**: calltree-tableの行クリック/展開

**処理フロー**:
1. 行クリックで関数詳細を表示
2. 展開アイコンクリックで子要素を表示/非表示
3. 関数名クリックでソースコードにジャンプ（可能な場合）

### 5-Attribution変更

**トリガー**: `#calltree-attribution`のselect変更

**処理フロー**:
1. `main.setCallTreeAttribution(attribution)`を呼び出し
2. コールツリーの帰属計算を更新
3. 再描画

### 6-Categories変更

**トリガー**: `#calltree-categories`のselect変更

**処理フロー**:
1. `main.setCallTreeCategories(categories)`を呼び出し
2. コールツリーのカテゴリグループ化を更新
3. 再描画

### 7-Sort変更

**トリガー**: `#calltree-sort`のselect変更

**処理フロー**:
1. `main.setCallTreeSort(sort)`を呼び出し
2. コールツリーのソート順を更新
3. 再描画

## データベース更新仕様

本画面はクライアントサイドのみで動作し、データベース操作はなし。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし（ローカルファイル処理のみ） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-001 | 情報 | Script source is available. | --log-source-codeでスクリプトソースが含まれている場合 |
| MSG-002 | 警告 | Script source not available. Run profiler with --log-source-code. | スクリプトソースが含まれていない場合 |

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| 不正なJSONファイル | JSONパースエラー、処理中断 |
| 空のプロファイル | 空の表示、ヘルプ継続表示 |
| 未対応のファイル形式 | エラー表示なし（想定外の動作） |

## 備考

- v8.jsonファイルは`linux-tick-processor --preprocess`コマンドで生成する必要がある
- ソースコード表示には`--log-source-code`フラグでのプロファイル収集が必要
- Androidプロファイルの場合、シンボル解決にlib.unstripped/libchrome.soが必要
- タイムライン描画にはCanvasを使用
- Google Fontsの外部依存（Roboto、Material Icons）あり

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

v8.jsonファイルの構造とプロファイルデータモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | profile-utils.js | `deps/v8/tools/profview/profile-utils.js` | プロファイルデータのユーティリティ関数 |

**読解のコツ**: v8.jsonにはticks配列、scripts配列、code配列などが含まれる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `deps/v8/tools/profview/index.html` | HTML構造、body.onLoadでmain.onLoad()呼び出し |
| 2-2 | profview.js | `deps/v8/tools/profview/profview.js` | mainオブジェクトとビューコンポーネント |

**主要処理フロー**:
1. **HTML Line 20**: `onLoad="main.onLoad();"` - 初期化
2. **profview.js Line 18-27**: `createViews()` - ビューコンポーネント生成
3. **profview.js Line 29-49**: `emptyState()` - 初期状態定義
4. **profview.js Line 57-59**: mainオブジェクトの初期化

#### Step 3: ファイル読み込みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | profview.js | `deps/v8/tools/profview/profview.js` | ファイル読み込みとJSON解析 |

**主要処理フロー**:
- **HTML Line 25**: `<input type="file" id="fileinput" />` - ファイル入力
- **profview.js**: FileReader APIでファイル読み込み
- JSON.parseでプロファイルデータ解析
- main.currentStateにデータ設定

#### Step 4: ビューコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | profview.js | `deps/v8/tools/profview/profview.js` | CallTreeView、TimelineView等のビュークラス |

**主要処理フロー**:
- **profview.js Line 19-26**: ビューコンポーネント配列
  - CallTreeView - コールツリー表示
  - TimelineView - タイムライン描画
  - HelpView - ヘルプ表示
  - SummaryView - サマリー表示
  - ModeBarView - モード切替UI
  - ScriptSourceView - ソースコード表示

#### Step 5: 状態管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | profview.js | `deps/v8/tools/profview/profview.js` | main.currentStateによる状態管理 |

**主要処理フロー**:
- **profview.js Line 61-94**: `setMode()` - モード変更
- **profview.js Line 96-103**: `setCallTreeAttribution()` - 帰属変更
- **profview.js Line 105-112**: `setCallTreeSort()` - ソート変更
- **profview.js Line 114-121**: `setCallTreeCategories()` - カテゴリ変更
- **profview.js Line 123-130**: `setViewInterval()` - 時間範囲変更

### プログラム呼び出し階層図

```
index.html
    │
    ├── profview.js (main オブジェクト)
    │       │
    │       ├── createViews()
    │       │       ├── CallTreeView
    │       │       ├── TimelineView
    │       │       ├── HelpView
    │       │       ├── SummaryView
    │       │       ├── ModeBarView
    │       │       └── ScriptSourceView
    │       │
    │       ├── setMode()
    │       ├── setCallTreeAttribution()
    │       ├── setCallTreeSort()
    │       ├── setCallTreeCategories()
    │       ├── setViewInterval()
    │       ├── updateSources()
    │       └── delayRender()
    │
    └── profile-utils.js
            └── プロファイルデータ処理ユーティリティ
```

### データフロー図

```
[入力]               [処理]                    [出力]

v8.log ─────────> linux-tick-processor ───> v8.json
    d8 --prof         --preprocess

v8.json ────────> FileReader ─────────────> JSON.parse
    ファイル選択         │
                        ▼
                   main.setFile()
                        │
                        ├─> TimelineView ──────> timeline-canvas
                        ├─> CallTreeView ──────> calltree-table
                        ├─> SummaryView ───────> summary
                        └─> ScriptSourceView ──> source-viewer
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `deps/v8/tools/profview/index.html` | HTML | メインHTMLファイル |
| profview.js | `deps/v8/tools/profview/profview.js` | JS | メインアプリケーションロジック |
| profile-utils.js | `deps/v8/tools/profview/profile-utils.js` | JS | プロファイルデータユーティリティ |
| profview.css | `deps/v8/tools/profview/profview.css` | CSS | スタイルシート |
