# 画面設計書 4-Turbolizer

## 概要

本ドキュメントは、Turbolizerの画面設計について記述する。TurbolizerはV8のTurboFanコンパイラが生成するSea of Nodesグラフ（中間表現）を可視化するツールである。コンパイラの最適化フェーズを分析し、各フェーズでのノードグラフの変化を追跡できる。

### 本画面の処理概要

**業務上の目的・背景**：V8のTurboFanコンパイラは複数の最適化フェーズを経てJavaScriptを機械語に変換する。この過程で生成されるSea of Nodesグラフは複雑であり、コンパイラ開発者やパフォーマンス分析者が最適化の過程を理解するには可視化ツールが不可欠である。本画面は、TurboFanの内部動作を視覚的に理解し、最適化問題のデバッグを支援する。

**画面へのアクセス方法**：
1. V8 Tools Landing Pageから「Turbolizer」カードをクリック
2. ブラウザでdeps/v8/tools/turbolizer/index.htmlを直接開く

**主要な操作・処理内容**：
1. TurboFanグラフJSONファイルをアップロード（CTRL+L）
2. フェーズリストから表示するフェーズを選択
3. グラフビューでノードの選択・ナビゲーション
4. ソースコードビューでJavaScriptソースを確認
5. 逆アセンブリビューで生成された機械語を確認
6. Rangesビューでレジスタ割り当てを確認
7. ノード履歴ビューで最適化の変遷を追跡

**画面遷移**：
- 遷移元：V8 Tools Landing Page
- 遷移先：なし（単一画面アプリケーション）
- 内部遷移：フェーズ選択、ノード選択による各ビュー間の連動

**権限による表示制御**：本画面は認証・権限制御を持たない。全てのユーザーが同一のコンテンツを閲覧できる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | v8 | 主機能 | TurboFanコンパイラが生成するSea of Nodesグラフの可視化 |
| 27 | inspector | 補助機能 | コンパイラ最適化フェーズのデバッグ情報表示 |
| 1 | fs | 補助機能 | TurboFanグラフデータファイルのアップロード処理 |

## 画面種別

分析 / ビジュアライザー

## URL/ルーティング

```
/deps/v8/tools/turbolizer/index.html
```

## 入出力項目

### 入力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| TurboFanグラフJSON | 入力 | File | 必須 | --trace-turboで生成したJSONファイル |

### 出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| ノードグラフ | 出力 | SVG | Sea of Nodes/Turboshaftグラフの描画 |
| ソースコード | 出力 | HTML | JavaScriptソースコードのハイライト表示 |
| バイトコード | 出力 | HTML | V8バイトコードの表示 |
| 逆アセンブリ | 出力 | HTML | 生成された機械語コード |
| Ranges | 出力 | HTML | レジスタ割り当て情報 |
| 履歴 | 出力 | HTML | ノードの最適化履歴 |

## 表示項目

### 左ペイン（history）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| history | DIV | ノード履歴表示エリア |

### 中央ペイン

| 項目名 | 型 | 説明 |
|--------|-----|------|
| upload | INPUT(image) | ファイルアップロードボタン |
| upload-helper | INPUT(file) | 非表示のファイル入力 |
| ranges | DIV | Rangesビュー表示エリア |
| ranges-expand/shrink | INPUT(image) | Rangesビュー展開/縮小ボタン |

### 右ペイン

| 項目名 | 型 | 説明 |
|--------|-----|------|
| right | DIV | ソースコード/バイトコードビュー表示エリア |
| source-expand/shrink | INPUT(image) | ソースビュー展開/縮小ボタン |

### 逆アセンブリペイン

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 逆アセンブリタブ | TAB | 逆アセンブリコード表示 |
| disassembly-expand/shrink | INPUT(image) | 逆アセンブリビュー展開/縮小ボタン |

### リサイザー

| 項目名 | 型 | 説明 |
|--------|-----|------|
| resizer-left | DIV | 左ペインリサイザー |
| resizer-right | DIV | 右ペインリサイザー |
| resizer-ranges | DIV | Rangesペインリサイザー |

## イベント仕様

### 1-ファイルアップロード

**トリガー**: uploadボタンクリック or CTRL+L

**処理フロー**:
1. upload-helperのclickイベントをトリガー
2. ファイル選択ダイアログ表示
3. FileReaderでファイル読み込み
4. loadFile()でJSON解析
5. SourceResolverでソース・フェーズ情報を構築
6. GraphMultiViewでグラフ表示

### 2-フェーズ選択

**トリガー**: フェーズタブクリック

**処理フロー**:
1. GraphMultiView.displayPhaseByName()呼び出し
2. 選択フェーズのグラフデータをロード
3. GraphView/TurboshaftGraphViewで描画
4. ソースビュー、逆アセンブリビューを更新

### 3-ノード選択

**トリガー**: グラフノードクリック

**処理フロー**:
1. SelectionBrokerで選択を伝播
2. ソースコードビューで対応行をハイライト
3. 逆アセンブリビューで対応命令をハイライト
4. Rangesビューで対応レジスタをハイライト

### 4-グラフナビゲーション

| キー | 動作 |
|-----|------|
| r | グラフ再レイアウト |
| n | 選択ノードの次フェーズ表示 |
| b | 選択ノードの前フェーズ表示 |
| h | ホバーノードの履歴表示 |
| a | 全ノード選択 |
| / | 検索ボックス選択 |
| i | 入力ノードを表示 (Sea of Nodes) |
| o | 出力ノードを表示 (Sea of Nodes) |
| s | 選択ノードを非表示 (Sea of Nodes) |
| u | 非選択ノードを非表示 (Sea of Nodes) |
| UP | 全入力ノード選択 |
| DOWN | 全出力ノード選択 |
| 1-9 | 入力ノード1-9を選択 |
| CTRL+1-9 | 入力エッジ1-9をトグル |
| c | 制御出力ノード選択 |
| e | エフェクト出力ノード選択 |
| p | オリジンノード選択 |

### 5-Turboshaft固有操作

| キー | 動作 |
|-----|------|
| i | 選択ブロックの全ノード選択 |
| p | 選択ブロックを折りたたみ |
| s | 選択ブロックを展開 |
| c | ホバーノード情報をコピー |
| y | ホバーノードの未使用ブロックを折りたたみ |
| u | 選択ノードの未使用ブロックを折りたたみ |

### 6-検索

**トリガー**: / キー押下、ENTER で検索実行

**検索パターン**:
- `IfTrue` - タイトルまたは説明にIfTrueを含むノード
- `^42:` - ID 42のノードを正確に選択
- `Origin: #42` - ノード42から派生したノード

### 7-ビュー展開/縮小

**トリガー**: 各ペインの矢印ボタンクリック

**処理フロー**:
1. ペインの表示/非表示を切り替え
2. Resizerで他ペインのサイズを調整
3. GraphMultiView.onresize()で再レイアウト

## データベース更新仕様

本画面はクライアントサイドのみで動作し、データベース操作はなし。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし（ローカルファイル処理のみ） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-001 | エラー | Error: Exception during load of TurboFan JSON file | JSONファイル読み込みエラー時 |
| MSG-002 | 確認 | Do you want to clear session storage? | エラー発生後の確認ダイアログ |

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| 不正なJSONファイル | エラーダイアログ表示、sessionStorage クリア選択 |
| JSON終端不正 | 自動で空のdisassemblyフェーズを追加して復旧試行 |
| ノード参照エラー | グラフ描画をスキップ |

## 備考

- TurboFanグラフJSONは`--trace-turbo`フラグで生成
- TypeScriptで実装され、build/turbolizer.jsにバンドル
- code-prettifyライブラリでシンタックスハイライト
- ペインはドラッグでリサイズ可能
- sessionStorageで直前のファイルをキャッシュ

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

TurboFanグラフJSONの構造とデータモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | source-resolver.ts | `deps/v8/tools/turbolizer/src/source-resolver.ts` | ソース・フェーズ情報の解決 |
| 1-2 | graph.ts | `deps/v8/tools/turbolizer/src/graph.ts` | Graphデータ構造 |
| 1-3 | node.ts | `deps/v8/tools/turbolizer/src/node.ts` | Nodeデータ構造 |
| 1-4 | edge.ts | `deps/v8/tools/turbolizer/src/edge.ts` | Edgeデータ構造 |

**読解のコツ**: JSONにはsources、inlinings、phases配列が含まれ、各phaseにnodesとedgesがある。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `deps/v8/tools/turbolizer/index.html` | HTML構造、ビルド済みJSの読み込み |
| 2-2 | turbo-visualizer.ts | `deps/v8/tools/turbolizer/src/turbo-visualizer.ts` | window.onloadエントリーポイント |

**主要処理フロー**:
1. **HTML Line 55**: `build/turbolizer.js`読み込み
2. **turbo-visualizer.ts Line 18**: `window.onload`で初期化
3. **turbo-visualizer.ts Line 27**: Resizer生成
4. **turbo-visualizer.ts Lines 29-41**: タブ・InfoView初期化
5. **turbo-visualizer.ts Line 132-150**: uploadハンドラ設定

#### Step 3: ファイル読み込みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | turbo-visualizer.ts | `deps/v8/tools/turbolizer/src/turbo-visualizer.ts` | loadFile関数 |

**主要処理フロー**:
- **Line 43-130**: loadFile() - JSON解析とビュー構築
- **Line 63-64**: SourceResolver、SelectionBroker生成
- **Line 66**: JSON.parse
- **Line 69-74**: ソース・フェーズ情報の設定
- **Line 117-118**: GraphMultiView生成・表示

#### Step 4: グラフ表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | graphmultiview.ts | `deps/v8/tools/turbolizer/src/graphmultiview.ts` | 複数フェーズのグラフ管理 |
| 4-2 | views/graph-view.ts | `deps/v8/tools/turbolizer/src/views/graph-view.ts` | Sea of Nodesグラフ描画 |
| 4-3 | views/turboshaft-graph-view.ts | `deps/v8/tools/turbolizer/src/views/turboshaft-graph-view.ts` | Turboshaftグラフ描画 |

#### Step 5: 選択・連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | selection/selection-broker.ts | `deps/v8/tools/turbolizer/src/selection/selection-broker.ts` | ビュー間の選択伝播 |
| 5-2 | views/code-view.ts | `deps/v8/tools/turbolizer/src/views/code-view.ts` | ソースコード表示 |
| 5-3 | views/disassembly-view.ts | `deps/v8/tools/turbolizer/src/views/disassembly-view.ts` | 逆アセンブリ表示 |

### プログラム呼び出し階層図

```
index.html
    │
    └── build/turbolizer.js (バンドル済み)
            │
            └── turbo-visualizer.ts (window.onload)
                    │
                    ├── Resizer
                    │
                    ├── Tabs (source/disassembly)
                    │
                    ├── InfoView
                    │
                    ├── loadFile()
                    │       │
                    │       ├── SourceResolver
                    │       │       ├── setInlinings()
                    │       │       ├── setSources()
                    │       │       ├── setBytecodeSources()
                    │       │       └── parsePhases()
                    │       │
                    │       ├── SelectionBroker
                    │       │
                    │       ├── CodeView (ソースコード)
                    │       │
                    │       ├── BytecodeSourceView (バイトコード)
                    │       │
                    │       ├── DisassemblyView (逆アセンブリ)
                    │       │
                    │       ├── GraphMultiView (メイングラフ)
                    │       │       ├── GraphView
                    │       │       └── TurboshaftGraphView
                    │       │
                    │       └── HistoryView (履歴)
                    │
                    └── initializeUploadHandlers()
```

### データフロー図

```
[入力]               [処理]                    [出力]

TurboFan JSON ───> loadFile() ─────────────> JSON解析
    ファイル選択         │
                        ▼
                   SourceResolver
                        │
                        ├─> sources ───────────> CodeView
                        ├─> bytecodeSources ───> BytecodeSourceView
                        ├─> phases ────────────> GraphMultiView
                        │                              │
                        │                              ├─> GraphView (SVG)
                        │                              └─> TurboshaftGraphView (SVG)
                        │
                        └─> disassemblyPhase ──> DisassemblyView
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `deps/v8/tools/turbolizer/index.html` | HTML | メインHTMLファイル |
| turbo-visualizer.ts | `deps/v8/tools/turbolizer/src/turbo-visualizer.ts` | TS | エントリーポイント |
| source-resolver.ts | `deps/v8/tools/turbolizer/src/source-resolver.ts` | TS | ソース解決 |
| graphmultiview.ts | `deps/v8/tools/turbolizer/src/graphmultiview.ts` | TS | マルチフェーズグラフ管理 |
| graph.ts | `deps/v8/tools/turbolizer/src/graph.ts` | TS | Graphデータ構造 |
| node.ts | `deps/v8/tools/turbolizer/src/node.ts` | TS | Nodeデータ構造 |
| edge.ts | `deps/v8/tools/turbolizer/src/edge.ts` | TS | Edgeデータ構造 |
| tabs.ts | `deps/v8/tools/turbolizer/src/tabs.ts` | TS | タブUI管理 |
| resizer.ts | `deps/v8/tools/turbolizer/src/resizer.ts` | TS | ペインリサイズ |
| graph-view.ts | `deps/v8/tools/turbolizer/src/views/graph-view.ts` | TS | Sea of Nodesグラフビュー |
| turboshaft-graph-view.ts | `deps/v8/tools/turbolizer/src/views/turboshaft-graph-view.ts` | TS | Turboshaftグラフビュー |
| code-view.ts | `deps/v8/tools/turbolizer/src/views/code-view.ts` | TS | ソースコードビュー |
| bytecode-source-view.ts | `deps/v8/tools/turbolizer/src/views/bytecode-source-view.ts` | TS | バイトコードビュー |
| disassembly-view.ts | `deps/v8/tools/turbolizer/src/views/disassembly-view.ts` | TS | 逆アセンブリビュー |
| range-view.ts | `deps/v8/tools/turbolizer/src/views/range-view.ts` | TS | Rangesビュー |
| history-view.ts | `deps/v8/tools/turbolizer/src/views/history-view.ts` | TS | 履歴ビュー |
| info-view.ts | `deps/v8/tools/turbolizer/src/views/info-view.ts` | TS | 情報ビュー |
| selection-broker.ts | `deps/v8/tools/turbolizer/src/selection/selection-broker.ts` | TS | 選択伝播 |
| turbo-visualizer.css | `deps/v8/tools/turbolizer/css/turbo-visualizer.css` | CSS | メインスタイル |
| turbolizer.js | `deps/v8/tools/turbolizer/build/turbolizer.js` | JS | ビルド済みバンドル |
