# 画面設計書 5-Turbolizer Info View

## 概要

本ドキュメントは、Turbolizer Info Viewの画面設計について記述する。Turbolizer Info ViewはTurbolizerのキーボードショートカットヘルプ画面であり、各種操作のリファレンスを提供する。

### 本画面の処理概要

**業務上の目的・背景**：Turbolizerは多くのキーボードショートカットと操作を持つ複雑なツールである。開発者が効率的にツールを使用するためには、利用可能なショートカットと操作方法を参照できるヘルプ画面が必要である。本画面は、グローバルショートカット、Sea of Nodesグラフ操作、Turboshaftグラフ操作、検索機能などのリファレンスを提供する。

**画面へのアクセス方法**：
1. Turbolizerのソースタブ内「Info」タブをクリック

**主要な操作・処理内容**：
1. 各カテゴリのキーボードショートカットを参照
2. 操作説明を確認
3. 検索パターンの使用例を確認
4. Turboshaft操作エフェクトの凡例を確認

**画面遷移**：
- 遷移元：Turbolizer（Infoタブクリック）
- 遷移先：なし（Turbolizer内の内部ビュー）

**権限による表示制御**：本画面は認証・権限制御を持たない。全てのユーザーが同一のコンテンツを閲覧できる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | v8 | 補助機能 | Turbolizerのキーボードショートカットとグラフ操作ヘルプ情報の表示 |

## 画面種別

ヘルプ / ドキュメント

## URL/ルーティング

```
/deps/v8/tools/turbolizer/info-view.html
```

※ Turbolizer内で動的に読み込まれる内部HTMLコンテンツ

## 入出力項目

本画面は静的なヘルプコンテンツのため、入出力項目はなし。

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| - | - | - | - | - |

## 表示項目

### ヘッダー

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 説明文 | テキスト | キーボードショートカットヘルプの説明 |

### Global shortcuts セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| info-global | DIV | グローバルショートカットのセクション |
| ショートカットテーブル | TABLE | キーと動作の対応表 |

| キー | 動作 |
|-----|------|
| CTRL+L | ファイル選択ダイアログを開く |
| CTRL+R | Turbolizerをリロード（Chromeショートカット） |

### Sea of Nodes/Turboshaft graph view セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| info-common-graph-view | DIV | 共通グラフ操作のセクション |
| ショートカットテーブル | TABLE | キーと動作の対応表 |

| キー | 動作 |
|-----|------|
| r | グラフ再レイアウト |
| n | 選択ノードの次フェーズを表示 |
| b | 選択ノードの前フェーズを表示 |
| h | ホバーノードの履歴を表示 |
| a | 全ノード選択 |
| / | 検索ボックスを選択 |

### Sea of Nodes graph view セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| info-graph-view | DIV | Sea of Nodes固有操作のセクション |
| ショートカットテーブル | TABLE | キーと動作の対応表 |

| キー | 動作 |
|-----|------|
| i | ノードの入力ノードを表示 |
| o | ノードの出力ノードを表示 |
| s | 選択ノードを非表示 |
| u | 非選択ノードを非表示 |

### Turboshaft graph view セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| info-turboshaft-graph-view | DIV | Turboshaft固有操作のセクション |
| ショートカットテーブル | TABLE | キーと動作の対応表 |

| キー | 動作 |
|-----|------|
| i | 選択ブロックの全ノード選択 |
| p | 選択ブロックを折りたたみ |
| s | 選択ブロックを展開 |
| c | ホバーノード情報をコピー |
| y | ホバーノードの未使用ブロックを折りたたみ |
| u | 選択ノードの未使用ブロックを折りたたみ |

### Sea of Nodes/Turboshaft graph nodes セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| info-common-nodes | DIV | ノード選択変換操作のセクション |
| 説明テキスト | テキスト | 選択変換の説明 |
| ショートカットテーブル | TABLE | キーと動作の対応表 |

| キー | 動作 |
|-----|------|
| UP | 全入力ノード選択 |
| DOWN | 全出力ノード選択 |

### Sea of Nodes graph nodes セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| info-graph-nodes | DIV | Sea of Nodesノード固有操作のセクション |
| ショートカットテーブル | TABLE | キーと動作の対応表 |

| キー | 動作 |
|-----|------|
| 1-9 | 入力ノード1-9を選択 |
| CTRL+1-9 | 入力エッジ1-9をトグル |
| c | 制御出力ノード選択 |
| e | エフェクト出力ノード選択 |
| p | オリジンノード選択 |

### Sea of Nodes/Turboshaft graph search セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| info-graph-search | DIV | 検索機能のセクション |
| ショートカットテーブル | TABLE | キーと動作の対応表 |
| パターン例テーブル | TABLE | 有用な検索パターン例 |

| キー | 動作 |
|-----|------|
| ENTER | 正規表現で検索実行 |
| CTRL+ENTER | 非表示ノードも含めて検索 |

| パターン | 説明 |
|---------|------|
| IfTrue | タイトル/説明にIfTrueを含むノード |
| ^42: | ID 42のノードを正確に選択 |
| Origin: #42 | ノード42から派生したノード |

### Turboshaft operation effects セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| info-ts-graph | DIV | Turboshaft操作エフェクトのセクション |
| エフェクト凡例テーブル | TABLE | エフェクト記号と意味の対応表 |
| ディメンションテーブル | TABLE | ディメンション記号と意味の対応表 |

| 記号 | 意味 |
|-----|------|
| (空) | produce/consumeなし: 自由に並べ替え可能 |
| (produce) | produce: 同ディメンションのconsumeの後に移動不可 |
| (consume) | consume: 同ディメンションのproduceの前に移動不可 |
| (both) | produce and consume |

## イベント仕様

本画面は静的HTMLコンテンツのため、インタラクティブなイベントはなし。

### 1-Infoタブ表示

**トリガー**: TurbolizerのInfoタブクリック

**処理フロー**:
1. InfoViewクラスがinfo-view.htmlの内容を読み込み
2. infoContainerにHTMLを挿入
3. タブがアクティブ状態になる

## データベース更新仕様

本画面はデータベース操作なし。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

本画面はメッセージ表示機能を持たない。

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| - | - | - | - |

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| info-view.html読み込み失敗 | 空のInfoビューが表示される |

## 備考

- 本画面はTurbolizerに組み込まれた内部HTMLフラグメント
- CSSはTurbolizerのメインCSSを継承
- info-topicクラスで各セクションをスタイリング
- 特殊文字（ダイス記号）でTurboshaftエフェクトを表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: HTML構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | info-view.html | `deps/v8/tools/turbolizer/info-view.html` | ヘルプコンテンツの構造 |

**読解のコツ**: info-topic クラスで各セクションが区切られ、info-topic-header と info-topic-content で構成される。

**主要処理フロー**:
1. **Line 1**: 説明テキスト
2. **Lines 2-16**: info-global - グローバルショートカット
3. **Lines 17-47**: info-common-graph-view - 共通グラフ操作
4. **Lines 48-70**: info-graph-view - Sea of Nodes操作
5. **Lines 71-101**: info-turboshaft-graph-view - Turboshaft操作
6. **Lines 102-119**: info-common-nodes - ノード選択変換
7. **Lines 120-146**: info-graph-nodes - Sea of Nodesノード操作
8. **Lines 147-228**: info-graph-search - 検索機能

#### Step 2: InfoViewクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | info-view.ts | `deps/v8/tools/turbolizer/src/views/info-view.ts` | InfoViewクラスの実装 |

**主要処理フロー**:
- InfoViewクラスがinfo-view.htmlを読み込み
- 親コンテナにHTMLを挿入
- show()メソッドで表示

#### Step 3: Turbolizerからの呼び出しを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | turbo-visualizer.ts | `deps/v8/tools/turbolizer/src/turbo-visualizer.ts` | Infoタブの初期化 |

**主要処理フロー**:
- **turbo-visualizer.ts Lines 36-41**: Infoタブの作成とInfoViewの初期化

### プログラム呼び出し階層図

```
turbo-visualizer.ts
    │
    └── Tabs (sourceTabs)
            │
            ├── addTabAndContent("Info")
            │       └── infoContainer
            │
            └── InfoView
                    │
                    └── info-view.html (HTMLコンテンツ)
                            │
                            ├── info-global
                            ├── info-common-graph-view
                            ├── info-graph-view
                            ├── info-turboshaft-graph-view
                            ├── info-common-nodes
                            ├── info-graph-nodes
                            └── info-graph-search
```

### データフロー図

```
[入力]               [処理]                    [出力]

Infoタブクリック ───> InfoView.show() ───────> HTMLコンテンツ表示
                          │
                          └───> info-view.html読み込み
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| info-view.html | `deps/v8/tools/turbolizer/info-view.html` | HTML | ヘルプコンテンツ |
| info-view.ts | `deps/v8/tools/turbolizer/src/views/info-view.ts` | TS | InfoViewクラス |
| turbo-visualizer.ts | `deps/v8/tools/turbolizer/src/turbo-visualizer.ts` | TS | Infoタブ初期化 |
| tabs.ts | `deps/v8/tools/turbolizer/src/tabs.ts` | TS | タブ管理 |
