# 画面設計書 6-Heap Statistics

## 概要

本ドキュメントは、V8 Heap Statisticsの画面設計について記述する。Heap StatisticsはV8ヒープメモリ使用状況の統計・グラフ表示ツールであり、`--trace-gc-object-stats`フラグで収集したオブジェクト統計データを可視化する。

### 本画面の処理概要

**業務上の目的・背景**：V8のヒープメモリ管理を理解し最適化するためには、オブジェクトタイプ別のメモリ使用量を時系列で追跡する必要がある。本画面は、GC（ガベージコレクション）イベント時に収集されたヒープ統計データをグローバルタイムライン、詳細選択、ヒストグラムの形式で可視化し、メモリリークやメモリ使用パターンの分析を支援する。

**画面へのアクセス方法**：
1. V8 Tools Landing Pageから「Heap Stats」カードをクリック
2. ブラウザでdeps/v8/tools/heap-stats/index.htmlを直接開く

**主要な操作・処理内容**：
1. トレースファイル（v8出力、results.html、trace.json.gzip）をアップロード
2. グローバルタイムラインで全期間のメモリ使用量推移を確認
3. 詳細選択で特定のオブジェクトタイプや時間範囲を選択
4. ヒストグラムビューワーでオブジェクト分布を確認

**画面遷移**：
- 遷移元：V8 Tools Landing Page
- 遷移先：なし（単一画面アプリケーション）

**権限による表示制御**：本画面は認証・権限制御を持たない。全てのユーザーが同一のコンテンツを閲覧できる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | v8 | 主機能 | V8ヒープメモリ使用状況の統計・グラフ表示（--trace-gc-object-stats） |
| 29 | perf_hooks | 補助機能 | GC統計のタイムライン表示とヒストグラム分析 |
| 1 | fs | 補助機能 | トレースファイル（results.html、trace.json.gzip）の読み込み |

## 画面種別

分析 / ビジュアライザー

## URL/ルーティング

```
/deps/v8/tools/heap-stats/index.html
```

## 入出力項目

### 入力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| トレースファイル | 入力 | File | 必須 | V8出力、results.html、またはtrace.json.gzipファイル |

### 出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| グローバルタイムライン | 出力 | Chart | メモリ使用量の時系列グラフ |
| 詳細選択 | 出力 | Widget | オブジェクトタイプ・時間範囲の選択UI |
| ヒストグラム | 出力 | Chart | オブジェクト分布のヒストグラム |

## 表示項目

### ヘッダー

| 項目名 | 型 | 説明 |
|--------|-----|------|
| タイトル | H1 | "V8 Heap Statistics" |

### ファイル読み込みセクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| trace-file-reader | カスタム要素 | ファイルドラッグ＆ドロップ・選択エリア |

### 詳細選択セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| details-selection | カスタム要素 | オブジェクトタイプ・時間範囲選択 |

### グローバルタイムラインセクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| global-timeline | カスタム要素 | メモリ使用量の時系列グラフ |

### ヒストグラムビューワーセクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| histogram-viewer | カスタム要素 | オブジェクト分布ヒストグラム |

### 使用方法説明セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 使用方法説明 | テキスト | データ収集方法の説明 |
| --trace-gc-object-stats | コード | V8フラグ説明 |
| Chrome tracing | リンク | Chromeトレーシング方法へのリンク |
| 追加情報 | リスト | --gc-global、--gc-intervalフラグの説明 |

## イベント仕様

### 1-ファイルアップロード

**トリガー**: trace-file-readerへのファイルドロップまたは選択

**処理フロー**:
1. trace-file-readerのonchangeイベント発火
2. globalDataChanged(event) 呼び出し
3. state.dataにデータ設定
4. selectionをnullにリセット
5. global-timeline、histogram-viewer、details-selectionにデータをバインド
6. console.logでデータ出力（デバッグ用）

### 2-選択変更

**トリガー**: details-selectionでの選択操作

**処理フロー**:
1. details-selectionのonchangeイベント発火
2. globalSelectionChangedA(event) 呼び出し
3. state.selectionに選択情報を設定
4. global-timeline、histogram-viewerのselectionプロパティを更新
5. console.logで選択情報出力（デバッグ用）

## データベース更新仕様

本画面はクライアントサイドのみで動作し、データベース操作はなし。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし（ローカルファイル処理のみ） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| - | - | - | エラーメッセージはコンソールに出力 |

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| 不正なファイル形式 | パースエラー、処理中断 |
| CORS制限 | Webサーバー経由でのアクセスが必要 |
| 大容量ファイル | pako.jsでgzip解凍、oboe.jsでストリーム処理 |

## 備考

- Google Chartsライブラリ（line、corechart、bar）を使用
- pako.jsでgzip解凍に対応
- oboe.jsでJSONストリーミング処理に対応
- CORSの関係でWebサーバー経由でのアクセスが必要
- データポイントは主要GC時のみ取得される（--gc-globalで強制可能）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

V8ヒープ統計データの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | helper.js | `deps/v8/tools/heap-stats/helper.js` | ヘルパー関数 |

**読解のコツ**: トレースデータにはGCイベントごとのオブジェクトタイプ別メモリ使用量が含まれる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `deps/v8/tools/heap-stats/index.html` | HTML構造、インラインスクリプト |

**主要処理フロー**:
1. **Lines 12-17**: 外部ライブラリ読み込み（Google Charts、pako、oboe）
2. **Lines 23-26**: カスタム要素モジュール読み込み
3. **Lines 39**: Google Charts初期化
4. **Lines 41-46**: ヘルパー関数（$、removeAllChildren）
5. **Lines 48**: state オブジェクト初期化
6. **Lines 50-61**: globalDataChanged() - データ変更ハンドラ
7. **Lines 63-68**: globalSelectionChangedA() - 選択変更ハンドラ

#### Step 3: カスタム要素を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | trace-file-reader.js | `deps/v8/tools/heap-stats/trace-file-reader.js` | ファイル読み込みUI |
| 3-2 | details-selection.js | `deps/v8/tools/heap-stats/details-selection.js` | 詳細選択UI |
| 3-3 | global-timeline.js | `deps/v8/tools/heap-stats/global-timeline.js` | タイムライングラフ |
| 3-4 | histogram-viewer.js | `deps/v8/tools/heap-stats/histogram-viewer.js` | ヒストグラム表示 |

### プログラム呼び出し階層図

```
index.html
    │
    ├── Google Charts
    │       └── google.charts.load('current', {'packages':['line', 'corechart', 'bar']})
    │
    ├── pako (gzip解凍)
    │
    ├── oboe.js (JSONストリーミング)
    │
    ├── helper.js
    │
    ├── state オブジェクト
    │       ├── data: トレースデータ
    │       └── selection: 選択情報
    │
    └── カスタム要素
            │
            ├── trace-file-reader
            │       └── onchange → globalDataChanged()
            │
            ├── details-selection
            │       └── onchange → globalSelectionChangedA()
            │
            ├── global-timeline
            │       ├── data プロパティ
            │       └── selection プロパティ
            │
            └── histogram-viewer
                    ├── data プロパティ
                    └── selection プロパティ
```

### データフロー図

```
[入力]               [処理]                    [出力]

トレースファイル ───> trace-file-reader ─────> ファイル解析
    ドロップ/選択        │
                        ▼
                   pako.js (gzip解凍)
                        │
                        ▼
                   oboe.js (JSONストリーム)
                        │
                        ▼
                   globalDataChanged()
                        │
                        ├─> state.data
                        │
                        ├─> global-timeline ───> Google Charts (Line)
                        │
                        ├─> histogram-viewer ──> Google Charts (Bar)
                        │
                        └─> details-selection
                                │
                                └─> globalSelectionChangedA()
                                        │
                                        └─> selection更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `deps/v8/tools/heap-stats/index.html` | HTML | メインHTMLファイル |
| helper.js | `deps/v8/tools/heap-stats/helper.js` | JS | ヘルパー関数 |
| trace-file-reader.js | `deps/v8/tools/heap-stats/trace-file-reader.js` | JS | ファイル読み込みカスタム要素 |
| details-selection.js | `deps/v8/tools/heap-stats/details-selection.js` | JS | 詳細選択カスタム要素 |
| global-timeline.js | `deps/v8/tools/heap-stats/global-timeline.js` | JS | タイムラインカスタム要素 |
| histogram-viewer.js | `deps/v8/tools/heap-stats/histogram-viewer.js` | JS | ヒストグラムカスタム要素 |
