# 画面設計書 7-Heap Layout

## 概要

本ドキュメントは、V8 Heap Layoutの画面設計について記述する。Heap LayoutはV8ヒープレイアウトの可視化ツールであり、`--trace-gc-heap-layout`フラグで収集したヒープレイアウトデータを視覚的に表示する。

### 本画面の処理概要

**業務上の目的・背景**：V8のヒープメモリは複数のスペース（新世代、旧世代、コードスペース等）で構成されており、その物理的なレイアウトを理解することはメモリ断片化やGC動作の分析に重要である。本画面は、各スナップショット時点でのヒープレイアウトを可視化し、ヒープサイズの時系列トレンドと組み合わせてメモリ使用パターンを分析できるようにする。

**画面へのアクセス方法**：
1. V8 Tools Landing Pageから「Heap Layout」カードをクリック
2. ブラウザでdeps/v8/tools/heap-layout/index.htmlを直接開く

**主要な操作・処理内容**：
1. トレースファイル（V8出力）をアップロード
2. ヒープサイズトレンドビューワーで時系列変化を確認
3. スナップショット選択（クリックまたはPrev/Nextボタン）
4. ヒープレイアウトビューワーで選択時点のレイアウトを確認

**画面遷移**：
- 遷移元：V8 Tools Landing Page
- 遷移先：なし（単一画面アプリケーション）

**権限による表示制御**：本画面は認証・権限制御を持たない。全てのユーザーが同一のコンテンツを閲覧できる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | v8 | 主機能 | V8ヒープレイアウトの可視化（--trace-gc-heap-layout） |
| 29 | perf_hooks | 補助機能 | ヒープサイズの時系列トレンド表示 |
| 1 | fs | 補助機能 | ヒープレイアウトトレースファイルの読み込み |

## 画面種別

分析 / ビジュアライザー

## URL/ルーティング

```
/deps/v8/tools/heap-layout/index.html
```

## 入出力項目

### 入力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| トレースファイル | 入力 | File | 必須 | --trace-gc-heap-layoutで生成したV8出力 |

### 出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| ヒープサイズトレンド | 出力 | Chart | ヒープサイズの時系列グラフ |
| ヒープレイアウト | 出力 | Chart | 選択時点のヒープレイアウト可視化 |

## 表示項目

### ヘッダー

| 項目名 | 型 | 説明 |
|--------|-----|------|
| タイトル | H1 | "V8 Heap Layout" |

### ファイル読み込みセクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| trace-file-reader | カスタム要素 | ファイルドラッグ＆ドロップ・選択エリア |

### ヒープサイズトレンドセクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| heap-size-trend-viewer | カスタム要素 | ヒープサイズ時系列グラフ（ECharts） |

### ヒープレイアウトセクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| heap-layout-viewer | カスタム要素 | ヒープレイアウト可視化（ECharts） |

### ナビゲーションボタン

| 項目名 | 型 | 説明 |
|--------|-----|------|
| button_prev | Button | 前のスナップショットに移動 |
| button_next | Button | 次のスナップショットに移動 |
| button-container | DIV | ボタンコンテナ（データ読み込み後に表示） |

### 使用方法説明セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 説明テキスト | P | ツールの説明 |
| データ収集方法 | UL | --trace-gc-heap-layoutフラグの説明 |

## イベント仕様

### 1-ファイルアップロード

**トリガー**: trace-file-readerへのファイルドロップまたは選択

**処理フロー**:
1. trace-file-readerのonchangeイベント発火
2. globalDataChanged(event) 呼び出し
3. heap-layout-viewer、heap-size-trend-viewerにデータをバインド
4. button-containerを表示（style.display = 'block'）

### 2-スナップショット選択（トレンドグラフクリック）

**トリガー**: heap-size-trend-viewerでのグラフクリック

**処理フロー**:
1. heap-size-trend-viewerのonchangeイベント発火
2. selectSnapshotAtIndex(event) 呼び出し
3. event.detailからインデックスを取得
4. heap-layout-viewer.drawChart(index) を呼び出し

### 3-Prevボタンクリック

**トリガー**: button_prevクリック

**処理フロー**:
1. OnPrevClick() 呼び出し
2. heap-size-trend-viewer.setXMarkLine(currentIndex - 1)
3. heap-layout-viewer.drawChart(currentIndex - 1)

### 4-Nextボタンクリック

**トリガー**: button_nextクリック

**処理フロー**:
1. OnNextClick() 呼び出し
2. heap-size-trend-viewer.setXMarkLine(currentIndex + 1)
3. heap-layout-viewer.drawChart(currentIndex + 1)

## データベース更新仕様

本画面はクライアントサイドのみで動作し、データベース操作はなし。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし（ローカルファイル処理のみ） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| - | - | - | メッセージ表示なし |

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| 不正なファイル形式 | パースエラー、処理中断 |
| インデックス範囲外 | 境界チェック（currentIndex - 1 / + 1） |

## 備考

- EChartsライブラリを使用してグラフ描画
- ES Modulesを使用したモダンJavaScript構成
- Prev/Nextボタンはデータ読み込み後に表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

V8ヒープレイアウトデータの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | index.html | `deps/v8/tools/heap-layout/index.html` | データフロー概要 |

**読解のコツ**: トレースデータには各GCイベント時点のヒープスペース配置情報が含まれる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `deps/v8/tools/heap-layout/index.html` | HTML構造、インラインスクリプト |

**主要処理フロー**:
1. **Line 12**: EChartsライブラリ読み込み
2. **Lines 14-16**: カスタム要素モジュール読み込み
3. **Line 22**: $ヘルパー関数定義
4. **Lines 24-28**: globalDataChanged() - データ変更ハンドラ
5. **Lines 30-33**: selectSnapshotAtIndex() - スナップショット選択ハンドラ
6. **Lines 36-41**: OnPrevClick() - 前のスナップショット
7. **Lines 43-48**: OnNextClick() - 次のスナップショット

#### Step 3: カスタム要素を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | trace-file-reader.mjs | `deps/v8/tools/heap-layout/trace-file-reader.mjs` | ファイル読み込みUI |
| 3-2 | heap-size-trend-viewer.mjs | `deps/v8/tools/heap-layout/heap-size-trend-viewer.mjs` | ヒープサイズトレンド表示 |
| 3-3 | heap-layout-viewer.mjs | `deps/v8/tools/heap-layout/heap-layout-viewer.mjs` | ヒープレイアウト表示 |

### プログラム呼び出し階層図

```
index.html
    │
    ├── ECharts
    │       └── echarts.min.js
    │
    └── カスタム要素
            │
            ├── trace-file-reader
            │       └── onchange → globalDataChanged()
            │                              │
            │                              ├─> heap-layout-viewer.data = data
            │                              ├─> heap-size-trend-viewer.data = data
            │                              └─> button-container表示
            │
            ├── heap-size-trend-viewer
            │       ├── onchange → selectSnapshotAtIndex()
            │       ├── setXMarkLine(index)
            │       └── currentIndex プロパティ
            │
            └── heap-layout-viewer
                    ├── drawChart(index)
                    └── currentIndex プロパティ
```

### データフロー図

```
[入力]               [処理]                    [出力]

トレースファイル ───> trace-file-reader ─────> ファイル解析
    ドロップ/選択        │
                        ▼
                   globalDataChanged()
                        │
                        ├─> heap-size-trend-viewer ──> ECharts (Line)
                        │           │
                        │           └─> クリック選択
                        │                   │
                        │                   ▼
                        │           selectSnapshotAtIndex()
                        │                   │
                        └─> heap-layout-viewer ─────> ECharts (可視化)
                                    ▲
                                    │
                        Prev/Next ──┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `deps/v8/tools/heap-layout/index.html` | HTML | メインHTMLファイル |
| index.css | `deps/v8/tools/heap-layout/index.css` | CSS | スタイルシート |
| trace-file-reader.mjs | `deps/v8/tools/heap-layout/trace-file-reader.mjs` | JS | ファイル読み込みカスタム要素 |
| heap-size-trend-viewer.mjs | `deps/v8/tools/heap-layout/heap-size-trend-viewer.mjs` | JS | ヒープサイズトレンドカスタム要素 |
| heap-layout-viewer.mjs | `deps/v8/tools/heap-layout/heap-layout-viewer.mjs` | JS | ヒープレイアウトカスタム要素 |
