# 画面設計書 8-Zone Statistics

## 概要

本ドキュメントは、V8 Zone Statisticsの画面設計について記述する。Zone StatisticsはV8 Zoneメモリ使用量の統計・タイムライン表示ツールであり、`--trace-zone-stats`フラグで収集したZone統計データを可視化する。

### 本画面の処理概要

**業務上の目的・背景**：V8のZoneはコンパイル時やパース時に使用される一時的なメモリアロケータである。Zone メモリの使用パターンを理解することで、コンパイル時のメモリ消費を最適化し、メモリ関連の問題を診断できる。本画面は、Zone統計データをタイムライン形式で可視化し、Zoneごとのメモリ使用量の推移を分析できるようにする。

**画面へのアクセス方法**：
1. V8 Tools Landing Pageから「Zone Stats」カードをクリック
2. ブラウザでdeps/v8/tools/zone-stats/index.htmlを直接開く

**主要な操作・処理内容**：
1. トレースファイル（V8出力、Chrome tracing）をアップロード
2. グローバルタイムラインで全期間のZoneメモリ使用量推移を確認
3. 詳細選択で特定のZoneや時間範囲を選択

**画面遷移**：
- 遷移元：V8 Tools Landing Page
- 遷移先：なし（単一画面アプリケーション）

**権限による表示制御**：本画面は認証・権限制御を持たない。全てのユーザーが同一のコンテンツを閲覧できる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | v8 | 主機能 | V8 Zoneメモリ使用量の統計・タイムライン表示（--trace-zone-stats） |
| 29 | perf_hooks | 補助機能 | Zoneメモリ使用量の時系列グラフ表示 |
| 1 | fs | 補助機能 | Zoneトレースファイルの読み込み |

## 画面種別

分析 / ビジュアライザー

## URL/ルーティング

```
/deps/v8/tools/zone-stats/index.html
```

## 入出力項目

### 入力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| トレースファイル | 入力 | File | 必須 | --trace-zone-statsまたはChrome tracingで収集したファイル |

### 出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| グローバルタイムライン | 出力 | Chart | Zoneメモリ使用量の時系列グラフ |
| 詳細選択 | 出力 | Widget | Zone・時間範囲の選択UI |

## 表示項目

### ヘッダー

| 項目名 | 型 | 説明 |
|--------|-----|------|
| タイトル | H1 | "V8 Zone memory usage statistics" |

### ファイル読み込みセクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| trace-file-reader | カスタム要素 | ファイルドラッグ＆ドロップ・選択エリア |

### 詳細選択セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| details-selection | カスタム要素 | Zone・時間範囲選択 |

### グローバルタイムラインセクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| global-timeline | カスタム要素 | Zoneメモリ使用量の時系列グラフ |

### 使用方法説明セクション

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 説明テキスト | P | ツールの説明 |
| --trace-zone-stats | コード | V8フラグ説明 |
| Chrome tracing | リンク | Chromeトレーシング方法へのリンク |
| v8.zone_stats | コード | Chromeトレーシングカテゴリ |
| CORS注意事項 | P | Webサーバー必要の説明 |

## イベント仕様

### 1-ファイルアップロード

**トリガー**: trace-file-readerへのファイルドロップまたは選択

**処理フロー**:
1. trace-file-readerのonchangeイベント発火
2. globalDataChanged(event) 呼び出し
3. state.dataにデータ設定
4. selectionをnullにリセット
5. global-timeline、details-selectionにデータをバインド
6. console.logでデータ出力（デバッグ用）

### 2-選択変更

**トリガー**: details-selectionでの選択操作

**処理フロー**:
1. details-selectionのonchangeイベント発火
2. globalSelectionChangedA(event) 呼び出し
3. state.selectionに選択情報を設定
4. global-timelineのselectionプロパティを更新
5. console.logで選択情報出力（デバッグ用）

## データベース更新仕様

本画面はクライアントサイドのみで動作し、データベース操作はなし。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし（ローカルファイル処理のみ） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| - | - | - | エラーメッセージはコンソールに出力 |

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| 不正なファイル形式 | パースエラー、処理中断 |
| CORS制限 | Webサーバー経由でのアクセスが必要 |
| 大容量ファイル | pako.jsでgzip解凍、oboe.jsでストリーム処理 |

## 備考

- Google Chartsライブラリ（line、corechart、bar）を使用
- pako.jsでgzip解凍に対応
- oboe.jsでJSONストリーミング処理に対応
- CORSの関係でWebサーバー経由でのアクセスが必要
- Heap Statisticsと同様の構成だがhistogram-viewerがない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

V8 Zone統計データの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | helper.js | `deps/v8/tools/zone-stats/helper.js` | ヘルパー関数 |

**読解のコツ**: トレースデータにはZoneごとのメモリ割り当て・解放情報が含まれる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `deps/v8/tools/zone-stats/index.html` | HTML構造、インラインスクリプト |

**主要処理フロー**:
1. **Lines 12-17**: 外部ライブラリ読み込み（Google Charts、pako、oboe）
2. **Lines 23-25**: カスタム要素モジュール読み込み
3. **Line 38**: Google Charts初期化
4. **Lines 40-45**: ヘルパー関数（$、removeAllChildren）
5. **Line 48**: state オブジェクト初期化
6. **Lines 50-58**: globalDataChanged() - データ変更ハンドラ
7. **Lines 60-64**: globalSelectionChangedA() - 選択変更ハンドラ

#### Step 3: カスタム要素を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | trace-file-reader.js | `deps/v8/tools/zone-stats/trace-file-reader.js` | ファイル読み込みUI |
| 3-2 | details-selection.js | `deps/v8/tools/zone-stats/details-selection.js` | 詳細選択UI |
| 3-3 | global-timeline.js | `deps/v8/tools/zone-stats/global-timeline.js` | タイムライングラフ |

### プログラム呼び出し階層図

```
index.html
    │
    ├── Google Charts
    │       └── google.charts.load('current', {'packages':['line', 'corechart', 'bar']})
    │
    ├── pako (gzip解凍)
    │
    ├── oboe.js (JSONストリーミング)
    │
    ├── helper.js
    │
    ├── state オブジェクト
    │       ├── data: トレースデータ
    │       └── selection: 選択情報
    │
    └── カスタム要素
            │
            ├── trace-file-reader
            │       └── onchange → globalDataChanged()
            │
            ├── details-selection
            │       └── onchange → globalSelectionChangedA()
            │
            └── global-timeline
                    ├── data プロパティ
                    └── selection プロパティ
```

### データフロー図

```
[入力]               [処理]                    [出力]

トレースファイル ───> trace-file-reader ─────> ファイル解析
    ドロップ/選択        │
                        ▼
                   pako.js (gzip解凍)
                        │
                        ▼
                   oboe.js (JSONストリーム)
                        │
                        ▼
                   globalDataChanged()
                        │
                        ├─> state.data
                        │
                        ├─> global-timeline ───> Google Charts (Line)
                        │
                        └─> details-selection
                                │
                                └─> globalSelectionChangedA()
                                        │
                                        └─> selection更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `deps/v8/tools/zone-stats/index.html` | HTML | メインHTMLファイル |
| helper.js | `deps/v8/tools/zone-stats/helper.js` | JS | ヘルパー関数 |
| trace-file-reader.js | `deps/v8/tools/zone-stats/trace-file-reader.js` | JS | ファイル読み込みカスタム要素 |
| details-selection.js | `deps/v8/tools/zone-stats/details-selection.js` | JS | 詳細選択カスタム要素 |
| global-timeline.js | `deps/v8/tools/zone-stats/global-timeline.js` | JS | タイムラインカスタム要素 |
