# 画面設計書 9-Callstats

## 概要

本ドキュメントは、V8 Callstats（Runtime Call Stats Komparator）の画面設計について記述する。CallstatsはV8ランタイムコール統計のビジュアライズ・比較ツールであり、複数のプロファイルを読み込んで比較分析を行うことができる。

### 本画面の処理概要

**業務上の目的・背景**：V8のランタイム関数呼び出しのパフォーマンスを分析するためには、どのランタイム関数がどれだけの時間を消費しているかを把握する必要がある。本画面は、ランタイムコール統計データを読み込み、複数のバージョンやプロファイル間で比較することで、パフォーマンスの改善・劣化を特定できるようにする。

**画面へのアクセス方法**：
1. V8 Tools Landing Pageから「Callstats」カードをクリック
2. ブラウザでdeps/v8/tools/callstats.htmlを直接開く

**主要な操作・処理内容**：
1. ランタイム統計データファイルをアップロード
2. ベースラインを選択して比較分析
3. カテゴリ別、関数別でデータをフィルタリング
4. 詳細ポップオーバーで関数の詳細情報を確認
5. ページ詳細テーブルでページ別の統計を確認

**画面遷移**：
- 遷移元：V8 Tools Landing Page
- 遷移先：なし（単一画面アプリケーション）

**権限による表示制御**：本画面は認証・権限制御を持たない。全てのユーザーが同一のコンテンツを閲覧できる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | v8 | 主機能 | V8ランタイムコール統計のビジュアライズ・比較ツール |
| 29 | perf_hooks | 補助機能 | コール統計のパフォーマンス分析・比較 |

## 画面種別

分析 / 比較ツール

## URL/ルーティング

```
/deps/v8/tools/callstats.html
```

## 入出力項目

### 入力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| ランタイム統計ファイル | 入力 | File | 必須 | V8ランタイムコール統計データファイル |

### 出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| 統計リスト | 出力 | Table | ランタイム関数の統計一覧 |
| 比較ビュー | 出力 | Table | 複数プロファイルの比較表 |
| ポップオーバー | 出力 | DIV | 関数詳細情報のポップアップ |

## 表示項目

### ヘッダー

| 項目名 | 型 | 説明 |
|--------|-----|------|
| タイトル | TITLE | "V8 Runtime Call Stats Komparator" |

### 入力パネル（常に表示）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| inputs | DIV | ファイル入力・設定エリア |

### カラム表示

| 項目名 | 型 | 説明 |
|--------|-----|------|
| column | DIV | 統計データのカラム表示 |
| header | DIV | カラムヘッダー |
| list | TABLE | 統計リストテーブル |

### リストテーブル構造

| 項目名 | 型 | 説明 |
|--------|-----|------|
| parent行 | TR | 親カテゴリ行 |
| child行 | TR | 子関数行（展開時表示） |
| position | TD | 順位 |
| name | TD | 関数/カテゴリ名 |
| value | TD | 統計値 |
| codeSearch | リンク | コードサーチリンク |

### ベースライン選択

| 項目名 | 型 | 説明 |
|--------|-----|------|
| baseline | SELECT | ベースラインバージョン選択 |

### ページ詳細テーブル

| 項目名 | 型 | 説明 |
|--------|-----|------|
| pageDetailTable | TABLE | ページ別詳細統計 |

### ポップオーバー

| 項目名 | 型 | 説明 |
|--------|-----|------|
| popover | DIV | 関数詳細ポップオーバー |

### パネルグループ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| panel-group | DIV | パネルのグリッドレイアウト |

## イベント仕様

### 1-ファイルアップロード

**トリガー**: ファイル入力での選択

**処理フロー**:
1. ファイル読み込み
2. データ解析
3. bodyにloadedクラスを追加
4. パネル表示を有効化

### 2-行クリック（展開/折りたたみ）

**トリガー**: list内のparent行クリック

**処理フロー**:
1. 対応するchild行のvisibleクラスをトグル
2. 展開/折りたたみアイコンを更新

### 3-行選択

**トリガー**: list内の行クリック

**処理フロー**:
1. 行にselectedクラスを追加
2. 他の選択を解除
3. 詳細情報を更新

### 4-ベースライン変更

**トリガー**: baseline SELECT変更

**処理フロー**:
1. 選択されたバージョンをベースラインに設定
2. 比較値を再計算
3. 表示を更新

### 5-ポップオーバー表示

**トリガー**: 関数名ホバー

**処理フロー**:
1. popover要素を表示
2. 関数詳細情報を設定
3. マウス位置に合わせて配置

### 6-ページ詳細選択

**トリガー**: pageDetailTable行クリック

**処理フロー**:
1. 選択ページの詳細を表示
2. 関連統計をハイライト

## データベース更新仕様

本画面はクライアントサイドのみで動作し、データベース操作はなし。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし（ローカルファイル処理のみ） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| - | - | - | エラー時はinputsにerror背景色 |

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| 不正なファイル形式 | エラー状態表示（error クラス） |
| データ解析エラー | inputsに赤背景表示 |

## 備考

- system-analyzerのCSSを共用（system-analyzer/index.css）
- グリッドレイアウト（auto-fill、minmax）でレスポンシブ対応
- ポップオーバーはtransformでマウス位置に追従
- selectedVersionクラスで選択中バージョンを強調

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: HTML/CSS構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | callstats.html | `deps/v8/tools/callstats.html` | HTML構造、インラインCSS |

**読解のコツ**: ファイルサイズが大きいため、主要なセクション（inputs、column、popover）に注目する。

**主要処理フロー**:
1. **Lines 1-200**: CSSスタイル定義
2. **Line 12**: system-analyzer/index.css読み込み
3. **Lines 13-200**: インラインCSS（.panel、.column、.list等）

#### Step 2: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | callstats.html | `deps/v8/tools/callstats.html` | JavaScriptロジック |

**主要処理フロー**:
- ランタイム統計データの構造
- カテゴリ・関数の階層構造
- 比較計算ロジック

#### Step 3: UI/UXを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | callstats.html | `deps/v8/tools/callstats.html` | インタラクション処理 |

**主要処理フロー**:
- 行展開/折りたたみ（.child.visible）
- 選択状態管理（.selected）
- ポップオーバー制御

### プログラム呼び出し階層図

```
callstats.html
    │
    ├── CSS
    │       ├── system-analyzer/index.css (外部)
    │       └── インラインCSS
    │
    ├── inputs セクション
    │       └── ファイル入力
    │
    ├── column セクション
    │       ├── header
    │       └── list (TABLE)
    │               ├── parent行
    │               │       └── クリック → child展開/折りたたみ
    │               └── child行
    │
    ├── baseline SELECT
    │       └── 変更 → 比較再計算
    │
    ├── pageDetailTable
    │       └── クリック → ページ詳細表示
    │
    └── popover
            └── ホバー → 詳細表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

統計ファイル ───────> ファイル読み込み ─────> データ解析
    ファイル選択         │
                        ▼
                   データ構造化
                        │
                        ├─> カテゴリグループ化
                        │
                        ├─> list テーブル生成
                        │
                        └─> ベースライン比較
                                │
                                └─> 差分表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| callstats.html | `deps/v8/tools/callstats.html` | HTML | メインHTMLファイル（JS/CSS含む） |
| index.css | `deps/v8/tools/system-analyzer/index.css` | CSS | 共用スタイルシート |
