---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-V8ToolsLandingPage.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `deps/v8/tools/index.html` (HTMLソースファイル)
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` (画面一覧)
- E-03: `docs/code-to-docs/画面一覧/画面遷移図.md` (画面遷移図)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | V8 Tools Landing PageはV8開発ツール群のポータルページである | E-01 (Line 10: title), E-02 | ○ |
| C-02 | 画面ファイルはdeps/v8/tools/index.htmlに存在する | E-01, E-02 | ○ |
| C-03 | 8つのツールカードが存在する | E-01 (Lines 57-88) | ○ |
| C-04 | System Analyzerへのリンクが存在する | E-01 (Line 58: href="./system-analyzer/index.html") | ○ |
| C-05 | Callstatsへのリンクが存在する | E-01 (Line 62: href="./callstats.html") | ○ |
| C-06 | Heap Statsへのリンクが存在する | E-01 (Line 66: href="./heap-stats/index.html") | ○ |
| C-07 | Heap Layoutへのリンクが存在する | E-01 (Line 69: href="./heap-layout/index.html") | ○ |
| C-08 | Parse Processorへのリンクが存在する | E-01 (Line 74: href="./parse-processor.html") | ○ |
| C-09 | Profviewへのリンクが存在する | E-01 (Line 78: href="./profview/index.html") | ○ |
| C-10 | Turbolizerへのリンクが存在する | E-01 (Line 82: href="./turbolizer/index.html") | ○ |
| C-11 | Zone Statsへのリンクが存在する | E-01 (Line 86: href="./zone-stats/index.html") | ○ |
| C-12 | ダークテーマが適用されている | E-01 (Line 5: class="js dark") | ○ |
| C-13 | グリッドレイアウト（3列）を使用している | E-01 (Lines 18-19: grid-template-columns: auto auto auto) | ○ |
| C-14 | 外部CSSファイルを参照している | E-01 (Line 11: href="//v8.dev/_css/main.css") | ○ |
| C-15 | ヘッダーにV8ロゴとナビゲーションがある | E-01 (Lines 43-54) | ○ |
| C-16 | フッターにGitHubリンクがある | E-01 (Lines 91-95: href="https://github.com/v8/tools") | ○ |
| C-17 | カードホバー時にシャドウエフェクトがある | E-01 (Lines 33-35: .card:hover box-shadow) | ○ |
| C-18 | 機能No.36(v8)が主機能として関連する | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 本画面は単純な静的HTMLであり、全ての主張に根拠が存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 静的HTMLページであり、動的処理やデータベース連携がないため

## 6) レビュアーチェックリスト（最小）
- [ ] HTMLファイル（deps/v8/tools/index.html）の存在を確認
- [ ] 8つのツールリンクが正しい遷移先を指しているか確認
- [ ] 外部CSS（v8.dev）が適用されることを確認
