---
generated_at: 2026-01-30 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-ParseProcessor.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `deps/v8/tools/parse-processor.html` (HTMLソースファイル)
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` (画面一覧)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Parse ProcessorはV8パース・コンパイル・初回実行の分析ツールである | E-01 (Line 11: title), E-02 | ○ |
| C-02 | 画面タイトルは"V8 Parse Processor"である | E-01 (Line 11) | ○ |
| C-03 | H1で"BEHOLD, THIS IS PARSEROR!"と表示される | E-01 (Line 410) | ○ |
| C-04 | --log-function-eventsの使用方法が説明されている | E-01 (Lines 413-414) | ○ |
| C-05 | uploadInputでファイル選択を行う | E-01 (Line 419) | ○ |
| C-06 | countでトレースエントリ数を表示する | E-01 (Line 419) | ○ |
| C-07 | scriptsコンテナでスクリプト一覧を表示する | E-01 (Line 425) | ○ |
| C-08 | resultコンテナで詳細グラフを表示する | E-01 (Line 428) | ○ |
| C-09 | Google Chartsライブラリを使用する | E-01 (Line 113) | ○ |
| C-10 | parse-processor.mjsをインポートする | E-01 (Line 116) | ○ |
| C-11 | loadFile関数でファイル読み込みを行う | E-01 (Lines 128-144) | ○ |
| C-12 | ParseProcessor.processString()でログ解析を行う | E-01 (Lines 137-138) | ○ |
| C-13 | renderParseResults()で結果表示を行う | E-01 (Lines 140, 189-212) | ○ |
| C-14 | IntersectionObserverでグラフの遅延読み込みを行う | E-01 (Lines 202-211) | ○ |
| C-15 | seriesで11種類のメトリクスが定義されている | E-01 (Lines 281-297) | ○ |
| C-16 | script-sizeクラスでスクリプトサイズバーを表示する | E-01 (Lines 73-88, 237-264) | ○ |
| C-17 | .evalクラスでeval由来スクリプトを色分けする | E-01 (Lines 89-91) | ○ |
| C-18 | .streamingクラスでストリーミングコンパイルを色分けする | E-01 (Lines 92-94) | ○ |
| C-19 | selectGraphPointHandler()でグラフポイント選択を処理する | E-01 (Lines 372-386) | ○ |
| C-20 | 機能No.36(v8)、29(perf_hooks)、1(fs)が関連する | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全ての主張にソースコードによる根拠が存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能は全てソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HTMLファイル（deps/v8/tools/parse-processor.html）の存在確認
- [ ] parse-processor.mjs（ES Module）の存在確認
- [ ] ファイルアップロードによるログ解析動作確認
- [ ] Google Chartsによるグラフ表示動作確認
- [ ] グラフポイント選択による関数リスト表示確認
