---
generated_at: 2026-01-30 10:35:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-SystemAnalyzer.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `deps/v8/tools/system-analyzer/index.html` (HTMLソースファイル)
- E-02: `deps/v8/tools/system-analyzer/index.mjs` (メインJSモジュール)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (画面一覧)
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` (画面遷移図)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | System AnalyzerはV8ログファイルを解析する統合Webインターフェースである | E-01 (Line 103), E-03 | ○ |
| C-02 | 画面タイトルはIndiciumである | E-01 (Line 8: title) | ○ |
| C-03 | log-file-readerカスタム要素でファイルを読み込む | E-01 (Line 53), E-02 (Line 26) | ○ |
| C-04 | tick-trackトラックが存在する | E-01 (Line 58) | ○ |
| C-05 | timer-trackトラックが存在する | E-01 (Line 59) | ○ |
| C-06 | map-trackトラックが存在する | E-01 (Line 60) | ○ |
| C-07 | ic-trackトラックが存在する | E-01 (Line 61) | ○ |
| C-08 | deopt-trackトラックが存在する | E-01 (Line 62) | ○ |
| C-09 | code-trackトラックが存在する | E-01 (Line 63) | ○ |
| C-10 | script-panelパネルが存在する | E-01 (Line 67) | ○ |
| C-11 | code-panelパネルが存在する | E-01 (Line 68) | ○ |
| C-12 | map-panelパネルが存在する | E-01 (Line 69) | ○ |
| C-13 | ic-listパネルが存在する | E-01 (Lines 70-90) | ○ |
| C-14 | IC凡例が表示される（0, X, 1, ^, P, N, G） | E-01 (Lines 72-88) | ○ |
| C-15 | キーボードショートカット説明がある | E-01 (Lines 182-216) | ○ |
| C-16 | fileuploadstartイベントでApp.handleFileUploadStart()が呼ばれる | E-02 (Lines 48-49, 343-349) | ○ |
| C-17 | fileuploadchunkイベントでApp.handleFileUploadChunk()が呼ばれる | E-02 (Lines 50-51, 351-353) | ○ |
| C-18 | fileuploadendイベントでApp.handleFileUploadEnd()が呼ばれる | E-02 (Lines 52-53, 355-388) | ○ |
| C-19 | Processorクラスでログを解析する | E-02 (Line 14, 346) | ○ |
| C-20 | 解析完了後containerのクラスがloadedになる | E-02 (Line 385) | ○ |
| C-21 | SelectTimeEventで時間範囲選択を処理する | E-02 (Lines 96, 224-227) | ○ |
| C-22 | SelectionEventでエントリ選択を処理する | E-02 (Lines 92, 147-150) | ○ |
| C-23 | FocusEventでエントリフォーカスを処理する | E-02 (Lines 94, 240-242) | ○ |
| C-24 | エラー時にlog-file-readerにエラー表示される | E-02 (Line 382) | ○ |
| C-25 | 機能No.36(v8)、27(inspector)、29(perf_hooks)、30(trace_events)が関連する | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全ての主張にソースコードまたはドキュメントによる根拠が存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能は全てソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HTMLファイル（deps/v8/tools/system-analyzer/index.html）の存在確認
- [ ] index.mjsのAppクラス初期化処理確認
- [ ] 各カスタム要素（timeline-panel, map-panel等）の存在確認
- [ ] キーボードショートカットの動作確認
- [ ] ファイルアップロード処理のエラーハンドリング確認
